/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileStoreRoot {
    private int chop;
    private boolean isValid = true;
    private IPath localRoot = null;
    private URI root;
    private final IPathVariableManager variableManager;

    FileStoreRoot(URI rootURI, IPath workspacePath) {
        Assert.isNotNull(rootURI);
        Assert.isNotNull(workspacePath);
        this.variableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        this.root = rootURI;
        this.chop = workspacePath.segmentCount();
        this.localRoot = this.toLocalPath(this.root);
    }

    public URI computeURI(IPath workspacePath) {
        IPath childPath = workspacePath.removeFirstSegments(this.chop);
        URI rootURI = this.variableManager.resolveURI(this.root);
        if (childPath.segmentCount() == 0) {
            return rootURI;
        }
        try {
            return EFS.getStore((URI)rootURI).getChild(childPath).toURI();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    IFileStore createStore(IPath workspacePath) throws CoreException {
        IPath childPath = workspacePath.removeFirstSegments(this.chop);
        URI uri = this.variableManager.resolveURI(this.root);
        if (!uri.isAbsolute()) {
            return EFS.getNullFileSystem().getStore(workspacePath);
        }
        IFileStore rootStore = EFS.getStore((URI)uri);
        if (childPath.segmentCount() == 0) {
            return rootStore;
        }
        return rootStore.getChild(childPath);
    }

    boolean isValid() {
        return this.isValid;
    }

    IPath localLocation(IPath workspacePath) {
        if (this.localRoot == null) {
            return null;
        }
        IPath location = workspacePath.segmentCount() <= this.chop ? this.localRoot : this.localRoot.append(workspacePath.removeFirstSegments(this.chop));
        if (!(location = this.variableManager.resolvePath(location)).isAbsolute()) {
            return null;
        }
        return location;
    }

    void setValid(boolean value) {
        this.isValid = value;
    }

    private IPath toLocalPath(URI uri) {
        try {
            File localFile = EFS.getStore((URI)uri).toLocalFile(0, null);
            return localFile == null ? null : new Path(localFile.getAbsolutePath());
        }
        catch (CoreException coreException) {
            return FileUtil.toPath(uri);
        }
    }
}

