/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectstyle.woenvironment.plist.ToHellWithProperties;
import org.objectstyle.woenvironment.util.FileStringScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WOVariables {
    public static final String USER_ROOT = "wo.user.root";
    public static final String USER_FRAMEWORKS = "wo.user.frameworks";
    public static final String LOCAL_ROOT = "wo.local.root";
    public static final String LOCAL_FRAMEWORKS = "wo.local.frameworks";
    public static final String SYSTEM_ROOT = "wo.system.root";
    public static final String SYSTEM_FRAMEWORKS = "wo.system.frameworks";
    public static final String NETWORK_ROOT = "wo.network.root";
    public static final String NETWORK_FRAMEWORKS = "wo.network.frameworks";
    public static final String EXTERNAL_BUILD_ROOT = "wo.external.root";
    public static final String EXTERNAL_BUILD_FRAMEWORKS = "wo.external.frameworks";
    public static final String APPS_ROOT = "wo.apps.root";
    public static final String API_ROOT_KEY = "wo.api.root";
    public static final String BOOTSTRAP_JAR_KEY = "wo.bootstrapjar";
    public static final String WEBOBJECTS_EXTENSIONS = "wo.extensions";
    public static final String WOLIPS_PROPERTIES = "wolips.properties";
    private static Map<File, CachedProperties> _cachedProperties = new HashMap<File, CachedProperties>();
    private Properties _wolipsProperties;
    private File _wolipsPropertiesFile;

    public WOVariables(WOVariables variables, Map<Object, Object> existingProperties) {
        this.init(variables, existingProperties);
    }

    public WOVariables(Map<Object, Object> existingProperties) {
        this.init(null, existingProperties);
    }

    public File getWOLipsPropertiesFile() {
        return this._wolipsPropertiesFile;
    }

    protected File getWOLipsPropertiesFile(String name) {
        File wolipsPropertiesFile = new File(name);
        if (!wolipsPropertiesFile.isAbsolute()) {
            wolipsPropertiesFile = WOVariables.isWindows() ? new File(String.valueOf(System.getenv("APPDATA")) + "\\WOLips\\" + name) : new File(this.userHomeFolder(), "Library/Application Support/WOLips/" + name);
        }
        return wolipsPropertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(WOVariables variables, Map<Object, Object> existingProperties) {
        if (variables == null) {
            String wolipsPropertiesPath;
            this._wolipsProperties = new ToHellWithProperties();
            if (existingProperties != null) {
                wolipsPropertiesPath = (String)existingProperties.get(WOLIPS_PROPERTIES);
                if (wolipsPropertiesPath == null) {
                    wolipsPropertiesPath = (String)existingProperties.get("wolips.global.properties");
                }
            } else {
                wolipsPropertiesPath = System.getProperty(WOLIPS_PROPERTIES);
            }
            if (wolipsPropertiesPath == null) {
                wolipsPropertiesPath = System.getenv(WOLIPS_PROPERTIES);
            }
            File wolipsPropertiesFile = null;
            if (wolipsPropertiesPath != null) {
                wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                if (!this.isValidWOlipsPropertiesFile(wolipsPropertiesFile)) {
                    wolipsPropertiesFile = null;
                }
            } else {
                String environmentName = null;
                String woVersion = null;
                if (existingProperties != null) {
                    environmentName = (String)existingProperties.get("wolips.environment");
                    woVersion = (String)existingProperties.get("wo.version");
                }
                if (woVersion != null && !this.isValidWOlipsPropertiesFile(wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath = environmentName != null ? "wolips." + environmentName + "." + woVersion + ".properties" : "wolips." + woVersion + ".properties"))) {
                    wolipsPropertiesFile = null;
                }
                if (wolipsPropertiesFile == null) {
                    if (environmentName != null) {
                        wolipsPropertiesPath = "wolips." + environmentName + ".properties";
                        wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                        if (!this.isValidWOlipsPropertiesFile(wolipsPropertiesFile)) {
                            wolipsPropertiesPath = WOLIPS_PROPERTIES;
                            wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                        }
                    } else {
                        wolipsPropertiesPath = WOLIPS_PROPERTIES;
                        wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                    }
                }
            }
            this._wolipsPropertiesFile = wolipsPropertiesFile;
            if (this.isValidWOlipsPropertiesFile(this._wolipsPropertiesFile)) {
                CachedProperties cachedProperties;
                Map<File, CachedProperties> map = _cachedProperties;
                synchronized (map) {
                    cachedProperties = _cachedProperties.get(this._wolipsPropertiesFile);
                    if (cachedProperties == null) {
                        cachedProperties = new CachedProperties(this._wolipsPropertiesFile);
                        _cachedProperties.put(this._wolipsPropertiesFile, cachedProperties);
                    }
                }
                cachedProperties.reloadIfNecessary();
                this._wolipsProperties = new ToHellWithProperties();
                this._wolipsProperties.putAll((Map<?, ?>)cachedProperties.properties());
            } else if (this._wolipsProperties == null || this._wolipsProperties.isEmpty()) {
                this.createDefaultProperties();
            }
        } else {
            this._wolipsProperties = new ToHellWithProperties();
            this._wolipsProperties.putAll((Map<?, ?>)variables._wolipsProperties);
        }
        if (existingProperties != null) {
            for (Map.Entry<Object, Object> entry : existingProperties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                this._wolipsProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultProperties() {
        block15: {
            this._wolipsProperties = new ToHellWithProperties();
            String nextRoot = System.getenv("NEXT_ROOT");
            String userHome = System.getProperty("user.home");
            if (userHome == null) {
                userHome = ".";
            }
            if (WOVariables.isWindows()) {
                this._wolipsProperties.setProperty(API_ROOT_KEY, "/Developer/ADC%20Reference%20Library/documentation/WebObjects/Reference/API/");
                if (nextRoot != null) {
                    this._wolipsProperties.setProperty(APPS_ROOT, String.valueOf(nextRoot) + "\\Applications");
                    this._wolipsProperties.setProperty(BOOTSTRAP_JAR_KEY, String.valueOf(nextRoot) + "\\Library\\Application\\wotaskd.woa\\WOBootstrap.jar");
                    this._wolipsProperties.setProperty(LOCAL_ROOT, String.valueOf(nextRoot) + "\\Local");
                    this._wolipsProperties.setProperty(LOCAL_FRAMEWORKS, String.valueOf(nextRoot) + "\\Local\\Library\\Frameworks");
                    this._wolipsProperties.setProperty(SYSTEM_ROOT, nextRoot);
                    this._wolipsProperties.setProperty(SYSTEM_FRAMEWORKS, String.valueOf(nextRoot) + "\\Library\\Frameworks");
                    this._wolipsProperties.setProperty(NETWORK_ROOT, String.valueOf(nextRoot) + "\\Network");
                    this._wolipsProperties.setProperty(NETWORK_FRAMEWORKS, String.valueOf(nextRoot) + "\\Network\\Library\\Frameworks");
                    this._wolipsProperties.setProperty(WEBOBJECTS_EXTENSIONS, String.valueOf(nextRoot) + "\\Extensions");
                }
                this._wolipsProperties.setProperty(USER_ROOT, userHome);
                this._wolipsProperties.setProperty(USER_FRAMEWORKS, String.valueOf(userHome) + "\\Library\\Frameworks");
            } else {
                this._wolipsProperties.setProperty(API_ROOT_KEY, "/Developer/Documentation/DocSets/com.apple.ADC_Reference_Library.WebObjectsReference.docset/Contents/Resources/Documents/documentation/InternetWeb/Reference/WO542Reference");
                this._wolipsProperties.setProperty(APPS_ROOT, "/Library/WebObjects/Applications");
                this._wolipsProperties.setProperty(BOOTSTRAP_JAR_KEY, "/System/Library/WebObjects/JavaApplications/wotaskd.woa/WOBootstrap.jar");
                this._wolipsProperties.setProperty(LOCAL_ROOT, "/");
                this._wolipsProperties.setProperty(LOCAL_FRAMEWORKS, "/Library/Frameworks");
                this._wolipsProperties.setProperty(SYSTEM_ROOT, "/System");
                this._wolipsProperties.setProperty(SYSTEM_FRAMEWORKS, "/System/Library/Frameworks");
                this._wolipsProperties.setProperty(NETWORK_ROOT, "/Network");
                this._wolipsProperties.setProperty(NETWORK_FRAMEWORKS, "/Network/Library/Frameworks");
                this._wolipsProperties.setProperty(USER_ROOT, userHome);
                this._wolipsProperties.setProperty(USER_FRAMEWORKS, String.valueOf(userHome) + "/Library/Frameworks");
                this._wolipsProperties.setProperty(WEBOBJECTS_EXTENSIONS, "/Library/WebObjects/Extensions");
            }
            try {
                File wolipsPropertiesFolder = this._wolipsPropertiesFile.getParentFile();
                if (!wolipsPropertiesFolder.exists() && !wolipsPropertiesFolder.mkdirs()) {
                    throw new IOException("Failed to create the folder '" + wolipsPropertiesFolder + "'.");
                }
                if (wolipsPropertiesFolder.canWrite()) {
                    FileOutputStream wolipsPropertiesStream = new FileOutputStream(this._wolipsPropertiesFile);
                    try {
                        this._wolipsProperties.store(wolipsPropertiesStream, null);
                    }
                    finally {
                        wolipsPropertiesStream.close();
                    }
                    Map<File, CachedProperties> map = _cachedProperties;
                    synchronized (map) {
                        _cachedProperties.remove(this._wolipsPropertiesFile);
                        break block15;
                    }
                }
                throw new IOException("Failed to save the properties to '" + this._wolipsPropertiesFile + "'.");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write " + this._wolipsPropertiesFile + ".", e);
            }
        }
    }

    public boolean isValidWOlipsPropertiesFile(File wolipsPropertiesFile) {
        return wolipsPropertiesFile != null && wolipsPropertiesFile.exists() && !wolipsPropertiesFile.isDirectory();
    }

    public File wolipsPropertiesFile() {
        return this._wolipsPropertiesFile;
    }

    public String externalBuildRoot() {
        return this._wolipsProperties.getProperty(EXTERNAL_BUILD_ROOT);
    }

    public String externalBuildFrameworkPath() {
        String externalBuildRoot;
        String externalBuildFrameworkPath = this._wolipsProperties.getProperty(EXTERNAL_BUILD_FRAMEWORKS);
        if (externalBuildFrameworkPath == null && (externalBuildRoot = this.externalBuildRoot()) != null) {
            externalBuildFrameworkPath = new File(new File(externalBuildRoot, "Library"), "Frameworks").toString();
        }
        return externalBuildFrameworkPath;
    }

    public String localRoot() {
        return this._wolipsProperties.getProperty(LOCAL_ROOT);
    }

    public String localFrameworkPath() {
        String localRoot;
        String localFrameworkPath = this._wolipsProperties.getProperty(LOCAL_FRAMEWORKS);
        if (localFrameworkPath == null && (localRoot = this.localRoot()) != null) {
            localFrameworkPath = new File(new File(localRoot, "Library"), "Frameworks").toString();
        }
        return localFrameworkPath;
    }

    public String systemRoot() {
        return this._wolipsProperties.getProperty(SYSTEM_ROOT);
    }

    public String systemFrameworkPath() {
        String systemRoot;
        String systemFrameworkPath = this._wolipsProperties.getProperty(SYSTEM_FRAMEWORKS);
        if (systemFrameworkPath == null && (systemRoot = this.systemRoot()) != null) {
            systemFrameworkPath = new File(new File(systemRoot, "Library"), "Frameworks").toString();
        }
        return systemFrameworkPath;
    }

    public String networkRoot() {
        return this._wolipsProperties.getProperty(NETWORK_ROOT);
    }

    public String networkFrameworkPath() {
        String networkRoot;
        String networkFrameworkPath = this._wolipsProperties.getProperty(NETWORK_FRAMEWORKS);
        if (networkFrameworkPath == null && (networkRoot = this.networkRoot()) != null) {
            networkFrameworkPath = new File(new File(networkRoot, "Library"), "Frameworks").toString();
        }
        return networkFrameworkPath;
    }

    public String appsRoot() {
        return this._wolipsProperties.getProperty(APPS_ROOT);
    }

    public String boostrapJar() {
        return this._wolipsProperties.getProperty(BOOTSTRAP_JAR_KEY);
    }

    public String referenceApi() {
        return this._wolipsProperties.getProperty(API_ROOT_KEY);
    }

    public String userHomeFolder() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = System.getenv("USERPROFILE");
        }
        if (userHome == null) {
            System.out.println("WOVariables.userHome: No user home directory found.");
        }
        return userHome;
    }

    public String userRoot() {
        return this._wolipsProperties.getProperty(USER_ROOT);
    }

    public String userFrameworkPath() {
        return this._wolipsProperties.getProperty(USER_FRAMEWORKS);
    }

    public static String woProjectFileName() {
        return "PB.project";
    }

    public static String webServerResourcesDirName() {
        return "WebServerResources";
    }

    public String encodePathForFile(File aFile) {
        return this.encodePath(aFile.getPath());
    }

    public String encodePath(String path) {
        String userHome = null;
        String systemRoot = null;
        String localRoot = null;
        String aPath = null;
        try {
            boolean otherRoot;
            localRoot = this.localRoot();
            userHome = this.userRoot();
            systemRoot = this.systemRoot();
            int localRootLength = 0;
            int userHomeLength = 0;
            int systemRootLength = 0;
            if (localRoot != null) {
                localRootLength = localRoot.length();
            }
            if (userHome != null) {
                userHomeLength = userHome.length();
            }
            if (systemRoot != null) {
                systemRootLength = systemRoot.length();
            }
            aPath = this.convertWindowsPath(path);
            if (localRoot != null && aPath.startsWith(localRoot)) {
                otherRoot = false;
                if (localRootLength < userHomeLength && aPath.startsWith(userHome)) {
                    otherRoot = true;
                }
                if (localRootLength < systemRootLength && aPath.startsWith(systemRoot)) {
                    otherRoot = true;
                }
                if (!otherRoot) {
                    if (localRootLength == 1) {
                        String string = "LOCALROOT" + aPath;
                        return string;
                    }
                    String string = "LOCALROOT" + aPath.substring(localRootLength);
                    return string;
                }
            }
            if (userHome != null && aPath.startsWith(userHome)) {
                otherRoot = false;
                if (userHomeLength < systemRootLength && aPath.startsWith(systemRoot)) {
                    otherRoot = true;
                }
                if (!otherRoot) {
                    String string = "HOMEROOT" + aPath.substring(userHomeLength);
                    return string;
                }
            }
            if (systemRoot != null && aPath.startsWith(systemRoot)) {
                String string = "WOROOT" + aPath.substring(systemRootLength);
                return string;
            }
            String string = aPath;
            return string;
        }
        catch (Exception anException) {
            System.out.println("Exception occurred during encoding of the path " + anException);
        }
        finally {
            localRoot = null;
            userHome = null;
            systemRoot = null;
            aPath = null;
        }
        return null;
    }

    private String convertWindowsPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        return FileStringScanner.replace(path, "\\", "/");
    }

    public String getProperty(String aKey) {
        return this._wolipsProperties != null ? this._wolipsProperties.getProperty(aKey) : null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static class CachedProperties {
        private File _propertiesFile;
        private long _lastLoaded;
        private Properties _properties;

        public CachedProperties(File propertiesFile) {
            this._propertiesFile = propertiesFile;
            this._properties = new ToHellWithProperties();
        }

        public void reloadIfNecessary() {
            long lastModified;
            if (this._propertiesFile.exists() && this._lastLoaded != (lastModified = this._propertiesFile.lastModified())) {
                this.reload();
                this._lastLoaded = lastModified;
            }
        }

        public Properties properties() {
            return this._properties;
        }

        public void reload() {
            try {
                this._properties = new ToHellWithProperties();
                this._properties.load(new FileInputStream(this._propertiesFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load " + this._propertiesFile + ".", e);
            }
        }
    }
}

