/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFolderRoot<T extends IFramework>
extends Root<T> {
    private File rootFolder;
    private File frameworksFolder;
    private Set<T> frameworks;

    public AbstractFolderRoot(String shortName, String name, File rootFolder, File frameworksFolder) {
        super(shortName, name);
        this.rootFolder = rootFolder;
        this.frameworksFolder = frameworksFolder;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public File getFrameworksFolder() {
        return this.frameworksFolder;
    }

    protected abstract T createFramework(File var1);

    @Override
    public synchronized Set<T> getFrameworks() {
        if (this.frameworks == null) {
            File[] frameworkFolders;
            this.frameworks = new TreeSet<T>();
            if (this.frameworksFolder != null && this.frameworksFolder.exists() && (frameworkFolders = this.frameworksFolder.listFiles()) != null) {
                File[] fileArray = frameworkFolders;
                int n = frameworkFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    File frameworkFolder = fileArray[n2];
                    String frameworkFolderName = frameworkFolder.getName();
                    if (frameworkFolderName.endsWith(".framework") && new File(frameworkFolder, "Resources/Java").exists()) {
                        this.frameworks.add(this.createFramework(frameworkFolder));
                    }
                    ++n2;
                }
            }
        }
        return this.frameworks;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": name = " + this.getName() + "; folder = " + this.frameworksFolder + "]";
    }
}

