/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.io.File;

public abstract class Dependency {
    public abstract String getProjectFrameworkName();

    public abstract boolean isProject();

    public abstract boolean isWOProject();

    public abstract String getSystemRoot();

    public abstract String getRawPath();

    public abstract String getLocation();

    public boolean isAppleProvided() {
        String location = this.getLocation();
        if (location != null) {
            String systemRootPath = this.getSystemRoot();
            if (systemRootPath != null && location.startsWith(systemRootPath)) {
                return location.indexOf("JavaVM") < 0;
            }
            if (location.indexOf("webobjects" + File.separator + "apple") > 0) {
                return true;
            }
            if (location.indexOf("apple" + File.separator + "webobjects") > 0) {
                return true;
            }
            if (location.indexOf("System" + File.separator + "Library") > 0) {
                return location.indexOf("JavaVM") < 0;
            }
            if (location.indexOf("Apple" + File.separator + "Library") > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isWoa() {
        String location = this.getLocation();
        return location != null && location.indexOf(".woa") > 0;
    }

    public boolean isBuildProject() {
        String location = this.getLocation();
        return location != null && location.indexOf(String.valueOf(File.separator) + "build" + File.separator) > 0;
    }

    public boolean isFrameworkJar() {
        String location = this.getLocation();
        if (location != null) {
            String pattern = "(?i).*?/(\\w+)\\.framework/Resources/Java/.*.jar";
            if (location.replace('\\', '/').matches(pattern)) {
                return true;
            }
        }
        return false;
    }
}

