/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.woenvironment.frameworks.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependencyOrdering<T extends Dependency> {
    private Set<String> projectFrameworkNames;
    private Map<T, String> dependencyFramework;
    private Map<String, List<T>> frameworkDependencies;
    private Map<String, String> addedFrameworkPaths;
    private boolean _includeProjectDependency;
    protected List<T> pendingResult;

    public DependencyOrdering(boolean includeProjectDependency) {
        this._includeProjectDependency = includeProjectDependency;
    }

    protected void initialize() {
        this.projectFrameworkNames = new HashSet<String>();
        this.dependencyFramework = new HashMap<T, String>();
        this.frameworkDependencies = new HashMap<String, List<T>>();
        this.addedFrameworkPaths = new LinkedHashMap<String, String>();
        this.pendingResult = new LinkedList<T>();
    }

    public List<T> orderDependencies(List<T> dependencies) {
        this.initialize();
        for (Dependency dependency : dependencies) {
            String dependencyRawPath = dependency.getRawPath();
            String[] dependencyRawSegments = dependencyRawPath.split("[\\/]");
            dependencyRawPath = this.joinRawPath(dependencyRawSegments);
            String frameworkName = null;
            int frameworkSegment = this.frameworkSegmentForPath(dependencyRawSegments);
            boolean addDependency = false;
            if (frameworkSegment == -1) {
                if (dependency.isProject()) {
                    frameworkName = dependency.getProjectFrameworkName();
                    this.addedFrameworkPaths.put(frameworkName, dependencyRawPath);
                    this.projectFrameworkNames.add(frameworkName);
                }
                addDependency = true;
            } else {
                frameworkName = dependencyRawSegments[frameworkSegment];
                String frameworkPath = this.joinRawPath(dependencyRawSegments, frameworkSegment + 1);
                String previousFrameworkPath = this.addedFrameworkPaths.get(frameworkName);
                if (previousFrameworkPath == null) {
                    addDependency = true;
                    this.addedFrameworkPaths.put(frameworkName, frameworkPath);
                } else if (previousFrameworkPath.equals(frameworkPath)) {
                    addDependency = true;
                }
            }
            if (!addDependency) continue;
            if (frameworkName != null) {
                this.dependencyFramework.put(dependency, frameworkName);
                List<T> thisFrameworkDependencies = this.frameworkDependencies.get(frameworkName);
                if (thisFrameworkDependencies == null) {
                    thisFrameworkDependencies = new LinkedList<T>();
                    this.frameworkDependencies.put(frameworkName, thisFrameworkDependencies);
                }
                thisFrameworkDependencies.add(dependency);
            }
            if (dependency.isWOProject()) {
                this.addWOProject(dependency);
                continue;
            }
            this.pendingResult.add(dependency);
        }
        LinkedList processedDeps = new LinkedList();
        LinkedList otherDeps = new LinkedList();
        LinkedList nonAppleDeps = new LinkedList();
        LinkedList appleDeps = new LinkedList();
        LinkedList<Dependency> projectDeps = new LinkedList<Dependency>();
        LinkedList woaDeps = new LinkedList();
        for (Dependency dependency : this.pendingResult) {
            if (processedDeps.contains(dependency)) continue;
            String frameworkName = this.dependencyFramework.get(dependency);
            if (dependency.isProject()) {
                if (!this._includeProjectDependency && dependency.isWOProject()) continue;
                projectDeps.add(dependency);
                continue;
            }
            if (this.projectFrameworkNames.contains(frameworkName)) continue;
            if (dependency.isAppleProvided()) {
                this.addDependencies(dependency, frameworkName, appleDeps, processedDeps);
                continue;
            }
            if (dependency.isFrameworkJar()) {
                this.addDependencies(dependency, frameworkName, nonAppleDeps, processedDeps);
                continue;
            }
            if (dependency.isBuildProject()) {
                this.addDependencies(dependency, frameworkName, nonAppleDeps, processedDeps);
                continue;
            }
            if (dependency.isWoa()) {
                this.addDependencies(dependency, frameworkName, woaDeps, processedDeps);
                continue;
            }
            this.addDependencies(dependency, frameworkName, otherDeps, processedDeps);
        }
        ArrayList sortedDependencies = new ArrayList();
        if (woaDeps.size() > 0) {
            sortedDependencies.addAll(woaDeps);
        }
        if (projectDeps.size() > 0) {
            sortedDependencies.addAll(projectDeps);
        }
        if (nonAppleDeps.size() > 0) {
            sortedDependencies.addAll(nonAppleDeps);
        }
        if (appleDeps.size() > 0) {
            sortedDependencies.addAll(appleDeps);
        }
        if (otherDeps.size() > 0) {
            sortedDependencies.addAll(otherDeps);
        }
        return sortedDependencies;
    }

    protected void addDependencies(T dependency, String frameworkName, List<T> categorizedDeps, List<T> processedDeps) {
        if (frameworkName == null) {
            categorizedDeps.add(dependency);
            processedDeps.add(dependency);
        } else {
            List<T> thisFrameworkDeps = this.frameworkDependencies.get(frameworkName);
            if (thisFrameworkDeps == null) {
                categorizedDeps.add(dependency);
                processedDeps.add(dependency);
            } else {
                categorizedDeps.addAll(thisFrameworkDeps);
                processedDeps.addAll(thisFrameworkDeps);
            }
        }
    }

    protected abstract void addWOProject(T var1);

    protected String joinRawPath(String[] pathSegments) {
        return this.joinRawPath(pathSegments, pathSegments.length);
    }

    protected String joinRawPath(String[] pathSegments, int length) {
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < length) {
            path.append(pathSegments[i]);
            if (i < length - 1) {
                path.append("/");
            }
            ++i;
        }
        return path.toString();
    }

    protected int frameworkSegmentForPath(String[] pathSegments) {
        int frameworkSegment = -1;
        int segmentNum = 0;
        while (frameworkSegment == -1 && segmentNum < pathSegments.length) {
            String segment = pathSegments[segmentNum];
            if (segment.endsWith(".framework")) {
                frameworkSegment = segmentNum;
            }
            ++segmentNum;
        }
        return frameworkSegment;
    }
}

