/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

public class Version {
    private String _versionStr;

    public Version(String versionStr) {
        this._versionStr = versionStr;
        if (this._versionStr == null) {
            this._versionStr = "";
        }
    }

    public boolean isUndefined() {
        return this._versionStr == null || this._versionStr.length() == 0;
    }

    public String getVersionStr() {
        return this._versionStr;
    }

    public String[] getVersionComponents() {
        String[] versionComponents = this._versionStr.split("[.-]");
        return versionComponents;
    }

    public boolean isAtLeastVersion(int minimumMajor, int minimumMinor) {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        boolean ok = major > minimumMajor ? true : (major == minimumMajor ? minor >= minimumMinor : false);
        return ok;
    }

    public int getMajorVersion() {
        String majorVersionStr;
        int majorVersion = 0;
        String[] versionComponents = this.getVersionComponents();
        if (versionComponents.length >= 1 && (majorVersionStr = versionComponents[0]) != null && majorVersionStr.length() > 0) {
            try {
                majorVersion = Integer.parseInt(versionComponents[0]);
            }
            catch (NumberFormatException e) {
                majorVersion = 0;
            }
        }
        return majorVersion;
    }

    public int getMinorVersion() {
        String[] versionComponents = this.getVersionComponents();
        int minorVersion = 0;
        if (versionComponents.length >= 2) {
            try {
                minorVersion = Integer.parseInt(versionComponents[1]);
            }
            catch (NumberFormatException e) {
                minorVersion = 0;
            }
        }
        return minorVersion;
    }

    public String getPatchVersion() {
        String[] versionComponents = this.getVersionComponents();
        String patchVersion = versionComponents.length >= 3 ? versionComponents[2] : (this.getMajorVersion() == 0 ? this._versionStr : "0");
        return patchVersion;
    }

    public String getBundleVersion() {
        return this.getVersionStr();
    }

    public String getBundleShortVersionString() {
        return String.valueOf(this.getMajorVersion()) + "." + this.getMinorVersion();
    }

    public String toString() {
        return "[Version: " + this._versionStr + "]";
    }
}

