/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.pb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBProject {
    public static final String DEFAULT_APP_PROJECT = "pbindex/woapp/PB.project";
    public static final String DEFAULT_FRAMEWORK_PROJECT = "pbindex/woframework/PB.project";
    public static final String DYNAMIC_CODE_GEN = "DYNAMIC_CODE_GEN";
    public static final String FILESTABLE = "FILESTABLE";
    public static final String CLASSES = "CLASSES";
    public static final String FRAMEWORKS = "FRAMEWORKS";
    public static final String FRAMEWORKSEARCH = "FRAMEWORKSEARCH";
    public static final String OTHER_LINKED = "OTHER_LINKED";
    public static final String OTHER_SOURCES = "OTHER_SOURCES";
    public static final String WOAPP_RESOURCES = "WOAPP_RESOURCES";
    public static final String WOCOMPONENTS = "WO_COMPONENTS";
    public static final String WEB_SERVER_RESOURCES = "WEBSERVER_RESOURCES";
    public static final String PROJECTNAME = "PROJECTNAME";
    public static final String PROJECTTYPE = "PROJECTTYPE";
    public static final String PROJECTVERSION = "PROJECTVERSION";
    public static final String SUBPROJECTS = "SUBPROJECTS";
    public static final String YES = "YES";
    public static final String NO = "NO";
    protected boolean isFramework;
    protected String pathToProjectFile;
    protected Map pbProject;
    protected Map filesTable;

    public PBProject(boolean isFramework) throws IOException, PropertyListParserException {
        this("PB.project", isFramework);
    }

    public PBProject(String pathToProjectFile, boolean isFramework) throws IOException, PropertyListParserException {
        this.pathToProjectFile = pathToProjectFile;
        this.isFramework = isFramework;
        if (pathToProjectFile == null) {
            throw new NullPointerException("Path to project file is null.");
        }
        this.update();
    }

    public String getDefaultTemplate() {
        return this.isFramework ? DEFAULT_FRAMEWORK_PROJECT : DEFAULT_APP_PROJECT;
    }

    public void update() throws IOException, PropertyListParserException {
        File projectFile = null;
        InputStream in = null;
        try {
            projectFile = new File(this.pathToProjectFile);
            in = !projectFile.exists() ? this.getClass().getClassLoader().getResourceAsStream(this.getDefaultTemplate()) : new FileInputStream(projectFile);
            this.pbProject = (Map)WOLPropertyListSerialization.propertyListFromStream(in);
        }
        finally {
            projectFile = null;
            if (in != null) {
                in.close();
            }
            in = null;
        }
        if (this.pbProject == null) {
            throw new IOException("Error reading project file: " + this.pathToProjectFile);
        }
        this.readFilesTable();
    }

    public void saveChanges() throws PropertyListParserException, IOException {
        this.saveFilesTable();
        Map sortedMap = this.sortedMap(this.pbProject);
        File projectFile = null;
        try {
            projectFile = new File(this.pathToProjectFile);
            WOLPropertyListSerialization.propertyListToFile("", projectFile, sortedMap);
        }
        finally {
            projectFile = null;
        }
    }

    private Map sortedMap(Map _map) {
        TreeMap sortedMap = new TreeMap(_map);
        for (Map.Entry entry : sortedMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                entry.setValue(this.sortedList((List)value));
                continue;
            }
            if (!(value instanceof Map)) continue;
            entry.setValue(this.sortedMap((Map)value));
        }
        return sortedMap;
    }

    private List sortedList(List _list) {
        LinkedList<Object> sortedList = new LinkedList<Object>(_list);
        int size = sortedList.size();
        int i = 0;
        while (i < size) {
            Object entry = sortedList.get(i);
            if (entry instanceof List) {
                sortedList.set(i, this.sortedList((List)entry));
            } else if (entry instanceof Map) {
                sortedList.set(i, this.sortedMap((Map)entry));
            }
            ++i;
        }
        Collections.sort(sortedList);
        return sortedList;
    }

    public boolean isDynamicCodeGen() {
        return YES.equals(this.pbProject.get(DYNAMIC_CODE_GEN));
    }

    public void setDynamicCodeGen(boolean aBoolean) {
        String flag = aBoolean ? YES : NO;
        this.pbProject.put(DYNAMIC_CODE_GEN, flag);
    }

    public List getClasses() {
        return (List)this.getFilesTable().get(CLASSES);
    }

    public void setClasses(List anArray) {
        this.getFilesTable().put(CLASSES, anArray);
    }

    public List getWebServerResources() {
        return (List)this.getFilesTable().get(WEB_SERVER_RESOURCES);
    }

    public void setWebServerResources(List anArray) {
        this.getFilesTable().put(WEB_SERVER_RESOURCES, anArray);
    }

    public List getWebServerResources(String language) {
        if (language == null) {
            return this.getWebServerResources();
        }
        return (List)this.getFilesTable().get(String.valueOf(language) + "_" + WEB_SERVER_RESOURCES);
    }

    public void setWebServerResources(List anArray, String language) {
        if (language == null) {
            this.setWebServerResources(anArray);
            return;
        }
        this.getFilesTable().put(String.valueOf(language) + "_" + WEB_SERVER_RESOURCES, anArray);
    }

    public List<String> getFrameworkSearch() {
        return (List)this.pbProject.get(FRAMEWORKSEARCH);
    }

    public void setFrameworkSearch(List anArray) {
        this.pbProject.put(FRAMEWORKSEARCH, anArray);
    }

    public List getFrameworks() {
        return (List)this.getFilesTable().get(FRAMEWORKS);
    }

    public void setFrameworks(List anArray) {
        this.getFilesTable().put(FRAMEWORKS, anArray);
    }

    public List getSubprojects() {
        return (List)this.getFilesTable().get(SUBPROJECTS);
    }

    public void setSubprojects(List anArray) {
        this.getFilesTable().put(SUBPROJECTS, anArray);
    }

    public List getOtherLinked() {
        return (List)this.getFilesTable().get(OTHER_LINKED);
    }

    public void setOtherLinked(List anArray) {
        this.getFilesTable().put(OTHER_LINKED, anArray);
    }

    public List getOtherSources() {
        return (List)this.getFilesTable().get(OTHER_SOURCES);
    }

    public void setOtherSources(List anArray) {
        this.getFilesTable().put(OTHER_SOURCES, anArray);
    }

    public List getWoAppResources() {
        return (List)this.getFilesTable().get(WOAPP_RESOURCES);
    }

    public void setWoAppResources(List anArray) {
        this.getFilesTable().put(WOAPP_RESOURCES, anArray);
    }

    public List getWoAppResources(String language) {
        if (language == null) {
            return this.getWoAppResources();
        }
        return (List)this.getFilesTable().get(String.valueOf(language) + "_" + WOAPP_RESOURCES);
    }

    public void setWoAppResources(List anArray, String language) {
        if (language == null) {
            this.setWoAppResources(anArray);
            return;
        }
        this.getFilesTable().put(String.valueOf(language) + "_" + WOAPP_RESOURCES, anArray);
    }

    public List getWoComponents() {
        return (List)this.getFilesTable().get(WOCOMPONENTS);
    }

    public void setWoComponents(List anArray) {
        this.getFilesTable().put(WOCOMPONENTS, anArray);
    }

    public List getWoComponents(String language) {
        if (language == null) {
            return this.getWoComponents();
        }
        return (List)this.getFilesTable().get(String.valueOf(language) + "_" + WOCOMPONENTS);
    }

    public void setWoComponents(List anArray, String language) {
        if (language == null) {
            this.setWoComponents(anArray);
            return;
        }
        this.getFilesTable().put(String.valueOf(language) + "_" + WOCOMPONENTS, anArray);
    }

    public String getProjectName() {
        return (String)this.pbProject.get(PROJECTNAME);
    }

    public void setProjectName(String aString) {
        this.pbProject.put(PROJECTNAME, aString);
    }

    public String getProjectType() {
        return (String)this.pbProject.get(PROJECTTYPE);
    }

    public void setProjectType(String aString) {
        this.pbProject.put(PROJECTTYPE, aString);
    }

    public String getProjectVersion() {
        return (String)this.pbProject.get(PROJECTVERSION);
    }

    public void setProjectVersion(String aString) {
        this.pbProject.put(PROJECTVERSION, aString);
    }

    protected Map getFilesTable() {
        return this.filesTable;
    }

    protected void saveFilesTable() {
        this.pbProject.put(FILESTABLE, this.filesTable);
    }

    protected void readFilesTable() {
        this.filesTable = (Map)this.pbProject.get(FILESTABLE);
    }

    public void forgetAllFiles() {
        this.setClasses(new ArrayList());
        this.setOtherLinked(new ArrayList());
        this.setOtherSources(new ArrayList());
        this.setWebServerResources(new ArrayList());
        this.setWoComponents(new ArrayList());
    }

    public String getPathToProjectFile() {
        return this.pathToProjectFile;
    }

    public void setPathToProjectFile(String pathToProjectFile) {
        this.pathToProjectFile = pathToProjectFile;
    }
}

