/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.pbx;

import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class PBXItem {
    public static final String _KISA = "isa";
    protected Object ref;

    public PBXItem(Object ref) {
        this.ref = ref;
    }

    private String serializeString(String aString) {
        char[] chars = aString.toCharArray();
        boolean simple = chars.length != 0;
        int i = 0;
        while (i < chars.length & simple) {
            simple = Character.isLetterOrDigit(chars[i]) || chars[i] == '.' || chars[i] == '/' || chars[i] == '_';
            ++i;
        }
        if (!simple) {
            if (!aString.startsWith("<?xml")) {
                aString = aString.replaceAll("\n", "\\\\n");
            }
            aString = String.valueOf('\"') + aString.replaceAll("\"", "\\\\\"") + '\"';
        }
        return aString;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            Field[] fields = this.getClass().getFields();
            TreeSet<Object> keys = new TreeSet<Object>();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getName().startsWith("_K")) {
                    keys.add(fields[i].get(this));
                }
                ++i;
            }
            Iterator iter = keys.iterator();
            writer.write("{\n");
            while (iter.hasNext()) {
                Object k;
                AbstractCollection ks;
                String key = (String)iter.next();
                char[] chars = key.toCharArray();
                chars[0] = Character.toUpperCase(chars[0]);
                String methodName = "get" + new String(chars);
                Method method = this.getClass().getMethod(methodName, null);
                Object ob = method.invoke((Object)this, null);
                if (ob == null) continue;
                if (ob instanceof PBXItem) {
                    ob = ((PBXItem)ob).ref;
                }
                if (ob instanceof Map) {
                    ks = new TreeSet(((Map)ob).keySet());
                    Iterator i2 = ks.iterator();
                    writer.write("\t\t\t" + key + " = {\n");
                    while (i2.hasNext()) {
                        k = i2.next();
                        writer.write("\t\t\t\t" + k + " = " + this.serializeString(((Map)ob).get(k).toString()) + ";\n");
                    }
                    writer.write("\t\t\t};\n");
                    continue;
                }
                if (ob instanceof Collection) {
                    ks = new Vector((Collection)ob);
                    Enumeration e = ((Vector)ks).elements();
                    writer.write("\t\t\t" + key + " = (\n");
                    while (e.hasMoreElements()) {
                        k = e.nextElement();
                        if (k instanceof PBXItem) {
                            k = ((PBXItem)k).ref;
                        }
                        writer.write("\t\t\t\t" + k + ",\n");
                    }
                    writer.write("\t\t\t);\n");
                    continue;
                }
                writer.write("\t\t\t" + key + " = " + this.serializeString(ob.toString()) + ";\n");
            }
            writer.write("\t\t};");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public String getIsa() {
        String isa = this.getClass().toString();
        return isa.substring(isa.lastIndexOf(46) + 1);
    }
}

