/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.pbx;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class PBXProjectCoder {
    protected Map objects;
    protected Map alocatedObjects;
    protected Object root;

    public PBXProjectCoder(Map objects, Object root) {
        this.objects = objects;
        this.root = root;
        this.alocatedObjects = new Hashtable();
    }

    public Map getRef(Object ref) {
        return (Map)this.objects.get(ref);
    }

    public Object objectForRef(Object ref) {
        Object object = null;
        object = this.alocatedObjects.get(ref);
        if (object != null) {
            return object;
        }
        Map dico = this.getRef(ref);
        if (dico == null) {
            return null;
        }
        String isa = (String)dico.get("isa");
        Class<?> newClass = null;
        try {
            newClass = Class.forName(String.valueOf(this.getClass().getPackage().getName()) + "." + isa);
            object = newClass.getConstructor(Object.class).newInstance(ref);
        }
        catch (Exception e) {
            System.err.println("Class not found : " + isa);
            return null;
        }
        for (Object key : dico.keySet()) {
            if (key.equals("isa")) continue;
            Object value = dico.get(key);
            if (value instanceof Collection) {
                Collection array = (Collection)value;
                char[] chars = ((String)key).toCharArray();
                chars[0] = Character.toUpperCase(chars[0]);
                String methodName = "add" + new String(chars);
                Method method = null;
                try {
                    method = newClass.getMethod(methodName, Object.class);
                    Iterator i = array.iterator();
                    Object n = null;
                    while (i.hasNext()) {
                        n = i.next();
                        Object v = this.objectForRef(n);
                        method.invoke(object, v == null ? n : v);
                    }
                }
                catch (Exception e) {
                    System.err.println("Method : " + methodName + " on class [" + isa + "] not found.");
                }
                continue;
            }
            char[] chars = ((String)key).toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            String methodName = "set" + new String(chars);
            Method method = null;
            Object v = null;
            try {
                method = newClass.getMethod(methodName, Object.class);
                v = this.objectForRef(value);
                method.invoke(object, v == null ? value : v);
            }
            catch (Exception e) {
                System.err.println("Method : " + methodName + " on class [" + isa + "] not found.");
            }
        }
        this.alocatedObjects.put(ref, object);
        return object;
    }

    public String serialize() {
        TreeSet sorted = null;
        try {
            sorted = new TreeSet(this.alocatedObjects.keySet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringWriter writer = new StringWriter();
        Iterator iter = sorted.iterator();
        writer.write("// !$*UTF8*$!\n{\n\tarchiveVersion = 1;\n\tclasses = {\n\t};\n\tobjectVersion = 38;\n\tobjects = {\n");
        String oldKey = new String();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (oldKey.equals("")) {
                oldKey = key.substring(0, 2);
            }
            if (!key.startsWith(oldKey)) {
                int i = 0;
                while (i <= 4) {
                    writer.write("//" + oldKey + i + "\n");
                    ++i;
                }
                oldKey = key.substring(0, 2);
                i = 0;
                while (i <= 4) {
                    writer.write("//" + oldKey + i + "\n");
                    ++i;
                }
            }
            writer.write("\t\t" + key + " = " + this.alocatedObjects.get(key) + "\n");
        }
        writer.write("\t};\n");
        writer.write("\trootObject = " + this.root + ";\n");
        writer.write("}\n");
        writer.flush();
        return writer.toString();
    }
}

