/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.plist;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;

public class WOLPropertyListSerialization {
    private WOLPropertyListSerialization() {
        throw new IllegalStateException("Can't instantiate an instance of class " + this.getClass().getName());
    }

    public static String stringFromPropertyList(Object plist) throws PropertyListParserException {
        return _Utilities.stringFromPropertyList(plist);
    }

    public static Object propertyListFromString(String string) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListFromString(string, new SimpleParserDataStructureFactory());
    }

    public static Object propertyListFromString(String string, ParserDataStructureFactory factory) throws PropertyListParserException {
        return _Utilities.propertyListFromString(string, factory);
    }

    public static Object propertyListWithPathURL(URL url, ParserDataStructureFactory factory) throws IOException, PropertyListParserException {
        String string = WOLPropertyListSerialization.stringFromURL(url);
        return WOLPropertyListSerialization.propertyListFromString(string, factory);
    }

    public static Object propertyListWithContentsOfInputStream(InputStream inputStream, ParserDataStructureFactory factory) throws IOException, PropertyListParserException {
        String string = WOLPropertyListSerialization.stringFromInputStream(inputStream);
        return WOLPropertyListSerialization.propertyListFromString(string, factory);
    }

    public static Object propertyListWithContentsOfFile(String path, ParserDataStructureFactory factory) throws IOException, PropertyListParserException {
        return _Utilities.propertyListWithContentsOfFile(path, factory);
    }

    public static String stringFromFile(File f) throws IOException {
        return new String(WOLPropertyListSerialization.bytesFromFile(f));
    }

    public static String stringFromFile(File f, String encoding) throws IOException {
        if (encoding == null) {
            return new String(WOLPropertyListSerialization.bytesFromFile(f));
        }
        return new String(WOLPropertyListSerialization.bytesFromFile(f), encoding);
    }

    public static byte[] bytesFromFile(File f) throws IOException {
        return WOLPropertyListSerialization.bytesFromFile(f, (int)f.length());
    }

    public static byte[] bytesFromFile(File f, int n) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        byte[] data = new byte[n];
        int bytesRead = 0;
        while (bytesRead < n) {
            bytesRead += fis.read(data, bytesRead, n - bytesRead);
        }
        fis.close();
        return data;
    }

    public static byte[] bytesFromInputStream(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("null input stream");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int read = -1;
        byte[] buf = new byte[51200];
        while ((read = in.read(buf)) != -1) {
            bout.write(buf, 0, read);
        }
        return bout.toByteArray();
    }

    public static String stringFromInputStream(InputStream in) throws IOException {
        return new String(WOLPropertyListSerialization.bytesFromInputStream(in));
    }

    public static String stringFromInputStream(InputStream in, String encoding) throws IOException {
        return new String(WOLPropertyListSerialization.bytesFromInputStream(in), encoding);
    }

    public static String stringFromURL(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            String string = WOLPropertyListSerialization.stringFromInputStream(is);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static String stringFromURL(URL url, String encoding) throws IOException {
        InputStream is = url.openStream();
        try {
            String string = WOLPropertyListSerialization.stringFromInputStream(is, encoding);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static Object propertyListFromFile(File f) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithPathURL(f.toURL(), new SimpleParserDataStructureFactory());
    }

    public static Object propertyListFromFile(File f, ParserDataStructureFactory factory) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithPathURL(f.toURL(), factory);
    }

    public static Object propertyListFromURL(URL u, ParserDataStructureFactory factory) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithPathURL(u, factory);
    }

    public static Object propertyListFromStream(InputStream in) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithContentsOfInputStream(in, new SimpleParserDataStructureFactory());
    }

    public static Object propertyListFromStream(InputStream in, ParserDataStructureFactory factory) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithContentsOfInputStream(in, factory);
    }

    /*
     * Unable to fully structure code
     */
    public static void propertyListToFile(String header, File f, Object plist) throws PropertyListParserException, IOException {
        block9: {
            out = null;
            try {
                str = WOLPropertyListSerialization.stringFromPropertyList(plist);
                if (str == null) break block9;
                try {
                    existingPlistContent = WOLPropertyListSerialization.propertyListFromFile(f);
                    newPlistContent = WOLPropertyListSerialization.propertyListFromString(str, new SimpleParserDataStructureFactory());
                    if (existingPlistContent.equals(newPlistContent)) {
                        return;
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception var5_6) {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), Charset.forName("UTF-8")));
                    out.write(str);
                    if (str.length() > 0 && str.charAt(str.length() - 1) != '\n') {
                        out.write(10);
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void propertyListToStream(OutputStream os, Object plist) throws PropertyListParserException, IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
        try {
            String str = WOLPropertyListSerialization.stringFromPropertyList(plist);
            if (str != null) {
                out.write(str);
            }
        }
        finally {
            out.close();
        }
    }

    public static class EMMutableData {
        private ByteArrayOutputStream _stream;

        public EMMutableData(int size) {
            this._stream = new ByteArrayOutputStream(size);
        }

        public EMMutableData(ByteArrayOutputStream stream) {
            this._stream = stream;
        }

        public byte[] bytes() {
            return this._stream.toByteArray();
        }

        public EMMutableData clone() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(this.bytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new EMMutableData(baos);
        }

        public void appendByte(byte b) {
            this._stream.write(b);
        }

        public boolean isEqualToData(EMMutableData data) {
            boolean equal;
            if (data == this) {
                equal = true;
            } else {
                byte[] b2;
                byte[] b1 = this.bytes();
                if (b1.length != (b2 = data.bytes()).length) {
                    equal = false;
                } else {
                    equal = true;
                    int i = 0;
                    while (equal && i < b1.length) {
                        equal = b1[i] == b2[i];
                        ++i;
                    }
                }
            }
            return equal;
        }
    }

    public static class _Utilities {
        public static final String ROOT = "root";
        private int _lineNumber;
        private int _startOfLineCharIndex;
        private static int _savedIndex;
        private static int _savedLineNumber;
        private static int _savedStartOfLineCharIndex;
        private static final int[] NSToPrecompUnicodeTable;

        static {
            NSToPrecompUnicodeTable = new int[]{160, 192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 221, 222, 181, 215, 247, 169, 161, 162, 163, 8260, 165, 402, 167, 164, 8217, 8220, 171, 8249, 8250, 64257, 64258, 174, 8211, 8224, 8225, 183, 166, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 172, 191, 185, 715, 180, 710, 732, 175, 728, 729, 168, 178, 730, 184, 179, 733, 731, 711, 8212, 177, 188, 189, 190, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235, 236, 198, 237, 170, 238, 239, 240, 241, 321, 216, 338, 186, 242, 243, 244, 245, 246, 230, 249, 250, 251, 305, 252, 253, 322, 248, 339, 223, 254, 255, 65533, 65533};
        }

        private void _saveIndexes(int index, int line, int startOfLine) {
            _savedIndex = index;
            _savedLineNumber = line;
            _savedStartOfLineCharIndex = startOfLine;
        }

        private String _savedIndexesAsString() {
            return "line number: " + _savedLineNumber + ", column: " + (_savedIndex - _savedStartOfLineCharIndex);
        }

        public static String stringFromPropertyList(Object plist) throws PropertyListParserException {
            if (plist == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer(128);
            _Utilities._appendObjectToStringBuffer(plist, buffer, 0);
            return buffer.toString();
        }

        public static Object propertyListWithContentsOfFile(String path, ParserDataStructureFactory factory) throws IOException, PropertyListParserException {
            String string = WOLPropertyListSerialization.stringFromFile(new File(path));
            return _Utilities.propertyListFromString(string, factory);
        }

        public static Object propertyListFromString(String string, ParserDataStructureFactory factory) throws PropertyListParserException {
            return new _Utilities()._propertyListFromString(string, factory);
        }

        private Object _propertyListFromString(String string, ParserDataStructureFactory factory) throws PropertyListParserException {
            this._startOfLineCharIndex = 0;
            this._lineNumber = 0;
            if (string == null) {
                return null;
            }
            char[] characters = string.toCharArray();
            Object[] objects = new Object[1];
            this._lineNumber = 1;
            this._startOfLineCharIndex = 0;
            objects[0] = null;
            int index = 0;
            index = this._readObjectIntoObjectReference(characters, index, objects, ROOT, factory);
            if ((index = this._skipWhitespaceAndComments(characters, index)) != -1) {
                throw new PropertyListParserException("The property list contained an object, but it appears to be truncated (line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ").");
            }
            return objects[0];
        }

        private static void _appendObjectToStringBuffer(Object object, StringBuffer buffer, int indentionLevel) throws PropertyListParserException {
            if (object instanceof String) {
                _Utilities._appendStringToStringBuffer((String)object, buffer, indentionLevel);
            } else if (object instanceof StringBuffer) {
                _Utilities._appendStringToStringBuffer(((StringBuffer)object).toString(), buffer, indentionLevel);
            } else if (object instanceof EMMutableData) {
                _Utilities._appendDataToStringBuffer((EMMutableData)object, buffer, indentionLevel);
            } else if (object instanceof List) {
                _Utilities._appendCollectionToStringBuffer((List)object, buffer, indentionLevel);
            } else if (object instanceof Set) {
                _Utilities._appendCollectionToStringBuffer((Set)object, buffer, indentionLevel);
            } else if (object instanceof Map) {
                _Utilities._appendDictionaryToStringBuffer((Map)object, buffer, indentionLevel);
            } else if (object instanceof Boolean) {
                String value = (Boolean)object != false ? "true" : "false";
                _Utilities._appendStringToStringBuffer(value, buffer, indentionLevel);
            } else {
                _Utilities._appendStringToStringBuffer(object.toString(), buffer, indentionLevel);
            }
        }

        protected static String escapeString(String str) {
            char[] chars = str.toCharArray();
            int len = chars.length;
            StringBuffer buf = new StringBuffer(len + 3);
            int i = 0;
            while (i < chars.length) {
                if (chars[i] < '\u0080') {
                    if (chars[i] == '\n') {
                        buf.append("\\n");
                    } else if (chars[i] == '\r') {
                        buf.append("\\r");
                    } else if (chars[i] == '\t') {
                        buf.append("\\t");
                    } else if (chars[i] == '\"') {
                        buf.append("\\\"");
                    } else if (chars[i] == '\\') {
                        buf.append("\\\\");
                    } else if (chars[i] == '\f') {
                        buf.append("\\f");
                    } else if (chars[i] == '\b') {
                        buf.append("\\b");
                    } else if (chars[i] == '\u0007') {
                        buf.append("\\a");
                    } else if (chars[i] == '\u000b') {
                        buf.append("\\v");
                    } else {
                        buf.append(chars[i]);
                    }
                } else {
                    char character = chars[i];
                    byte nibble1 = (byte)(character & 0xF);
                    character = (char)(character >> 4);
                    byte nibble2 = (byte)(character & 0xF);
                    character = (char)(character >> 4);
                    byte nibble3 = (byte)(character & 0xF);
                    character = (char)(character >> 4);
                    byte nibble4 = (byte)(character & 0xF);
                    character = (char)(character >> 4);
                    buf.append("\\U");
                    buf.append(_Utilities._hexDigitForNibble(nibble4));
                    buf.append(_Utilities._hexDigitForNibble(nibble3));
                    buf.append(_Utilities._hexDigitForNibble(nibble2));
                    buf.append(_Utilities._hexDigitForNibble(nibble1));
                }
                ++i;
            }
            return buf.toString();
        }

        private static void _appendStringToStringBuffer(String string, StringBuffer buffer, int indentionLevel) {
            boolean shouldQuote = false;
            char[] chars = string.toCharArray();
            int len = chars.length;
            if (len == 0) {
                shouldQuote = true;
            }
            int i = 0;
            while (!shouldQuote && i < len) {
                char c = chars[i];
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    shouldQuote = true;
                }
                ++i;
            }
            String escapedStr = _Utilities.escapeString(string);
            if (shouldQuote) {
                buffer.append('\"');
                buffer.append(escapedStr);
                buffer.append('\"');
            } else {
                buffer.append(escapedStr);
            }
        }

        private static void _appendDataToStringBuffer(EMMutableData data, StringBuffer buffer, int indentionLevel) {
            buffer.append('<');
            byte[] bytes = data.bytes();
            int i = 0;
            while (i < bytes.length) {
                byte dataByte = bytes[i];
                byte nibble1 = (byte)(dataByte & 0xF);
                dataByte = (byte)(dataByte >> 4);
                byte nibble2 = (byte)(dataByte & 0xF);
                buffer.append(_Utilities._hexDigitForNibble(nibble2));
                buffer.append(_Utilities._hexDigitForNibble(nibble1));
                ++i;
            }
            buffer.append('>');
        }

        private static void _appendCollectionToStringBuffer(Collection collection, StringBuffer buffer, int indentionLevel) throws PropertyListParserException {
            buffer.append('(');
            if (!collection.isEmpty()) {
                int originalLength = buffer.length();
                StringBuffer oneLineBuffer = new StringBuffer(78);
                Iterator iter = collection.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj != null) {
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        buffer.append('\n');
                        _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel + 1);
                        int itemStart = buffer.length();
                        _Utilities._appendObjectToStringBuffer(obj, buffer, indentionLevel + 1);
                        int itemEnd = buffer.length();
                        if (oneLineBuffer != null && oneLineBuffer.length() + (itemEnd - itemStart) < 79) {
                            if (i > 0) {
                                oneLineBuffer.append(", ");
                            }
                            oneLineBuffer.append(buffer.substring(itemStart, itemEnd));
                        } else {
                            oneLineBuffer = null;
                        }
                    }
                    ++i;
                }
                if (oneLineBuffer != null && oneLineBuffer.length() < 78) {
                    buffer.setLength(originalLength);
                    buffer.append(oneLineBuffer);
                } else {
                    buffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel);
                }
            }
            buffer.append(')');
        }

        private static void _appendDictionaryToStringBuffer(Map dictionary, StringBuffer buffer, int indentionLevel) throws PropertyListParserException {
            buffer.append('{');
            if (!dictionary.isEmpty()) {
                Iterator keyEnumerator;
                int originalLength = buffer.length();
                StringBuffer oneLineBuffer = new StringBuffer(78);
                Set keySet = dictionary.keySet();
                ArrayList arrayList = new ArrayList(keySet);
                try {
                    Collections.sort(arrayList);
                    keyEnumerator = arrayList.iterator();
                }
                catch (Exception e) {
                    keyEnumerator = keySet.iterator();
                }
                while (keyEnumerator.hasNext()) {
                    Object value;
                    Object key = keyEnumerator.next();
                    if (key == null) {
                        throw new PropertyListParserException("Property list generation failed while attempting to write hashtable. Non-String key found in Hashtable. Property list dictionaries must have String's as keys.  The attempkey was '" + key + "'.");
                    }
                    if (!(key instanceof String)) {
                        key = key.toString();
                    }
                    if ((value = dictionary.get(key)) == null) continue;
                    buffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel + 1);
                    int keyStart = buffer.length();
                    _Utilities._appendStringToStringBuffer((String)key, buffer, indentionLevel + 1);
                    int keyEnd = buffer.length();
                    buffer.append(" = ");
                    int valueStart = buffer.length();
                    _Utilities._appendObjectToStringBuffer(value, buffer, indentionLevel + 1);
                    int valueEnd = buffer.length();
                    buffer.append("; ");
                    if (oneLineBuffer != null && oneLineBuffer.length() + (keyEnd - keyStart) + (valueEnd - valueStart) < 79) {
                        oneLineBuffer.append(buffer.substring(keyStart, keyEnd));
                        oneLineBuffer.append(" = ");
                        oneLineBuffer.append(buffer.substring(valueStart, valueEnd));
                        oneLineBuffer.append("; ");
                        continue;
                    }
                    oneLineBuffer = null;
                }
                if (oneLineBuffer != null && oneLineBuffer.length() < 78) {
                    buffer.setLength(originalLength);
                    buffer.append(oneLineBuffer);
                } else {
                    buffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel);
                }
            }
            buffer.append('}');
        }

        private static void _appendIndentationToStringBuffer(StringBuffer buffer, int indentionLevel) {
            int i = 0;
            while (i < indentionLevel) {
                buffer.append("    ");
                ++i;
            }
        }

        private static final char _hexDigitForNibble(byte nibble) {
            char digit = '\u0000';
            if (nibble >= 0 && nibble <= 9) {
                digit = (char)(48 + (char)nibble);
            } else if (nibble >= 10 && nibble <= 15) {
                digit = (char)(97 + (char)(nibble - 10));
            }
            return digit;
        }

        private int _readObjectIntoObjectReference(char[] characters, int index, Object[] objects, String keypath, ParserDataStructureFactory factory) {
            if ((index = this._skipWhitespaceAndComments(characters, index)) == -1 || index >= characters.length) {
                objects[0] = null;
            } else if (characters[index] == '\"') {
                StringBuffer buffer = new StringBuffer(64);
                index = this._readQuotedStringIntoStringBuffer(characters, index, buffer);
                objects[0] = buffer.toString();
            } else if (characters[index] == '<') {
                EMMutableData data = new EMMutableData(this._lengthOfData(characters, index));
                index = this._readDataContentsIntoData(characters, index, data);
                objects[0] = data;
            } else if (characters[index] == '(') {
                Collection<Object> array = factory.createCollection(keypath);
                index = this._readArrayContentsIntoArray(characters, index, array, keypath, factory);
                objects[0] = array;
            } else if (characters[index] == '{') {
                Map<Object, Object> dictionary = factory.createMap(keypath);
                index = this._readDictionaryContentsIntoDictionary(characters, index, dictionary, keypath, factory);
                objects[0] = dictionary;
            } else {
                StringBuffer buffer = new StringBuffer(64);
                index = this._readUnquotedStringIntoStringBuffer(characters, index, buffer);
                objects[0] = buffer.toString();
            }
            return index < characters.length ? index : -1;
        }

        private int _readUnquotedStringIntoStringBuffer(char[] characters, int index, StringBuffer buffer) {
            int originalIndex = index;
            buffer.setLength(0);
            while (index < characters.length && (characters[index] >= 'a' && characters[index] <= 'z' || characters[index] >= 'A' && characters[index] <= 'Z' || characters[index] >= '0' && characters[index] <= '9' || characters[index] == '_' || characters[index] == '$' || characters[index] == ':' || characters[index] == '.' || characters[index] == '/')) {
                ++index;
            }
            if (originalIndex >= index) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read unquoted string. No allowable characters were found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            buffer.append(characters, originalIndex, index - originalIndex);
            return index < characters.length ? index : -1;
        }

        private int _readQuotedStringIntoStringBuffer(char[] characters, int index, StringBuffer buffer) {
            this._saveIndexes(index, this._lineNumber, this._startOfLineCharIndex);
            int seqStart = ++index;
            while (index < characters.length && characters[index] != '\"') {
                if (characters[index] == '\\') {
                    if (seqStart < index) {
                        buffer.append(characters, seqStart, index - seqStart);
                    }
                    if (++index >= characters.length) {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
                    }
                    if (characters[index] == 'n') {
                        buffer.append('\n');
                    } else if (characters[index] == 'r') {
                        buffer.append('\r');
                        ++index;
                    } else if (characters[index] == 't') {
                        buffer.append('\t');
                        ++index;
                    } else if (characters[index] == 'f') {
                        buffer.append('\f');
                        ++index;
                    } else if (characters[index] == 'b') {
                        buffer.append('\b');
                        ++index;
                    } else if (characters[index] == 'a') {
                        buffer.append('\u0007');
                        ++index;
                    } else if (characters[index] == 'v') {
                        buffer.append('\u000b');
                        ++index;
                    } else if (characters[index] == 'u' || characters[index] == 'U') {
                        if (index + 4 >= characters.length) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before escape sequence was completed. Opening quote was at " + this._savedIndexesAsString() + ".");
                        }
                        if (!(_Utilities._isHexDigit(characters[++index]) && _Utilities._isHexDigit(characters[index + 1]) && _Utilities._isHexDigit(characters[index + 2]) && _Utilities._isHexDigit(characters[index + 3]))) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Improperly formed \\U type escape sequence. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                        }
                        byte nibble4 = _Utilities._nibbleForHexDigit(characters[index]);
                        byte nibble3 = _Utilities._nibbleForHexDigit(characters[index + 1]);
                        byte nibble2 = _Utilities._nibbleForHexDigit(characters[index + 2]);
                        byte nibble1 = _Utilities._nibbleForHexDigit(characters[index + 3]);
                        buffer.append((char)((nibble4 << 12) + (nibble3 << 8) + (nibble2 << 4) + nibble1));
                        index += 4;
                    } else if (characters[index] >= '0' && characters[index] <= '7') {
                        int temp = 0;
                        int numberOfDigits = 1;
                        int[] digits = new int[3];
                        digits[0] = characters[index] - 48;
                        ++index;
                        while (numberOfDigits < 3 && index < characters.length && characters[index] >= '0' && characters[index] <= '7') {
                            digits[numberOfDigits++] = characters[index] - 48;
                            ++index;
                        }
                        if (numberOfDigits == 3 && digits[0] > 3) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Octal escape sequence too large (bigger than octal 377). At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                        }
                        int i = 0;
                        while (i < numberOfDigits) {
                            temp *= 8;
                            temp += digits[i];
                            ++i;
                        }
                        buffer.append(_Utilities._nsToUnicode(temp));
                    } else {
                        buffer.append(characters[index]);
                        if (characters[index] == '\n') {
                            ++this._lineNumber;
                            this._startOfLineCharIndex = index + 1;
                        }
                        ++index;
                    }
                    seqStart = ++index;
                    continue;
                }
                if (characters[index] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = index + 1;
                }
                ++index;
            }
            if (seqStart < index) {
                buffer.append(characters, seqStart, index - seqStart);
            }
            if (index >= characters.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
            }
            return ++index < characters.length ? index : -1;
        }

        private int _lengthOfData(char[] characters, int index) {
            int numberOfNibbles = 0;
            boolean isHex = false;
            ++index;
            while (index < characters.length && ((isHex = _Utilities._isHexDigit(characters[index])) || _Utilities._isWhitespace(characters[index]))) {
                if (isHex) {
                    ++numberOfNibbles;
                }
                ++index;
            }
            if (index >= characters.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. Input exhausted before data was terminated with '>'. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            if (characters[index] != '>') {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. Illegal character encountered in data: '" + characters[index] + "'. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            if (numberOfNibbles % 2 != 0) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. An odd number of half-bytes were specified. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            return numberOfNibbles / 2;
        }

        private int _readDataContentsIntoData(char[] characters, int index, EMMutableData data) {
            ++index;
            while (characters[index] != '>' && characters[index = this._skipWhitespaceAndComments(characters, index)] != '>') {
                byte nibble2 = _Utilities._nibbleForHexDigit(characters[index]);
                ++index;
                index = this._skipWhitespaceAndComments(characters, index);
                byte nibble1 = _Utilities._nibbleForHexDigit(characters[index]);
                ++index;
                data.appendByte((byte)((nibble2 << 4) + nibble1));
            }
            return ++index < characters.length ? index : -1;
        }

        private int _readArrayContentsIntoArray(char[] characters, int index, Collection array, String keypath, ParserDataStructureFactory factory) {
            Object[] objects = new Object[1];
            ++index;
            array.clear();
            index = this._skipWhitespaceAndComments(characters, index);
            while (index != -1 && characters[index] != ')') {
                if (array.size() > 0) {
                    if (characters[index] != ',') {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read array. No comma found between array elements. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                    }
                    ++index;
                    if ((index = this._skipWhitespaceAndComments(characters, index)) == -1) {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                    }
                }
                if (characters[index] == ')') continue;
                objects[0] = null;
                index = this._readObjectIntoObjectReference(characters, index, objects, keypath, factory);
                if (objects[0] == null) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Failed to read content object. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                index = this._skipWhitespaceAndComments(characters, index);
                array.add(objects[0]);
            }
            if (index == -1) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            return ++index < characters.length ? index : -1;
        }

        private int _readDictionaryContentsIntoDictionary(char[] characters, int index, Map dictionary, String keypath, ParserDataStructureFactory factory) {
            Object[] keys = new Object[1];
            Object[] values = new Object[1];
            ++index;
            if (dictionary.size() != 0) {
                Iterator keyEnumerator = dictionary.keySet().iterator();
                while (keyEnumerator.hasNext()) {
                    dictionary.remove(keyEnumerator.next());
                }
            }
            index = this._skipWhitespaceAndComments(characters, index);
            while (index != -1 && characters[index] != '}') {
                index = this._readObjectIntoObjectReference(characters, index, keys, keypath, factory);
                if (keys[0] == null || !(keys[0] instanceof String)) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Failed to read key or key is not a String. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                if ((index = this._skipWhitespaceAndComments(characters, index)) == -1 || characters[index] != '=') {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key " + keys[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                ++index;
                if ((index = this._skipWhitespaceAndComments(characters, index)) == -1) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key " + keys[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                index = this._readObjectIntoObjectReference(characters, index, values, String.valueOf(keypath) + "." + keys[0], factory);
                if (values[0] == null) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Failed to read value. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                if ((index = this._skipWhitespaceAndComments(characters, index)) == -1 || characters[index] != ';') {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key and value with no terminating semicolon. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                ++index;
                index = this._skipWhitespaceAndComments(characters, index);
                dictionary.put(keys[0], values[0]);
            }
            if (index >= characters.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Exhausted input before end of dictionary was found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            return ++index < characters.length ? index : -1;
        }

        private int _skipWhitespaceAndComments(char[] characters, int index) {
            int nextChar = this._checkForWhitespaceOrComment(characters, index);
            while (nextChar != 1) {
                switch (nextChar) {
                    case 2: {
                        index = this._processWhitespace(characters, index);
                        break;
                    }
                    case 3: {
                        index = this._processSingleLineComment(characters, index);
                        break;
                    }
                    case 4: {
                        index = this._processMultiLineComment(characters, index);
                    }
                }
                nextChar = this._checkForWhitespaceOrComment(characters, index);
            }
            return index < characters.length ? index : -1;
        }

        private int _processWhitespace(char[] characters, int index) {
            while (index < characters.length && _Utilities._isWhitespace(characters[index])) {
                if (characters[index] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = index + 1;
                }
                ++index;
            }
            return index < characters.length ? index : -1;
        }

        private int _processSingleLineComment(char[] characters, int index) {
            index += 2;
            while (index < characters.length && characters[index] != '\n') {
                ++index;
            }
            return index < characters.length ? index : -1;
        }

        private int _processMultiLineComment(char[] characters, int index) {
            this._saveIndexes(index, this._lineNumber, this._startOfLineCharIndex);
            index += 2;
            while (index + 1 < characters.length && (characters[index] != '*' || characters[index + 1] != '/')) {
                if (characters[index] == '/' && characters[index + 1] == '*') {
                    throw new IllegalArgumentException("Property list parsing does not support embedded multi line comments.The first /* was at " + this._savedIndexesAsString() + ". A second /* was found at line " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                if (characters[index] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = index + 1;
                }
                ++index;
            }
            if (index + 1 >= characters.length || characters[index] != '*' || characters[index + 1] != '/') {
                throw new IllegalArgumentException("Property list parsing failed while attempting to find closing */ to comment that began at " + this._savedIndexesAsString() + ".");
            }
            return (index += 2) < characters.length ? index : -1;
        }

        private int _checkForWhitespaceOrComment(char[] characters, int index) {
            if (index == -1 || index >= characters.length) {
                return 1;
            }
            if (_Utilities._isWhitespace(characters[index])) {
                return 2;
            }
            if (index + 1 < characters.length) {
                if (characters[index] == '/' && characters[index + 1] == '/') {
                    return 3;
                }
                if (characters[index] == '/' && characters[index + 1] == '*') {
                    return 4;
                }
            }
            return 1;
        }

        private static final byte _nibbleForHexDigit(char digit) {
            byte nibble = 0;
            if (digit >= '0' && digit <= '9') {
                nibble = (byte)(digit - 48);
            } else if (digit >= 'a' && digit <= 'f') {
                nibble = (byte)(digit - 97 + 10);
            } else if (digit >= 'A' && digit <= 'F') {
                nibble = (byte)(digit - 65 + 10);
            } else {
                throw new IllegalArgumentException("Non-hex digit passed to _nibbleForHexDigit()");
            }
            return nibble;
        }

        private static final boolean _isHexDigit(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        private static final boolean _isWhitespace(char c) {
            return c < '!' && (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f');
        }

        private static char _nsToUnicode(int c) {
            return c >= 128 ? (char)NSToPrecompUnicodeTable[c - 128] : (char)c;
        }

        private _Utilities() {
        }
    }
}

