/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.logging;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.objectstyle.wolips.baseforplugins.Activator;
import org.objectstyle.wolips.baseforplugins.logging.ILogger;

public class PluginLogger
implements ILogger {
    private String pluginID = null;
    private boolean debug;

    public PluginLogger(String pluginID, boolean debug) {
        this.pluginID = pluginID;
        this.debug = debug;
    }

    public void log(IStatus status) {
        Activator.getDefault().log(status);
    }

    public void log(Object message) {
        this.log(new Status(4, this.pluginID, 4, "" + message, null));
    }

    public void log(Throwable e) {
        this.log(new Status(4, this.pluginID, 4, "Internal Error", e));
    }

    public void log(Object message, Throwable e) {
        this.log(new Status(4, this.pluginID, 4, "" + message, e));
    }

    public void debug(Throwable aThrowable) {
        if (this.debug) {
            this.log(new Status(2, this.pluginID, 2, aThrowable.getMessage(), aThrowable));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.debug) {
            this.log(new Status(2, this.pluginID, 2, "" + message, t));
        }
    }

    public void debug(Object message) {
        if (this.debug) {
            this.log(new Status(2, this.pluginID, 2, "" + message, null));
        }
    }
}

