/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtilities {
    public static boolean deleteRecursively(File file) {
        File[] childFiles;
        if (file.isDirectory() && (childFiles = file.listFiles()) != null) {
            File[] fileArray = childFiles;
            int n = childFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                FileUtilities.deleteRecursively(childFile);
                ++n2;
            }
        }
        return file.delete();
    }

    public static void copyFileToFile(File srcFile, File dstFile, boolean deleteOriginals, boolean forceDelete) throws FileNotFoundException, IOException {
        if (srcFile.exists() && srcFile.isFile()) {
            boolean copied = false;
            if (deleteOriginals && (!forceDelete || srcFile.canWrite())) {
                copied = srcFile.renameTo(dstFile);
            }
            if (!copied) {
                Throwable thrownException;
                block38: {
                    FileInputStream in;
                    block37: {
                        thrownException = null;
                        File parent = dstFile.getParentFile();
                        if (!parent.exists() && !parent.mkdirs()) {
                            throw new IOException("Failed to create the directory " + parent + ".");
                        }
                        in = new FileInputStream(srcFile);
                        try {
                            try {
                                FileChannel srcChannel;
                                block36: {
                                    srcChannel = in.getChannel();
                                    try {
                                        try {
                                            FileOutputStream out;
                                            block35: {
                                                out = new FileOutputStream(dstFile);
                                                try {
                                                    try {
                                                        FileChannel dstChannel = out.getChannel();
                                                        try {
                                                            try {
                                                                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                                                            }
                                                            catch (Throwable t) {
                                                                thrownException = t;
                                                                dstChannel.close();
                                                                break block35;
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            dstChannel.close();
                                                            throw throwable;
                                                        }
                                                        dstChannel.close();
                                                    }
                                                    catch (Throwable t) {
                                                        if (thrownException == null) {
                                                            thrownException = t;
                                                        }
                                                        out.close();
                                                        break block36;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    out.close();
                                                    throw throwable;
                                                }
                                            }
                                            out.close();
                                        }
                                        catch (Throwable t) {
                                            if (thrownException == null) {
                                                thrownException = t;
                                            }
                                            srcChannel.close();
                                            break block37;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        srcChannel.close();
                                        throw throwable;
                                    }
                                }
                                srcChannel.close();
                            }
                            catch (Throwable t) {
                                if (thrownException == null) {
                                    thrownException = t;
                                }
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    if (thrownException == null) {
                                        thrownException = e;
                                    }
                                    break block38;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block39: {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    if (thrownException != null) break block39;
                                    thrownException = e;
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (thrownException != null) break block38;
                        thrownException = e;
                    }
                }
                if (deleteOriginals && (srcFile.canWrite() || forceDelete) && !srcFile.delete()) {
                    throw new IOException("Failed to delete " + srcFile + ".");
                }
                if (thrownException != null) {
                    if (thrownException instanceof IOException) {
                        throw (IOException)thrownException;
                    }
                    if (thrownException instanceof Error) {
                        throw (Error)thrownException;
                    }
                    throw (RuntimeException)thrownException;
                }
            }
        }
    }
}

