/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtilities {
    public static boolean isDigitsOnly(String aString) {
        int i = aString.length();
        while (i-- > 0) {
            char c = aString.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericOnly(String aString) {
        boolean foundDecimal = false;
        int i = aString.length();
        while (i-- > 0) {
            char c = aString.charAt(i);
            if (c == '-') {
                if (i == 0) continue;
                return false;
            }
            if (c == '.') {
                if (!foundDecimal) {
                    foundDecimal = true;
                    continue;
                }
                return false;
            }
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String toCommandlineParameterFormat(String _parameter, String _value, boolean _escapeSpacesAndQuotes) {
        String value;
        boolean quote;
        StringBuffer commandlineFormat = new StringBuffer();
        commandlineFormat.append(_parameter);
        if (!_parameter.endsWith("=")) {
            commandlineFormat.append(" ");
        }
        boolean bl = quote = (value = _value).indexOf(32) != -1;
        if (quote && _escapeSpacesAndQuotes) {
            value = value.replaceAll(" ", "\\\\ ");
            value = value.replaceAll("\"", "\\\\\"");
        }
        if (quote) {
            commandlineFormat.append('\"');
        }
        commandlineFormat.append(value);
        if (quote) {
            commandlineFormat.append('\"');
        }
        return commandlineFormat.toString();
    }

    public static String replace(String origin, String oldPart, String newPart) {
        if (origin == null || origin.length() == 0) {
            return origin;
        }
        StringBuffer buffer = new StringBuffer(origin);
        int end = origin.length();
        int oldLength = oldPart.length();
        while (end >= 0) {
            int index = origin.lastIndexOf(oldPart, end);
            if (index == -1) break;
            end = index - oldLength;
            buffer.replace(index, index + oldLength, newPart);
        }
        return buffer.toString();
    }

    public static synchronized ArrayList arrayListFromCSV(String csvString) {
        if (csvString == null || csvString.length() == 0) {
            return new ArrayList();
        }
        StringTokenizer valueTokenizer = new StringTokenizer(csvString, ",");
        ArrayList<Object> resultList = new ArrayList<Object>(valueTokenizer.countTokens());
        while (valueTokenizer.hasMoreElements()) {
            resultList.add(valueTokenizer.nextElement());
        }
        return resultList;
    }
}

