/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.actions.DeleteOperation;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.actions.SimpleCompositeOperation;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;
import org.objectstyle.wolips.eomodeler.editors.EOModelErrorDialog;

public class DeleteAction
extends EMAction {
    public void run() {
        block10: {
            Object[] selectedObjects = this.getSelectedObjects();
            if (selectedObjects != null) {
                try {
                    Shell activeShell = this.getWindow().getShell();
                    Set<EOModelReferenceFailure> referenceFailures = EOModelUtils.getReferenceFailures(selectedObjects);
                    boolean delete = false;
                    if (referenceFailures.isEmpty()) {
                        delete = MessageDialog.openConfirm((Shell)activeShell, (String)Messages.getString("delete.objectsTitle"), (String)Messages.getString("delete.objectsMessage"));
                    } else {
                        Set<EOModelObject> recommendedDeletions;
                        Set<EOModelReferenceFailure> deleteAnywayReferenceFailures;
                        int results = new EOModelErrorDialog(activeShell, referenceFailures, true).open();
                        if (results == 100 && (delete = MessageDialog.openConfirm((Shell)activeShell, (String)Messages.getString("deleteAnyway.objectsTitle"), (String)Messages.getString("deleteAnyway.objectsMessage"))) && !(deleteAnywayReferenceFailures = EOModelUtils.getReferenceFailures(selectedObjects = (recommendedDeletions = EOModelUtils.getRecommendedDeletions(selectedObjects)).toArray())).isEmpty()) {
                            delete = false;
                            new EOModelErrorDialog(activeShell, referenceFailures, false).open();
                        }
                    }
                    if (!delete) break block10;
                    try {
                        SimpleCompositeOperation compositeOperation = new SimpleCompositeOperation(EOModelUtils.getOperationLabel("Delete", Arrays.asList(selectedObjects)));
                        Object[] objectArray = selectedObjects;
                        int n = selectedObjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            if (obj instanceof EOModelObject) {
                                EOModelObject eoModelObject = (EOModelObject)obj;
                                DeleteOperation operation = new DeleteOperation(eoModelObject);
                                compositeOperation.add((IUndoableOperation)operation);
                            }
                            ++n2;
                        }
                        compositeOperation.addContext(EOModelUtils.getUndoContext(selectedObjects));
                        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                        operationHistory.execute((IUndoableOperation)compositeOperation, null, null);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException("Failed to delete.", e);
                    }
                }
                catch (Throwable t) {
                    ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)t);
                }
            }
        }
    }
}

