/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;

public class FlattenOperation
extends AbstractOperation {
    private AbstractEOAttributePath _attributePath;
    private IEOAttribute _newAttribute;

    public FlattenOperation(AbstractEOAttributePath attributePath) {
        super("Flatten " + attributePath.toKeyPath());
        this._attributePath = attributePath;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            EOEntity rootEntity = this._attributePath.getRootEntity();
            this._newAttribute = rootEntity.addBlankIEOAttribute(this._attributePath);
            return Status.OK_STATUS;
        }
        catch (DuplicateNameException e) {
            throw new ExecutionException("Failed to flatten.", (Throwable)e);
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
            this._newAttribute._removeFromModelParent(failures);
            return Status.OK_STATUS;
        }
        catch (EOModelException e) {
            throw new ExecutionException("Failed to remove flattened object.", (Throwable)e);
        }
    }
}

