/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.IEOClassLoaderFactory;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLGenerator;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLGeneratorFactory;
import org.objectstyle.wolips.eomodeler.core.utils.SQLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSQLDialog
extends Dialog {
    private Button _dropDatabaseButton;
    private Button _dropTablesButton;
    private Button _dropPrimaryKeySupportButton;
    private Button _dropIndexesButton;
    private Button _createSelectedEntitiesButton;
    private Button _createTablesButton;
    private Button _createPrimaryKeySupportButton;
    private Button _createPrimaryKeyConstraintsButton;
    private Button _createForeignKeyConstraintsButton;
    private Button _createDatabaseButton;
    private Button _createIndexesButton;
    private Button _runInEntityModelerButton;
    private Text _sqlText;
    private EOModel _model;
    private List<String> _entityNames;
    private Set<EODatabaseConfig> _databaseConfigs;
    private ComboViewer _databaseConfigComboViewer;
    private ClassLoader _eoModelClassLoader;
    private FlagChangedHandler _flagChangeHander;
    private boolean _cancel;
    private Cursor _waitCursor;
    private Button _executeSqlButton;
    private boolean _createOnlySelectedEntities;

    public GenerateSQLDialog(Shell parentShell, EOModel model, List<String> entityNames) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._model = model;
        this._entityNames = entityNames;
        this._flagChangeHander = new FlagChangedHandler();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("SQL Generation");
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.numColumns = 2;
        control.setLayout((Layout)layout);
        this._databaseConfigs = this._model.getDatabaseConfigs();
        if (this._databaseConfigs.size() > 1) {
            this._databaseConfigComboViewer = new ComboViewer(control, 8);
            GridData extraInfoData = new GridData(768);
            extraInfoData.horizontalSpan = 2;
            this._databaseConfigComboViewer.setContentProvider((IContentProvider)new DatabaseConfigContentProvider());
            this._databaseConfigComboViewer.setLabelProvider((IBaseLabelProvider)new DatabaseConfigLabelProvider());
            this._databaseConfigComboViewer.setInput(this._databaseConfigs);
            this._databaseConfigComboViewer.getCombo().setLayoutData((Object)extraInfoData);
            EODatabaseConfig activeDatabaseConfig = this._model.getActiveDatabaseConfig();
            if (activeDatabaseConfig != null) {
                this._databaseConfigComboViewer.setSelection((ISelection)new StructuredSelection((Object)activeDatabaseConfig));
            } else {
                this._databaseConfigComboViewer.setSelection((ISelection)new StructuredSelection((Object)this._databaseConfigs.iterator().next()));
            }
            this._databaseConfigComboViewer.addSelectionChangedListener((ISelectionChangedListener)this._flagChangeHander);
        }
        this._dropDatabaseButton = new Button(control, 32);
        this._dropDatabaseButton.setText("Drop Database");
        this._dropDatabaseButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._createDatabaseButton = new Button(control, 32);
        this._createDatabaseButton.setText("Create Database");
        this._createDatabaseButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._dropTablesButton = new Button(control, 32);
        this._dropTablesButton.setText("Drop Tables");
        this._dropTablesButton.setSelection(true);
        this._dropTablesButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._createTablesButton = new Button(control, 32);
        this._createTablesButton.setText("Create Tables");
        this._createTablesButton.setSelection(true);
        this._createTablesButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._dropPrimaryKeySupportButton = new Button(control, 32);
        this._dropPrimaryKeySupportButton.setText("Drop Primary Keys");
        this._dropPrimaryKeySupportButton.setSelection(true);
        this._dropPrimaryKeySupportButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._createPrimaryKeySupportButton = new Button(control, 32);
        this._createPrimaryKeySupportButton.setText("Create Primary Key Support");
        this._createPrimaryKeySupportButton.setSelection(true);
        this._createPrimaryKeySupportButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._dropIndexesButton = new Button(control, 32);
        this._dropIndexesButton.setText("Drop Indexes");
        this._dropIndexesButton.setSelection(true);
        this._dropIndexesButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._createIndexesButton = new Button(control, 32);
        this._createIndexesButton.setText("Create Indexes");
        this._createIndexesButton.setSelection(true);
        this._createIndexesButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        int entityCount = this._entityNames != null ? this._entityNames.size() : 0;
        this._createSelectedEntitiesButton = new Button(control, 32);
        this._createSelectedEntitiesButton.setText("Create Only Selected Entities");
        this._createSelectedEntitiesButton.setSelection(entityCount > 0);
        this._createSelectedEntitiesButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._createSelectedEntitiesButton.setEnabled(entityCount > 0);
        this._createOnlySelectedEntities = entityCount > 0;
        this._createPrimaryKeyConstraintsButton = new Button(control, 32);
        this._createPrimaryKeyConstraintsButton.setText("Primary Key Constraints");
        this._createPrimaryKeyConstraintsButton.setSelection(true);
        this._createPrimaryKeyConstraintsButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._runInEntityModelerButton = new Button(control, 32);
        this._runInEntityModelerButton.setText("Single Transaction Compatible");
        this._runInEntityModelerButton.setSelection(true);
        this._runInEntityModelerButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._createForeignKeyConstraintsButton = new Button(control, 32);
        this._createForeignKeyConstraintsButton.setText("Foreign Key Constraints");
        this._createForeignKeyConstraintsButton.setSelection(true);
        this._createForeignKeyConstraintsButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        new Label(control, 0);
        this._sqlText = new Text(control, 2570);
        GridData sqlTextData = new GridData(1808);
        sqlTextData.heightHint = 300;
        sqlTextData.widthHint = 500;
        sqlTextData.verticalIndent = 10;
        sqlTextData.horizontalSpan = 2;
        this._sqlText.setLayoutData((Object)sqlTextData);
        this._sqlText.setText("Generating SQL. Please Wait ...");
        this._waitCursor = new Cursor((Device)this.getShell().getDisplay(), 1);
        this.generateSqlInThread();
        return control;
    }

    public boolean close() {
        boolean close = super.close();
        if (this._waitCursor != null) {
            this._waitCursor.dispose();
            this._waitCursor = null;
        }
        return close;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Button closeButton = new Button(composite, 8);
        closeButton.setText("Close");
        closeButton.addSelectionListener((SelectionListener)new CloseHandler());
        this._executeSqlButton = new Button(composite, 8);
        this._executeSqlButton.setText("Execute SQL");
        this._executeSqlButton.addSelectionListener((SelectionListener)new ExecuteSqlHandler());
        this.getShell().setDefaultButton(closeButton);
        return composite;
    }

    protected String yesNo(Button button) {
        return button.getSelection() ? "YES" : "NO";
    }

    protected Text getSqlText() {
        return this._sqlText;
    }

    protected EODatabaseConfig getSelectedDatabaseConfig() {
        EODatabaseConfig selectedDatabaseConfig = null;
        if (this._databaseConfigComboViewer != null) {
            IStructuredSelection selection = (IStructuredSelection)this._databaseConfigComboViewer.getSelection();
            selectedDatabaseConfig = (EODatabaseConfig)selection.getFirstElement();
        } else {
            selectedDatabaseConfig = this._model.getActiveDatabaseConfig();
        }
        return selectedDatabaseConfig;
    }

    protected ClassLoader getEOModelClassLoader() throws Exception {
        if (this._eoModelClassLoader == null) {
            this._eoModelClassLoader = IEOClassLoaderFactory.Utility.createClassLoader(this._model);
        }
        return this._eoModelClassLoader;
    }

    public void generateSqlInThread() {
        this._createOnlySelectedEntities = this._createSelectedEntitiesButton.getSelection();
        final HashMap<String, String> flags = new HashMap<String, String>();
        flags.put("dropTables", this.yesNo(this._dropTablesButton));
        flags.put("dropPrimaryKeySupport", this.yesNo(this._dropPrimaryKeySupportButton));
        flags.put("createTables", this.yesNo(this._createTablesButton));
        flags.put("createPrimaryKeySupport", this.yesNo(this._createPrimaryKeySupportButton));
        flags.put("primaryKeyConstraints", this.yesNo(this._createPrimaryKeyConstraintsButton));
        flags.put("foreignKeyConstraints", this.yesNo(this._createForeignKeyConstraintsButton));
        flags.put("createDatabase", this.yesNo(this._createDatabaseButton));
        flags.put("dropDatabase", this.yesNo(this._dropDatabaseButton));
        flags.put("createIndexes", this.yesNo(this._createIndexesButton));
        flags.put("dropIndexes", this.yesNo(this._dropIndexesButton));
        final EODatabaseConfig selectedDatabaseConfig = this.getSelectedDatabaseConfig();
        final boolean runInEntityModeler = this._runInEntityModelerButton.getSelection();
        Thread generateSqlThread = new Thread(new Runnable(){

            public void run() {
                GenerateSQLDialog.this.generateSql(flags, selectedDatabaseConfig, runInEntityModeler);
            }
        }, "Generate SQL");
        generateSqlThread.start();
    }

    protected Button getExecuteSqlButton() {
        return this._executeSqlButton;
    }

    protected synchronized void generateSql(Map flags, EODatabaseConfig selectedDatabaseConfig, boolean runInEntityModeler) {
        block5: {
            try {
                try {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            GenerateSQLDialog.this.getShell().setCursor(GenerateSQLDialog.this.getWaitCursor());
                            GenerateSQLDialog.this.getExecuteSqlButton().setEnabled(false);
                        }
                    });
                    IEOSQLGenerator sqlGenerator = IEOSQLGeneratorFactory.Utility.sqlGeneratorFactory().sqlGenerator(this._model, this.getEntityNames(), selectedDatabaseConfig, this.getEOModelClassLoader(), runInEntityModeler);
                    final String sqlScript = sqlGenerator.generateSchemaCreationScript(flags);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            GenerateSQLDialog.this.getSqlText().setText(sqlScript);
                            GenerateSQLDialog.this.getExecuteSqlButton().setEnabled(true);
                        }
                    });
                }
                catch (Throwable t) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            GenerateSQLDialog.this.getSqlText().setText("Generation Failed.");
                        }
                    });
                    ErrorUtils.openErrorDialog((Shell)this.getShell(), (Throwable)t);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            GenerateSQLDialog.this.getShell().setCursor(null);
                        }
                    });
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
        }
    }

    protected String getSqlString() {
        return this._sqlText.getText();
    }

    public void executeSqlInThread() {
        this._createOnlySelectedEntities = this._createSelectedEntitiesButton.getSelection();
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Execute SQL", (String)"Are you sure you want to execute this SQL?");
        if (confirmed) {
            final String sqlString = this.getSqlString();
            final EODatabaseConfig selectedDatabaseConfig = this.getSelectedDatabaseConfig();
            final boolean runInEntityModeler = this._runInEntityModelerButton.getSelection();
            Thread executeSqlThread = new Thread(new Runnable(){

                public void run() {
                    GenerateSQLDialog.this.executeSql(sqlString, selectedDatabaseConfig, runInEntityModeler);
                }
            }, "Execute SQL");
            executeSqlThread.start();
        }
    }

    protected void setCancel(boolean cancel) {
        this._cancel = cancel;
    }

    protected Cursor getWaitCursor() {
        return this._waitCursor;
    }

    protected List<String> getEntityNames() {
        return this._createOnlySelectedEntities ? this._entityNames : null;
    }

    protected synchronized void executeSql(String allSql, EODatabaseConfig selectedDatabaseConfig, boolean runInEntityModeler) {
        block9: {
            try {
                try {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            GenerateSQLDialog.this.getShell().setCursor(GenerateSQLDialog.this.getWaitCursor());
                        }
                    });
                    IEOSQLGenerator sqlGenerator = IEOSQLGeneratorFactory.Utility.sqlGeneratorFactory().sqlGenerator(this._model, this.getEntityNames(), selectedDatabaseConfig, this.getEOModelClassLoader(), runInEntityModeler);
                    String url = selectedDatabaseConfig.getURL();
                    int commandSeparatorChar = url != null && url.toLowerCase().contains("oracle") ? 47 : 59;
                    List<String> statements = SQLUtils.splitSQLStatements(allSql, (char)commandSeparatorChar);
                    this.setCancel(false);
                    int statementsNum = 0;
                    while (!this._cancel && statementsNum < statements.size()) {
                        String statement = statements.get(statementsNum);
                        if ((statement = statement.trim().replaceAll("[\n\r]", " ")).length() > 0) {
                            try {
                                sqlGenerator.executeSQL(statement);
                            }
                            catch (Throwable t) {
                                Display.getDefault().syncExec(new Runnable(){

                                    public void run() {
                                        MessageDialog dialog = new MessageDialog(GenerateSQLDialog.this.getShell(), "Error", null, String.valueOf(StringUtils.getErrorMessage(t)) + "\n\nThere was an error, do you want to cancel the rest of the script?", 3, new String[]{"Cancel", "Continue"}, 0);
                                        int results = dialog.open();
                                        boolean cancel = results == 0;
                                        GenerateSQLDialog.this.setCancel(cancel);
                                    }
                                });
                            }
                        }
                        ++statementsNum;
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)GenerateSQLDialog.this.getShell(), (String)"Done", (String)"SQL Execution Complete");
                        }
                    });
                }
                catch (Throwable t) {
                    ErrorUtils.openErrorDialog((Shell)this.getShell(), (Throwable)t);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            GenerateSQLDialog.this.getShell().setCursor(null);
                        }
                    });
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
        }
    }

    public class CloseHandler
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            GenerateSQLDialog.this.close();
        }
    }

    public static class DatabaseConfigContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class DatabaseConfigLabelProvider
    implements ILabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            EODatabaseConfig config = (EODatabaseConfig)element;
            StringBuffer text = new StringBuffer();
            text.append(config.getName());
            text.append(" (");
            text.append(config.getUsername());
            text.append(" @ ");
            text.append(config.getURL());
            text.append(")");
            return text.toString();
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ExecuteSqlHandler
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            GenerateSQLDialog.this.executeSqlInThread();
        }
    }

    public class FlagChangedHandler
    implements SelectionListener,
    ISelectionChangedListener {
        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            GenerateSQLDialog.this.generateSqlInThread();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            GenerateSQLDialog.this.generateSqlInThread();
        }
    }
}

