/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SimpleCompositeOperation
extends AbstractOperation
implements ICompositeOperation {
    private List<IUndoableOperation> _operations = new LinkedList<IUndoableOperation>();

    public SimpleCompositeOperation(String label) {
        super(label);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        ExecutionException pendingException = null;
        boolean completed = false;
        LinkedList<IUndoableOperation> completedOperations = new LinkedList<IUndoableOperation>();
        for (IUndoableOperation operation : this._operations) {
            completed = false;
            try {
                IStatus status2 = operation.execute(monitor, info);
                if (status2.getSeverity() == 0) {
                    completed = true;
                    completedOperations.add(operation);
                }
            }
            catch (ExecutionException e) {
                pendingException = e;
            }
            if (!completed) break;
        }
        if (!completed) {
            for (IUndoableOperation operation : completedOperations) {
                operation.undo(monitor, info);
            }
            if (pendingException != null) {
                throw pendingException;
            }
            status = new Status(4, "org.objectstyle.wolips.eomodeler", 0, "Failed", null);
        } else {
            status = Status.OK_STATUS;
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (IUndoableOperation operation : this._operations) {
            status = operation.redo(monitor, info);
            if (status.getSeverity() == 4) break;
        }
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (IUndoableOperation operation : this._operations) {
            status = operation.undo(monitor, info);
            if (status.getSeverity() == 4) break;
        }
        return status;
    }

    public void add(IUndoableOperation operation) {
        this._operations.add(operation);
    }

    public void remove(IUndoableOperation operation) {
        this._operations.remove(operation);
    }

    public void addContext(IUndoContext context) {
        super.addContext(context);
        for (IUndoableOperation operation : this._operations) {
            operation.addContext(context);
        }
    }

    public void removeContext(IUndoContext context) {
        super.addContext(context);
        for (IUndoableOperation operation : this._operations) {
            operation.removeContext(context);
        }
    }

    public boolean canExecute() {
        boolean canExecute = super.canExecute();
        for (IUndoableOperation operation : this._operations) {
            canExecute &= operation.canExecute();
        }
        return canExecute;
    }

    public boolean canUndo() {
        boolean canUndo = super.canUndo();
        for (IUndoableOperation operation : this._operations) {
            canUndo &= operation.canUndo();
        }
        return canUndo;
    }

    public boolean canRedo() {
        boolean canRedo = super.canRedo();
        for (IUndoableOperation operation : this._operations) {
            canRedo &= operation.canRedo();
        }
        return canRedo;
    }

    public void dispose() {
        for (IUndoableOperation operation : this._operations) {
            operation.dispose();
        }
        super.dispose();
    }
}

