/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.HashSet;
import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.Messages;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOArgument;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOArgumentDirection;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOArgument
extends AbstractEOArgument<EOStoredProcedure> {
    public static final String DIRECTION = "direction";
    private EOStoredProcedure myStoredProcedure;
    private EOArgumentDirection myDirection = EOArgumentDirection.VOID;

    public EOArgument() {
    }

    public EOArgument(String _name) {
        super(_name);
    }

    public EOArgument(String _name, String _definition) {
        super(_name, _definition);
    }

    public EOStoredProcedure getStoredProcedure() {
        return this.myStoredProcedure;
    }

    public void _setStoredProcedure(EOStoredProcedure _storedProcedure) {
        this.myStoredProcedure = _storedProcedure;
    }

    @Override
    protected AbstractEOArgument _createArgument(String _name) {
        return new EOArgument(_name);
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myStoredProcedure != null) {
            this.myStoredProcedure._argumentChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    @Override
    public void setName(String _name, boolean _fireEvents) throws DuplicateNameException {
        if (_name == null) {
            throw new NullPointerException(Messages.getString("EOArgument.noBlankArgumentNames"));
        }
        if (this.myStoredProcedure != null) {
            this.myStoredProcedure._checkForDuplicateArgumentName(this, _name, null);
        }
        super.setName(_name, _fireEvents);
    }

    public void setDirection(EOArgumentDirection _direction) {
        EOArgumentDirection oldDirection = this.myDirection;
        this.myDirection = _direction;
        this.firePropertyChange(DIRECTION, oldDirection, this.myDirection);
    }

    public EOArgumentDirection getDirection() {
        return this.myDirection;
    }

    @Override
    public void loadFromMap(EOModelMap _argumentMap, Set<EOModelVerificationFailure> _failures) {
        super.loadFromMap(_argumentMap, _failures);
        Integer argumentDirectionNum = _argumentMap.getInteger("parameterDirection");
        if (argumentDirectionNum == null) {
            argumentDirectionNum = new Integer(0);
        }
        this.myDirection = EOArgumentDirection.getArgumentDirectionByID(argumentDirectionNum);
    }

    @Override
    public EOModelMap toMap() {
        EOModelMap argumentMap = super.toMap();
        if (this.myDirection == null || this.myDirection == EOArgumentDirection.VOID) {
            argumentMap.remove("parameterDirection");
        } else {
            argumentMap.setInteger("parameterDirection", new Integer(this.myDirection.getID()));
        }
        return argumentMap;
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        return new HashSet<EOModelReferenceFailure>();
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            _failures.add(new EOModelVerificationFailure(this.myStoredProcedure.getModel(), this, "The argument " + this.getName() + " has an empty name.", false));
        } else if (name.indexOf(32) != -1) {
            _failures.add(new EOModelVerificationFailure(this.myStoredProcedure.getModel(), this, "The argument " + this.getName() + "'s name has a space in it.", false));
        }
        if (this.myDirection == null) {
            _failures.add(new EOModelVerificationFailure(this.myStoredProcedure.getModel(), this, "The argument " + this.getName() + " has no direction specified.", false));
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return String.valueOf(this.myStoredProcedure == null ? "?" : this.myStoredProcedure.getFullyQualifiedName()) + "/arg: " + this.getName();
    }

    public EOArgument _cloneModelObject() {
        EOArgument argument = (EOArgument)this._cloneArgument();
        argument.myDirection = this.myDirection;
        return argument;
    }

    @Override
    public Class<EOStoredProcedure> _getModelParentType() {
        return EOStoredProcedure.class;
    }

    @Override
    public EOStoredProcedure _getModelParent() {
        return this.getStoredProcedure();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getStoredProcedure().removeArgument(this);
    }

    @Override
    public void _addToModelParent(EOStoredProcedure modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            this.setName(modelParent.findUnusedArgumentName(this.getName()));
        }
        modelParent.addArgument(this);
    }

    @Override
    public String toString() {
        return "[EOArgument: name = " + this.getName() + "]";
    }
}

