/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.math.BigDecimal;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.core.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EODataType
implements Comparable<EODataType> {
    public static final EODataType STRING;
    public static final EODataType STRING_CHAR;
    public static final EODataType STRING_UTF;
    public static final EODataType STRING_RTRIM;
    public static final EODataType BYTE;
    public static final EODataType SHORT;
    public static final EODataType INTEGER;
    public static final EODataType LONG;
    public static final EODataType FLOAT;
    public static final EODataType DOUBLE;
    public static final EODataType BOOLEAN;
    public static final EODataType BIGDECIMAL;
    public static final EODataType DECIMAL_NUMBER;
    public static final EODataType DATE;
    public static final EODataType TIME;
    public static final EODataType TIMESTAMP;
    public static final EODataType DATE_MSSQL;
    public static final EODataType DATA;
    public static final EODataType CUSTOM;
    public static final EODataType[] DATA_TYPES;
    private String myValueClass;
    private String myJavaValueClass;
    private String[] myValueTypes;
    private String myName;

    static {
        String[] stringArray = new String[3];
        stringArray[1] = "";
        stringArray[2] = "S";
        STRING = new EODataType("NSString", String.class.getName(), stringArray, Messages.getString("EODataType.string"));
        STRING_CHAR = new EODataType("NSString", String.class.getName(), "C", Messages.getString("EODataType.stringChar"));
        STRING_UTF = new EODataType("NSString", String.class.getName(), "E", Messages.getString("EODataType.stringUTF"));
        STRING_RTRIM = new EODataType("NSString", String.class.getName(), "c", Messages.getString("EODataType.stringRTRIM"));
        BYTE = new EODataType("NSNumber", Byte.class.getName(), "b", Messages.getString("EODataType.byte"));
        SHORT = new EODataType("NSNumber", Short.class.getName(), "s", Messages.getString("EODataType.short"));
        String[] stringArray2 = new String[3];
        stringArray2[0] = "i";
        stringArray2[2] = "";
        INTEGER = new EODataType("NSNumber", Integer.class.getName(), stringArray2, Messages.getString("EODataType.integer"));
        LONG = new EODataType("NSNumber", Long.class.getName(), "l", Messages.getString("EODataType.long"));
        FLOAT = new EODataType("NSNumber", Float.class.getName(), "f", Messages.getString("EODataType.float"));
        DOUBLE = new EODataType("NSNumber", Double.class.getName(), "d", Messages.getString("EODataType.double"));
        BOOLEAN = new EODataType("NSNumber", "boolean", "c", Messages.getString("EODataType.boolean"));
        BIGDECIMAL = new EODataType("NSDecimalNumber", BigDecimal.class.getName(), "B", Messages.getString("EODataType.bigDecimal"));
        DECIMAL_NUMBER = new EODataType("NSDecimalNumber", Integer.class.getName(), null, Messages.getString("EODataType.decimalNumber"));
        String[] stringArray3 = new String[3];
        stringArray3[1] = "";
        stringArray3[2] = "D";
        DATE = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", stringArray3, Messages.getString("EODataType.date"));
        TIME = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", "t", Messages.getString("EODataType.time"));
        TIMESTAMP = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", "T", Messages.getString("EODataType.timestamp"));
        DATE_MSSQL = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", "M", Messages.getString("EODataType.dateMSSQL"));
        DATA = new EODataType("NSData", "com.webobjects.foundation.NSData", null, Messages.getString("EODataType.data"));
        CUSTOM = new EODataType(null, "Custom", null, Messages.getString("EODataType.custom"));
        DATA_TYPES = new EODataType[]{STRING, STRING_CHAR, STRING_UTF, STRING_RTRIM, BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BIGDECIMAL, DECIMAL_NUMBER, BOOLEAN, DATE, TIME, TIMESTAMP, DATE_MSSQL, DATA, CUSTOM};
    }

    public EODataType(String _valueClass, String _javaValueClass, String _valueType, String _name) {
        this(_valueClass, _javaValueClass, new String[]{_valueType}, _name);
    }

    public EODataType(String _valueClass, String _javaValueClass, String[] _valueTypes, String _name) {
        this.myValueClass = _valueClass;
        this.myJavaValueClass = _javaValueClass;
        this.myValueTypes = _valueTypes;
        this.myName = _name;
    }

    public String getShortJavaValueClass() {
        int lastDotIndex;
        String javaValueClass = this.myJavaValueClass;
        if (javaValueClass != null && (lastDotIndex = javaValueClass.lastIndexOf(46)) != -1) {
            javaValueClass = javaValueClass.substring(lastDotIndex + 1);
        }
        return javaValueClass;
    }

    public String getJavaValueClass() {
        return this.myJavaValueClass;
    }

    public String getValueClass() {
        return this.myValueClass;
    }

    public String getFirstValueType() {
        return this.myValueTypes[0];
    }

    public String[] getValueTypes() {
        return this.myValueTypes;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "[EODataType: name = " + this.myName + "]";
    }

    @Override
    public int compareTo(EODataType o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public static EODataType getDataTypeByValueClassAndType(String _valueClass, String _valueType) {
        EODataType matchingDataType = null;
        int dataTypeNum = 0;
        while (matchingDataType == null && dataTypeNum < DATA_TYPES.length) {
            EODataType dataType = DATA_TYPES[dataTypeNum];
            if (ComparisonUtils.equals(dataType.myValueClass, _valueClass)) {
                int valueTypeNum = 0;
                while (matchingDataType == null && valueTypeNum < dataType.myValueTypes.length) {
                    if (ComparisonUtils.equals(dataType.myValueTypes[valueTypeNum], _valueType)) {
                        matchingDataType = dataType;
                    }
                    ++valueTypeNum;
                }
            }
            ++dataTypeNum;
        }
        if (matchingDataType == null) {
            matchingDataType = CUSTOM;
        }
        return matchingDataType;
    }

    public static EODataType getDataTypeByValueClass(String _valueClass) {
        EODataType matchingDataType = null;
        int dataTypeNum = 0;
        while (matchingDataType == null && dataTypeNum < DATA_TYPES.length) {
            EODataType dataType = DATA_TYPES[dataTypeNum];
            if (ComparisonUtils.equals(dataType.myValueClass, _valueClass)) {
                matchingDataType = dataType;
            }
            ++dataTypeNum;
        }
        if (matchingDataType == null) {
            matchingDataType = CUSTOM;
        }
        return matchingDataType;
    }
}

