/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOEntityForest {
    private Map<EOEntity, EOEntityTreeNode> _nodes = new HashMap<EOEntity, EOEntityTreeNode>();

    public Set<EOEntityTreeNode> getRootNodes() {
        HashSet<EOEntityTreeNode> rootNodes = new HashSet<EOEntityTreeNode>();
        for (EOEntityTreeNode node : this._nodes.values()) {
            if (!node.isRoot()) continue;
            rootNodes.add(node);
        }
        return rootNodes;
    }

    public void add(Collection<EOEntity> entities) {
        for (EOEntity entity : entities) {
            this.add(entity);
        }
    }

    public EOEntityTreeNode add(EOEntity entity) {
        EOEntityTreeNode node = this._nodes.get(entity);
        if (node == null) {
            node = new EOEntityTreeNode(entity);
            this._nodes.put(entity, node);
            EOEntity parentEntity = entity.getParent();
            EOEntityTreeNode parentNode = this._nodes.get(parentEntity);
            if (parentNode != null) {
                parentNode.addChild(node);
            }
            Set<EOEntity> childrenEntities = entity.getChildrenEntities();
            for (EOEntity childEntity : childrenEntities) {
                EOEntityTreeNode childNode = this._nodes.get(childEntity);
                if (childNode == null) continue;
                node.addChild(childNode);
            }
        }
        return node;
    }

    public List<EOEntity> breadthFirst() {
        LinkedList<EOEntity> entities = new LinkedList<EOEntity>();
        Set<EOEntityTreeNode> rootNodes = this.getRootNodes();
        for (EOEntityTreeNode rootNode : rootNodes) {
            entities.add(rootNode.getEntity());
        }
        for (EOEntityTreeNode rootNode : rootNodes) {
            rootNode._breadthFirst(entities);
        }
        return entities;
    }
}

