/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.HashSet;
import java.util.Set;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.MissingAttributeFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOJoin
extends EOModelObject<EORelationship>
implements ISortableEOModelObject {
    public static final String DESTINATION_ATTRIBUTE = "destinationAttribute";
    public static final String SOURCE_ATTRIBUTE = "sourceAttribute";
    public static final String DESTINATION_ATTRIBUTE_NAME = "destinationAttributeName";
    public static final String SOURCE_ATTRIBUTE_NAME = "sourceAttributeName";
    private EORelationship myRelationship;
    private EOAttribute mySourceAttribute;
    private EOAttribute myDestinationAttribute;
    private EOModelMap myJoinMap = new EOModelMap();

    public EOJoin addInverseJoinInto(EORelationship _relationship, boolean _fireEvents) {
        EOJoin inverseJoin = new EOJoin();
        inverseJoin.setSourceAttribute(this.myDestinationAttribute);
        inverseJoin.setDestinationAttribute(this.mySourceAttribute);
        _relationship.addJoin(inverseJoin, _fireEvents);
        return inverseJoin;
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        return new HashSet<EOModelReferenceFailure>();
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myRelationship != null) {
            this.myRelationship._joinChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    @Override
    public void setName(String name) throws DuplicateNameException {
        throw new RuntimeException("uh .... what?");
    }

    @Override
    public String getName() {
        return String.valueOf(this.mySourceAttribute != null ? this.mySourceAttribute.getName() : "") + (this.myDestinationAttribute != null ? this.myDestinationAttribute.getName() : "");
    }

    public void _setRelationship(EORelationship _relationship) {
        this.myRelationship = _relationship;
    }

    public EORelationship getRelationship() {
        return this.myRelationship;
    }

    public boolean isInverseJoin(EOJoin _join) {
        return _join != null && ComparisonUtils.equals(this.mySourceAttribute, _join.myDestinationAttribute) && ComparisonUtils.equals(this.myDestinationAttribute, _join.mySourceAttribute);
    }

    public void pasted() throws DuplicateNameException {
        if (this.mySourceAttribute != null) {
            EOAttribute sourceAttribute = this.myRelationship.getEntity().getAttributeNamed(this.mySourceAttribute.getName());
            if (this.mySourceAttribute == null) {
                this.mySourceAttribute = this.mySourceAttribute._cloneModelObject();
                this.myRelationship.getEntity().addAttribute(sourceAttribute);
            } else {
                this.mySourceAttribute = sourceAttribute;
            }
        }
        if (this.myDestinationAttribute != null) {
            EOEntity destination = this.myRelationship.getDestination();
            if (destination != null) {
                EOAttribute destinationAttribute = destination.getAttributeNamed(this.myDestinationAttribute.getName());
                if (destinationAttribute == null && this.myDestinationAttribute.getEntity() == this.myRelationship.getEntity()) {
                    this.myDestinationAttribute = this.myDestinationAttribute._cloneModelObject();
                    this.myRelationship.getEntity().addAttribute(destinationAttribute);
                } else {
                    this.myDestinationAttribute = destinationAttribute;
                }
            } else {
                this.myDestinationAttribute = null;
            }
        }
    }

    public boolean isRelatedTo(EOAttribute _attribute) {
        boolean isRelatedTo = false;
        EOAttribute sourceAttribute = this.getSourceAttribute();
        if (sourceAttribute != null && sourceAttribute.equals(_attribute)) {
            isRelatedTo = true;
        } else {
            EOAttribute destinationAttribute = this.getDestinationAttribute();
            if (destinationAttribute != null && destinationAttribute.equals(_attribute)) {
                isRelatedTo = true;
            }
        }
        return isRelatedTo;
    }

    public String getSourceAttributeName() {
        String sourceAttributeName = null;
        EOAttribute sourceAttribute = this.getSourceAttribute();
        if (sourceAttribute != null) {
            sourceAttributeName = sourceAttribute.getName();
        }
        return sourceAttributeName;
    }

    public void setSourceAttributeName(String _sourceAttributeName) {
        EOAttribute sourceAttribute = this.myRelationship.getEntity().getAttributeNamed(_sourceAttributeName);
        this.setSourceAttribute(sourceAttribute);
    }

    public EOAttribute getSourceAttribute() {
        return this.mySourceAttribute;
    }

    public void setSourceAttribute(EOAttribute _sourceAttribute) {
        this.setSourceAttribute(_sourceAttribute, true);
    }

    public void setSourceAttribute(EOAttribute _sourceAttribute, boolean _fireEvents) {
        EOAttribute oldSourceAttribute = this.mySourceAttribute;
        this.mySourceAttribute = _sourceAttribute;
        if (_fireEvents) {
            this.firePropertyChange(SOURCE_ATTRIBUTE, oldSourceAttribute, this.mySourceAttribute);
        }
    }

    public String getDestinationAttributeName() {
        String destinationAttributeName = null;
        EOAttribute destinationAttribute = this.getDestinationAttribute();
        if (destinationAttribute != null) {
            destinationAttributeName = destinationAttribute.getName();
        }
        return destinationAttributeName;
    }

    public void setDestinationAttributeName(String _destinationAttributeName) {
        EOAttribute destinationAttribute = this.myRelationship.getDestination().getAttributeNamed(_destinationAttributeName);
        this.setDestinationAttribute(destinationAttribute);
    }

    public EOAttribute getDestinationAttribute() {
        return this.myDestinationAttribute;
    }

    public void setDestinationAttribute(EOAttribute _destinationAttribute) {
        this.setDestinationAttribute(_destinationAttribute, true);
    }

    public void setDestinationAttribute(EOAttribute _destinationAttribute, boolean _fireEvents) {
        EOAttribute oldDestinationAttribute = this.myDestinationAttribute;
        this.myDestinationAttribute = _destinationAttribute;
        if (_fireEvents) {
            this.firePropertyChange(DESTINATION_ATTRIBUTE, oldDestinationAttribute, this.myDestinationAttribute);
        }
    }

    public void loadFromMap(EOModelMap _joinMap, Set _failures) {
        this.myJoinMap = _joinMap;
    }

    public EOModelMap toMap() {
        EOModelMap joinMap = this.myJoinMap.cloneModelMap();
        if (this.myDestinationAttribute != null) {
            joinMap.setString(DESTINATION_ATTRIBUTE, this.myDestinationAttribute.getName(), true);
        } else {
            joinMap.remove(DESTINATION_ATTRIBUTE);
        }
        if (this.mySourceAttribute != null) {
            joinMap.setString(SOURCE_ATTRIBUTE, this.mySourceAttribute.getName(), true);
        } else {
            joinMap.remove(SOURCE_ATTRIBUTE);
        }
        return joinMap;
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        String sourceAttributeName = this.myJoinMap.getString(SOURCE_ATTRIBUTE, true);
        this.mySourceAttribute = this.myRelationship.getEntity().getAttributeNamed(sourceAttributeName);
        if (this.mySourceAttribute == null) {
            _failures.add(new MissingAttributeFailure(this.myRelationship.getEntity(), sourceAttributeName));
        }
        String destinationAttributeName = this.myJoinMap.getString(DESTINATION_ATTRIBUTE, true);
        EOEntity destination = this.myRelationship.getDestination();
        if (destination != null) {
            this.myDestinationAttribute = this.myRelationship.getDestination().getAttributeNamed(destinationAttributeName);
            if (this.myDestinationAttribute == null) {
                _failures.add(new MissingAttributeFailure(this.myRelationship.getDestination(), destinationAttributeName));
            }
        }
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        if (this.mySourceAttribute == null) {
            _failures.add(new EOModelVerificationFailure(this.getRelationship().getEntity().getModel(), this.getRelationship(), String.valueOf(this.getRelationship().getName()) + " has a join with a missing source attribute.", false));
        }
        if (this.myDestinationAttribute == null) {
            _failures.add(new EOModelVerificationFailure(this.getRelationship().getEntity().getModel(), this.getRelationship(), String.valueOf(this.getRelationship().getName()) + " has a join with a missing destination attribute.", false));
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return String.valueOf(this.myRelationship == null ? "?" : this.myRelationship.getFullyQualifiedName()) + "/join: " + this.getSourceAttributeName() + "=>" + this.getDestinationAttributeName();
    }

    public EOJoin _cloneModelObject() {
        EOJoin join = new EOJoin();
        join.mySourceAttribute = this.mySourceAttribute;
        join.myDestinationAttribute = this.myDestinationAttribute;
        return join;
    }

    @Override
    public Class<EORelationship> _getModelParentType() {
        return EORelationship.class;
    }

    @Override
    public EORelationship _getModelParent() {
        return this.getRelationship();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getRelationship().removeJoin(this);
    }

    @Override
    public void _addToModelParent(EORelationship modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) {
        modelParent.addJoin(this);
    }

    public String toString() {
        return "[EOJoin: sourceAttribute = " + (this.mySourceAttribute == null ? "null" : this.mySourceAttribute.getName()) + "; destinationAttribute = " + (this.myDestinationAttribute == null ? "null" : this.myDestinationAttribute.getName()) + "]";
    }
}

