/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.core.Activator;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateEntityNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateModelNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListSet;
import org.objectstyle.wolips.eomodeler.core.model.VerificationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOModelGroup
extends EOModelObject<Object> {
    public static final String MODELS = "models";
    private Set<EOModel> _models = new HashSet<EOModel>();
    private String _editingModelName;
    private boolean _dirty;

    public boolean hasProjectWonder() {
        return this.containsModelNamed("erprototypes");
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        return new HashSet<EOModelReferenceFailure>();
    }

    public void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    public boolean isDirty() {
        boolean dirty = false;
        for (EOModel model : this.getModels()) {
            try {
                if (!model.isDirty() || !model.canSave()) continue;
                dirty = true;
                break;
            }
            catch (MalformedURLException e) {
                Activator.getDefault().log("Unable to determine if the model " + model.getName() + " was dirty, so we skipped it.", e);
            }
        }
        return dirty;
    }

    protected void _modelChanged(EOModel model, String propertyName, Object oldValue, Object newValue) {
        if ("dirty".equals(propertyName)) {
            boolean oldDirty = this._dirty;
            boolean dirty = this.isDirty();
            this.firePropertyChange(propertyName, oldDirty, dirty);
            this._dirty = dirty;
        }
    }

    @Override
    protected void _propertyChanged(String name, Object value, Object value2) {
    }

    public Set<EOModel> getModels() {
        return this._models;
    }

    public Set<EOModel> getSortedModels() {
        return new PropertyListSet<EOModel>((Collection<EOModel>)this._models);
    }

    public Set<String> getNonPrototypeEntityNames() {
        TreeSet<String> entityNames = new TreeSet<String>();
        for (EOModel model : this._models) {
            for (EOEntity entity : model.getEntities()) {
                if (entity.isPrototype()) continue;
                entityNames.add(entity.getName());
            }
        }
        return entityNames;
    }

    public Set<String> getEntityNames() {
        TreeSet<String> entityNames = new TreeSet<String>();
        for (EOModel model : this._models) {
            for (EOEntity entity : model.getEntities()) {
                entityNames.add(entity.getName());
            }
        }
        return entityNames;
    }

    public Set<EOEntity> getNonPrototypeEntities() {
        HashSet<EOEntity> entities = new HashSet<EOEntity>();
        for (EOModel model : this._models) {
            entities.addAll(model.getNonPrototypeEntities());
        }
        return entities;
    }

    public Set<EOEntity> getEntities() {
        HashSet<EOEntity> allEntities = new HashSet<EOEntity>();
        for (EOModel model : this._models) {
            allEntities.addAll(model.getEntities());
        }
        return allEntities;
    }

    public Set<EOEntity> getSortedEntities() {
        return new PropertyListSet<EOEntity>((Collection<EOEntity>)this.getEntities());
    }

    public String findUnusedEntityName(String _newName) {
        return this._findUnusedName(_newName, "getEntityNamed");
    }

    public EOEntity getEntityNamed(String _entityName) {
        EOEntity matchingEntity = null;
        Iterator<EOModel> modelsIter = this._models.iterator();
        while (matchingEntity == null && modelsIter.hasNext()) {
            EOModel model = modelsIter.next();
            matchingEntity = model.getEntityNamed(_entityName);
        }
        return matchingEntity;
    }

    public boolean containsModelNamed(String _entityName) {
        return this.getModelNamed(_entityName) != null;
    }

    public void _checkForDuplicateModelName(EOModel _model, String _newName) throws DuplicateModelNameException {
        EOModel model = this.getModelNamed(_newName);
        if (model != null && model != _model) {
            throw new DuplicateModelNameException(_newName, this);
        }
    }

    public void addModel(EOModel _model) throws DuplicateEntityNameException, DuplicateModelNameException {
        this.addModel(_model, null);
    }

    public void addModel(EOModel _model, Set<EOModelVerificationFailure> _failures) throws DuplicateEntityNameException, DuplicateModelNameException {
        HashSet<EOModel> oldModels = new HashSet<EOModel>(this._models);
        _model._setModelGroup(this);
        this._checkForDuplicateModelName(_model, _model.getName());
        for (EOEntity entity : _model.getEntities()) {
            _model._checkForDuplicateEntityName(entity, entity.getName(), _failures);
        }
        this._models.add(_model);
        this.clearCachedPrototypes(_failures);
        this.firePropertyChange(MODELS, oldModels, this._models);
    }

    public void removeModel(EOModel _model, Set<EOModelVerificationFailure> _failures) {
        HashSet<EOModel> oldModels = new HashSet<EOModel>(this._models);
        this._models.remove(_model);
        this.clearCachedPrototypes(_failures);
        this.firePropertyChange(MODELS, oldModels, this._models);
        _model._setModelGroup(null);
    }

    public Set<EOEntity> getPrototypeEntities() {
        HashSet<EOEntity> prototypeEntities = new HashSet<EOEntity>();
        for (EOModel model : this._models) {
            for (EOEntity entity : model.getEntities()) {
                if (!entity.isPrototype()) continue;
                prototypeEntities.add(entity);
            }
        }
        return prototypeEntities;
    }

    protected void clearCachedPrototypes(Set<EOModelVerificationFailure> _failures) {
        for (EOModel model : this._models) {
            model.clearCachedPrototypes(_failures, false);
        }
    }

    public Map<EOAttribute, Set<EORelationship>> _createReferencingRelationshipsCache() {
        HashMap<EOAttribute, Set<EORelationship>> cache = new HashMap<EOAttribute, Set<EORelationship>>();
        for (EOModel model : this.getModels()) {
            model._createReferencingRelationshipsCache(cache);
        }
        return cache;
    }

    public Map<EOEntity, Set<EOEntity>> _createInheritanceCache() {
        HashMap<EOEntity, Set<EOEntity>> cache = new HashMap<EOEntity, Set<EOEntity>>();
        for (EOModel model : this.getModels()) {
            model._createInheritanceCache(cache);
        }
        return cache;
    }

    public EOModel getModelNamed(String _name) {
        EOModel matchingModel = null;
        Iterator<EOModel> modelsIter = this._models.iterator();
        while (matchingModel == null && modelsIter.hasNext()) {
            EOModel model = modelsIter.next();
            if (!model.getName().equals(_name)) continue;
            matchingModel = model;
        }
        return matchingModel;
    }

    public void setEditingModelURL(URL editingModelURL) {
        this.setEditingModelName(EOModelGroup.getModelNameForURL(editingModelURL));
    }

    public void setEditingModelName(String editingModelName) {
        this._editingModelName = editingModelName;
    }

    public String getEditingModelName() {
        return this._editingModelName;
    }

    public EOModel getEditingModel() {
        return this.getModelNamed(this._editingModelName);
    }

    public static String getModelNameForURL(URL url) {
        String modelName;
        if (url == null) {
            modelName = null;
        } else {
            String protocol = url.getProtocol();
            if ("jar".equals(protocol)) {
                try {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    JarEntry jarEntry = conn.getJarEntry();
                    if (jarEntry != null) {
                        modelName = EOModelGroup.getModelNameForJarEntry(jarEntry);
                    }
                    modelName = null;
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("The jar url '" + url.toString() + "' was unable to be used to find out the EO model's name.", ioe);
                }
            } else {
                File file = URLUtils.cheatAndTurnIntoFile(url);
                modelName = EOModelGroup.getModelNameForFile(file);
            }
        }
        return modelName;
    }

    public static String getModelNameForJarEntry(JarEntry jarEntry) {
        String modelName = null;
        if (jarEntry != null) {
            String jarEntryName = jarEntry.getName();
            if (jarEntryName.endsWith("index.eomodeld")) {
                int lastSlashIndex = jarEntryName.lastIndexOf(47);
                jarEntryName = lastSlashIndex == -1 ? null : jarEntryName.substring(0, lastSlashIndex + 1);
            }
            if (jarEntryName != null && jarEntryName.endsWith(".eomodeld/")) {
                int lastDotIndex = jarEntryName.lastIndexOf(46, jarEntryName.length() - 2);
                int lastSlashIndex = jarEntryName.lastIndexOf(47, jarEntryName.length() - 2);
                modelName = jarEntryName.substring(lastSlashIndex + 1, lastDotIndex);
                if (modelName.length() == 0) {
                    modelName = null;
                }
            }
        }
        return modelName;
    }

    public static String getModelNameForFile(File file) {
        String modelName = null;
        if (file != null) {
            String fileName = file.getName();
            if (file.getName().equals("index.eomodeld")) {
                fileName = file.getParentFile().getName();
            }
            if (fileName.endsWith(".eomodeld")) {
                modelName = fileName.substring(0, fileName.lastIndexOf(46));
            }
        }
        return modelName;
    }

    public EOModel loadModelFromURL(URL url) throws IOException, EOModelException {
        HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
        EOModel model = this.loadModelFromURL(url, failures, true, new NullProgressMonitor());
        if (failures.size() > 0) {
            throw new EOModelException("Failed to load model from URL '" + url + "': " + failures);
        }
        return model;
    }

    public EOModel loadModelFromURL(URL url, Set<EOModelVerificationFailure> failures) throws IOException, EOModelException {
        EOModel model = this.loadModelFromURL(url, failures, true, new NullProgressMonitor());
        return model;
    }

    public EOModel loadModelFromURL(URL url, Set<EOModelVerificationFailure> failures, IProgressMonitor progressMonitor) throws IOException, EOModelException {
        EOModel model = this.loadModelFromURL(url, failures, true, progressMonitor);
        return model;
    }

    public void loadModelsFromURL(URL url, Set<EOModelVerificationFailure> failures, IProgressMonitor progressMonitor) throws IOException, EOModelException {
        this.loadModelsFromURL(url, -1, failures, true, progressMonitor);
    }

    protected void loadModelsFromURL(URL url, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) throws IOException, EOModelException {
        this.loadModelsFromURL(url, -1, failures, skipOnDuplicates, progressMonitor);
    }

    public void loadModelsFromURL(URL url, int maxDepth, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) throws IOException, EOModelException {
        String path = url.getPath();
        if (path.endsWith(".eomodeld") || path.endsWith(".eomodeld/")) {
            this.loadModelFromURL(url, failures, skipOnDuplicates, progressMonitor);
        } else if (maxDepth != 0) {
            URL[] uRLArray = URLUtils.getChildrenFolders(url);
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL childURL = uRLArray[n2];
                if (URLUtils.isFolder(childURL)) {
                    boolean processFolder = true;
                    String childPath = childURL.getPath();
                    if (childPath.endsWith("/Java/") || childPath.endsWith(".wo/")) {
                        processFolder = false;
                    }
                    if (processFolder) {
                        this.loadModelsFromURL(childURL, maxDepth - 1, failures, skipOnDuplicates, progressMonitor);
                    }
                }
                ++n2;
            }
        }
    }

    public EOModel loadModelFromURL(URL modelURL, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) throws IOException, EOModelException {
        String modelName = EOModelGroup.getModelNameForURL(modelURL);
        progressMonitor.setTaskName("Loading " + modelName + " ...");
        EOModel model = this.getModelNamed(modelName);
        if (model != null && !skipOnDuplicates) {
            failures.add(new EOModelVerificationFailure(model, model, "The model named '" + modelName + "' exists in " + model.getIndexURL() + " and " + modelURL + ".", true));
        }
        if (!skipOnDuplicates || model == null) {
            boolean reloadModel = true;
            while (reloadModel) {
                model = new EOModel(modelName);
                model.setModelURL(modelURL);
                URL indexURL = model.getIndexURL();
                if (!URLUtils.exists(indexURL)) {
                    reloadModel = false;
                    failures.add(new EOModelVerificationFailure(model, model, "Skipping model because " + indexURL + " does not exist.", true));
                    continue;
                }
                model._setModelGroup(this);
                try {
                    model.loadFromURL(modelURL, failures);
                    this.addModel(model, failures);
                    reloadModel = false;
                }
                catch (DuplicateEntityNameException e) {
                    e.printStackTrace();
                    if (!skipOnDuplicates) {
                        throw e;
                    }
                    EOEntity existingEntity = e.getExistingEntity();
                    EOModel existingEntityModel = existingEntity.getModel();
                    failures.add(new EOModelVerificationFailure(model, model, String.valueOf(existingEntityModel.getName()) + " and " + model.getName() + " both declare an entity named " + existingEntity.getName() + ", so " + existingEntityModel.getName() + " is being removed. You can create an EOModelGroup file to resolve this.", true, e));
                    this.removeModel(existingEntityModel, failures);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failures.add(new EOModelVerificationFailure(model, model, String.valueOf(model.getName()) + " failed to load.", true, e));
                    reloadModel = false;
                }
            }
        }
        return model;
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        VerificationContext verificationContext = new VerificationContext(this);
        for (EOModel model : this._models) {
            model.verify(_failures, verificationContext);
        }
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        for (EOModel model : this._models) {
            model.resolve(_failures);
        }
        for (EOModel model : this._models) {
            model.resolveFlattened(_failures);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return "EOModelGroup";
    }

    public String toString() {
        return "[EOModelGroup: models = " + this._models + "]";
    }

    @Override
    public String getName() {
        return "EOModelGroup";
    }

    public EOModelGroup _cloneModelObject() {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void _addToModelParent(Object modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) {
    }

    @Override
    public Class<Object> _getModelParentType() {
        return null;
    }

    @Override
    public Object _getModelParent() {
        return null;
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
    }

    public static void main(String[] args) throws IOException, PropertyListParserException {
        long a = System.currentTimeMillis();
        int i = 0;
        while (i < 1000) {
            WOLPropertyListSerialization.propertyListFromFile(new File("/Users/mschrag/Documents/workspace/MDTask/Resources/MDTask.eomodeld/index.eomodeld"));
            ++i;
        }
        System.out.println("EOModelGroup.main: " + (System.currentTimeMillis() - a));
    }
}

