/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.sql;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCContext;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.objectstyle.wolips.eomodeler.core.sql.EOFSQLUtils56;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLGenerator;

public class EOFSQLGenerator56
implements IEOSQLGenerator {
    private NSMutableArray _entities;
    private EOModel _model;
    private EOModelGroup _modelGroup;
    private Object _modelProcessor;

    public EOFSQLGenerator56(String modelName, List modelURLs, List entityNames, Map selectedDatabaseConfig, boolean runInEntityModeler) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        NSDictionary defaultConnectionDictionary;
        this.fixClassPath();
        HashMap databaseConfig = selectedDatabaseConfig;
        if (databaseConfig == null) {
            databaseConfig = new HashMap();
        }
        this._modelGroup = new EOModelGroup();
        for (URL modelURL : modelURLs) {
            this._modelGroup.addModelWithPathURL(modelURL);
        }
        String prototypeEntityName = (String)databaseConfig.get("prototypeEntityName");
        if (prototypeEntityName != null) {
            this.replacePrototypes(this._modelGroup, prototypeEntityName);
        }
        this._entities = new NSMutableArray();
        this._model = this._modelGroup.modelNamed(modelName);
        Map overrideConnectionDictionary = (Map)databaseConfig.get("connectionDictionary");
        if (overrideConnectionDictionary != null) {
            NSDictionary connectionDictionary = (NSDictionary)EOFSQLUtils56.toWOCollections(overrideConnectionDictionary);
            this._model.setConnectionDictionary(connectionDictionary);
            String eomodelProcessorClassName = (String)connectionDictionary.valueForKey("eomodelProcessorClassName");
            if (eomodelProcessorClassName != null) {
                this.findModelProcessor(eomodelProcessorClassName, true);
            }
            defaultConnectionDictionary = connectionDictionary;
        } else {
            defaultConnectionDictionary = this._model.connectionDictionary();
        }
        Enumeration modelsEnum = this._modelGroup.models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)modelsEnum.nextElement();
            if (model.connectionDictionary() != null) continue;
            model.setConnectionDictionary(defaultConnectionDictionary);
        }
        if (this._modelProcessor == null) {
            this.findModelProcessor("org.objectstyle.wolips.eomodeler.EOModelProcessor", false);
        }
        if (entityNames == null || entityNames.size() == 0) {
            Enumeration entitiesEnum = this._model.entities().objectEnumerator();
            while (entitiesEnum.hasMoreElements()) {
                EOEntity entity = (EOEntity)entitiesEnum.nextElement();
                if (this.isPrototype(entity)) continue;
                this._entities.addObject((Object)entity);
            }
        } else {
            for (String entityName : entityNames) {
                EOEntity entity = this._model.entityNamed(entityName);
                if (entity == null) continue;
                this._entities.addObject((Object)entity);
            }
        }
        NSDictionary connectionDictionary = this._model.connectionDictionary();
        if (connectionDictionary != null) {
            NSMutableDictionary mutableConnectionDictionary = connectionDictionary.mutableClone();
            mutableConnectionDictionary.removeObjectForKey((Object)"jdbc2Info");
            this._model.setConnectionDictionary((NSDictionary)mutableConnectionDictionary);
        }
        if (runInEntityModeler) {
            NSMutableDictionary modelUserInfo = this._model.userInfo().mutableClone();
            NSDictionary entityModelerDict = (NSDictionary)modelUserInfo.valueForKey("_EntityModeler");
            NSMutableDictionary mutableEntityModelerDict = entityModelerDict == null ? new NSMutableDictionary() : entityModelerDict.mutableClone();
            mutableEntityModelerDict.takeValueForKey((Object)Boolean.TRUE, "inEntityModeler");
            modelUserInfo.takeValueForKey((Object)mutableEntityModelerDict, "_EntityModeler");
            this._model.setUserInfo((NSDictionary)modelUserInfo);
        }
        this.ensureSingleTableInheritanceParentEntitiesAreIncluded();
        this.ensureSingleTableInheritanceChildEntitiesAreIncluded();
        this.fixAllowsNullOnSingleTableInheritance();
        this.localizeEntities();
    }

    protected void replacePrototypes(EOModelGroup modelGroup, String prototypeEntityName) {
        EOEntity prototypesEntity;
        String replacementPrototypeName = "EOPrototypes";
        if (modelGroup.entityNamed(prototypeEntityName) == null) {
            return;
        }
        if (replacementPrototypeName.equals(prototypeEntityName)) {
            return;
        }
        NSMutableDictionary removedPrototypeEntities = new NSMutableDictionary();
        EOModel prototypesModel = null;
        Enumeration modelsEnum = modelGroup.models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)modelsEnum.nextElement();
            EOEntity eoAdaptorPrototypesEntity = this._modelGroup.entityNamed("EO" + model.adaptorName() + "Prototypes");
            if (eoAdaptorPrototypesEntity == null) continue;
            prototypesModel = eoAdaptorPrototypesEntity.model();
            prototypesModel.removeEntity(eoAdaptorPrototypesEntity);
            removedPrototypeEntities.takeValueForKey((Object)eoAdaptorPrototypesEntity, eoAdaptorPrototypesEntity.name());
        }
        EOEntity eoPrototypesEntity = this._modelGroup.entityNamed("EOPrototypes");
        if (eoPrototypesEntity != null) {
            prototypesModel = eoPrototypesEntity.model();
            prototypesModel.removeEntity(eoPrototypesEntity);
            removedPrototypeEntities.takeValueForKey((Object)eoPrototypesEntity, eoPrototypesEntity.name());
        }
        if ((prototypesEntity = this._modelGroup.entityNamed(prototypeEntityName)) == null) {
            prototypesEntity = (EOEntity)removedPrototypeEntities.valueForKey(prototypeEntityName);
        } else {
            prototypesModel = prototypesEntity.model();
            prototypesModel.removeEntity(prototypesEntity);
        }
        if (prototypesEntity != null && prototypesModel != null) {
            prototypesEntity.setName(replacementPrototypeName);
            prototypesModel.addEntity(prototypesEntity);
        }
        Enumeration resetModelsEnum = this._modelGroup.models().objectEnumerator();
        while (resetModelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)resetModelsEnum.nextElement();
            model._resetPrototypeCache();
        }
    }

    protected void localizeEntities() {
        Enumeration entitiesEnum = new NSArray((NSArray)this._entities).objectEnumerator();
        while (entitiesEnum.hasMoreElements()) {
            EOEntity entity = (EOEntity)entitiesEnum.nextElement();
            this.createLocalizedAttributes(entity);
        }
    }

    protected void fixAllowsNullOnSingleTableInheritance() {
        Enumeration entitiesEnum = new NSArray((NSArray)this._entities).objectEnumerator();
        while (entitiesEnum.hasMoreElements()) {
            EOEntity entity = (EOEntity)entitiesEnum.nextElement();
            if (!this.isSingleTableInheritance(entity)) continue;
            Enumeration attributeEnum = entity.attributes().objectEnumerator();
            while (attributeEnum.hasMoreElements()) {
                EOAttribute attribute = (EOAttribute)attributeEnum.nextElement();
                if (this.isInherited(attribute)) continue;
                attribute.setAllowsNull(true);
            }
        }
    }

    protected void ensureSingleTableInheritanceParentEntitiesAreIncluded() {
        Enumeration entitiesEnum = new NSArray((NSArray)this._entities).objectEnumerator();
        while (entitiesEnum.hasMoreElements()) {
            EOEntity entity = (EOEntity)entitiesEnum.nextElement();
            this.ensureSingleTableInheritanceParentEntitiesAreIncluded(entity);
        }
    }

    protected void ensureSingleTableInheritanceChildEntitiesAreIncluded() {
        Enumeration entitiesEnum = this._model.entities().objectEnumerator();
        while (entitiesEnum.hasMoreElements()) {
            EOEntity parentEntity;
            EOEntity entity = (EOEntity)entitiesEnum.nextElement();
            if (!this.isSingleTableInheritance(entity) || !this._entities.containsObject((Object)(parentEntity = entity.parentEntity())) || this._entities.containsObject((Object)entity)) continue;
            this._entities.addObject((Object)entity);
        }
    }

    protected void ensureSingleTableInheritanceParentEntitiesAreIncluded(EOEntity entity) {
        EOEntity parentEntity;
        if (this.isSingleTableInheritance(entity) && !this._entities.containsObject((Object)(parentEntity = entity.parentEntity()))) {
            this._entities.addObject((Object)parentEntity);
            this.ensureSingleTableInheritanceParentEntitiesAreIncluded(entity);
        }
    }

    protected boolean isPrototype(EOEntity _entity) {
        String entityName = _entity.name();
        boolean isPrototype = entityName.startsWith("EO") && entityName.endsWith("Prototypes");
        return isPrototype;
    }

    protected boolean isSingleTableInheritance(EOEntity entity) {
        EOEntity parentEntity = entity.parentEntity();
        return parentEntity != null && entity.externalName() != null && entity.externalName().equalsIgnoreCase(parentEntity.externalName());
    }

    protected void createLocalizedAttributes(EOEntity entity) {
        NSArray attributes = entity.attributes().immutableClone();
        NSArray classProperties = entity.classProperties().immutableClone();
        NSArray attributesUsedForLocking = entity.attributesUsedForLocking().immutableClone();
        if (attributes == null) {
            attributes = NSArray.EmptyArray;
        }
        if (classProperties == null) {
            classProperties = NSArray.EmptyArray;
        }
        if (attributesUsedForLocking == null) {
            attributesUsedForLocking = NSArray.EmptyArray;
        }
        NSMutableArray mutableClassProperties = classProperties.mutableClone();
        NSMutableArray mutableAttributesUsedForLocking = attributesUsedForLocking.mutableClone();
        Enumeration e = attributes.objectEnumerator();
        while (e.hasMoreElements()) {
            EOAttribute attribute = (EOAttribute)e.nextElement();
            NSDictionary userInfo = attribute.userInfo();
            String name = attribute.name();
            if (userInfo != null) {
                NSArray languages;
                Object l = userInfo.valueForKey("ERXLanguages");
                if (l != null && !(l instanceof NSArray)) {
                    Object object = l = entity.model().userInfo() != null ? entity.model().userInfo().valueForKey("ERXLanguages") : null;
                }
                if ((languages = (NSArray)l) != null && languages.count() > 0) {
                    String columnName = attribute.columnName();
                    int i = 0;
                    while (i < languages.count()) {
                        String language = (String)languages.objectAtIndex(i);
                        String newName = String.valueOf(name) + "_" + language;
                        String newColumnName = String.valueOf(columnName) + "_" + language;
                        EOAttribute newAttribute = new EOAttribute();
                        newAttribute.setName(newName);
                        entity.addAttribute(newAttribute);
                        newAttribute.setPrototype(attribute.prototype());
                        newAttribute.setColumnName(newColumnName);
                        newAttribute.setAllowsNull(attribute.allowsNull());
                        newAttribute.setClassName(attribute.className());
                        newAttribute.setExternalType(attribute.externalType());
                        newAttribute.setWidth(attribute.width());
                        newAttribute.setUserInfo(attribute.userInfo());
                        if (classProperties.containsObject((Object)attribute)) {
                            mutableClassProperties.addObject((Object)newAttribute);
                        }
                        if (attributesUsedForLocking.containsObject((Object)attribute)) {
                            mutableAttributesUsedForLocking.addObject((Object)newAttribute);
                        }
                        ++i;
                    }
                    entity.removeAttribute(attribute);
                    mutableClassProperties.removeObject((Object)attribute);
                    mutableAttributesUsedForLocking.removeObject((Object)attribute);
                }
            }
            entity.setClassProperties((NSArray)mutableClassProperties);
            entity.setAttributesUsedForLocking((NSArray)mutableAttributesUsedForLocking);
        }
    }

    protected boolean isInherited(EOAttribute attribute) {
        boolean inherited = false;
        EOEntity parentEntity = attribute.entity().parentEntity();
        while (!inherited && parentEntity != null) {
            inherited = parentEntity.attributeNamed(attribute.name()) != null;
            parentEntity = parentEntity.parentEntity();
        }
        return inherited;
    }

    protected void fixDuplicateSingleTableInheritanceDropStatements(EOSynchronizationFactory syncFactory, NSMutableDictionary flags, StringBuffer sqlBuffer) {
        if ("YES".equals(flags.valueForKey("dropTables"))) {
            NSMutableArray dropEntities = new NSMutableArray((NSArray)this._entities);
            int entityNum = dropEntities.count() - 1;
            while (entityNum >= 0) {
                EOEntity entity = (EOEntity)dropEntities.objectAtIndex(entityNum);
                if (this.isSingleTableInheritance(entity)) {
                    dropEntities.removeObjectAtIndex(entityNum);
                }
                --entityNum;
            }
            if (dropEntities.count() != this._entities.count()) {
                NSMutableDictionary dropFlags = new NSMutableDictionary();
                dropFlags.takeValueForKey((Object)"YES", "dropTables");
                dropFlags.takeValueForKey((Object)"NO", "dropPrimaryKeySupport");
                dropFlags.takeValueForKey((Object)"NO", "createTables");
                dropFlags.takeValueForKey((Object)"NO", "createPrimaryKeySupport");
                dropFlags.takeValueForKey((Object)"NO", "primaryKeyConstraints");
                dropFlags.takeValueForKey((Object)"NO", "foreignKeyConstraints");
                dropFlags.takeValueForKey((Object)"NO", "createDatabase");
                dropFlags.takeValueForKey((Object)"NO", "dropDatabase");
                flags.takeValueForKey((Object)"NO", "dropTables");
                String dropSql = syncFactory.schemaCreationScriptForEntities((NSArray)dropEntities, (NSDictionary)dropFlags);
                sqlBuffer.append(dropSql);
                sqlBuffer.append("\n");
            }
        }
    }

    private String getClassPath() {
        URL[] urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs();
        String classPath = "";
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            classPath = String.valueOf(classPath) + url.getFile() + File.pathSeparator;
            ++i;
        }
        return classPath;
    }

    private void fixClassPath() {
        String classPath = this.getClassPath();
        System.setProperty("java.class.path", classPath);
        System.setProperty("com.webobjects.classpath", classPath);
    }

    /*
     * Unable to fully structure code
     */
    public String generateSchemaCreationScript(Map flagsMap) {
        this.fixClassPath();
        flags = new NSMutableDictionary();
        if (flagsMap != null) {
            for (Map.Entry<K, V> flag : flagsMap.entrySet()) {
                flags.takeValueForKey(flag.getValue(), (String)flag.getKey());
            }
        }
        this.callModelProcessorMethodIfExists("processModel", new Object[]{this._model, this._entities, flags});
        dbc = EODatabaseContext.Factory.newDatabaseContextForDatabase((EODatabase)EODatabase.Factory.newDatabaseForModel((EOModel)this._model));
        ac = dbc.adaptorContext();
        sf = ((JDBCAdaptor)ac.adaptor()).plugIn().synchronizationFactory();
        beforeOpenChannels = new NSMutableArray();
        beforeChannelsEnum = ac.channels().objectEnumerator();
        while (beforeChannelsEnum.hasMoreElements()) {
            channel = (EOAdaptorChannel)beforeChannelsEnum.nextElement();
            if (!channel.isOpen()) continue;
            beforeOpenChannels.addObject((Object)channel);
        }
        sqlBuffer = new StringBuffer();
        this.fixDuplicateSingleTableInheritanceDropStatements(sf, flags, sqlBuffer);
        try {
            sql = sf.schemaCreationScriptForEntities((NSArray)this._entities, (NSDictionary)flags);
            sql = sql.replaceAll("CREATE TABLE ([^\\s(]+)\\(", "CREATE TABLE $1 (");
            sqlBuffer.append(sql);
            this.callModelProcessorMethodIfExists("processSQL", new Object[]{sqlBuffer, this._model, this._entities, flags});
        }
        finally {
            afterChannelsEnum = ac.channels().objectEnumerator();
            ** while (afterChannelsEnum.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            channel = (EOAdaptorChannel)afterChannelsEnum.nextElement();
            if (!channel.isOpen() || beforeOpenChannels.containsObject((Object)channel)) continue;
            channel.closeChannel();
            continue;
        }
lbl36:
        // 1 sources

        sqlBufferStr = sqlBuffer.toString();
        if (sqlBufferStr != null) {
            sqlBufferStr = Pattern.compile("([\\w\\)])(NOT NULL)", 2).matcher(sqlBufferStr).replaceAll("$1 $2");
        }
        return sqlBufferStr;
    }

    public Object callModelProcessorMethodIfExists(String methodName, Object[] _objs) {
        try {
            Object results = null;
            if (this._modelProcessor != null) {
                Method[] methods = this._modelProcessor.getClass().getMethods();
                Method matchingMethod = null;
                int methodNum = 0;
                while (matchingMethod == null && methodNum < methods.length) {
                    Method method = methods[methodNum];
                    if (method.getName().equals(methodName)) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        boolean parametersMatch = false;
                        if ((_objs == null || _objs.length == 0) && parameterTypes.length == 0) {
                            parametersMatch = true;
                        } else if (_objs != null && _objs.length == parameterTypes.length) {
                            parametersMatch = true;
                            int parameterTypeNum = 0;
                            while (parametersMatch && parameterTypeNum < parameterTypes.length) {
                                Class<?> parameterType = parameterTypes[parameterTypeNum];
                                if (_objs[parameterTypeNum] != null && !parameterType.isAssignableFrom(_objs.getClass())) {
                                    parametersMatch = false;
                                }
                                ++parameterTypeNum;
                            }
                        }
                        matchingMethod = method;
                    }
                    ++methodNum;
                }
                if (matchingMethod != null) {
                    results = matchingMethod.invoke(this._modelProcessor, _objs);
                } else {
                    System.out.println("EOFSQLGenerator.callModelProcessorMethodIfExists: Missing delegate " + methodName);
                }
            }
            return results;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to execute " + methodName + " on " + this._modelProcessor + ".", t);
        }
    }

    public void findModelProcessor(String modelProcessorClassName, boolean throwExceptionIfMissing) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            Class<?> modelProcessorClass = Class.forName(modelProcessorClassName);
            this._modelProcessor = modelProcessorClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
        }
        catch (InstantiationException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void executeSQL(String sql) throws SQLException {
        this.fixClassPath();
        databaseContext = EODatabaseContext.Factory.newDatabaseContextForDatabase((EODatabase)EODatabase.Factory.newDatabaseForModel((EOModel)this._model));
        adaptorContext = databaseContext.adaptorContext();
        beforeOpenChannels = new NSMutableArray();
        beforeChannelsEnum = adaptorContext.channels().objectEnumerator();
        while (beforeChannelsEnum.hasMoreElements()) {
            channel = (EOAdaptorChannel)beforeChannelsEnum.nextElement();
            if (!channel.isOpen()) continue;
            beforeOpenChannels.addObject((Object)channel);
        }
        try {
            databaseChannel = databaseContext.availableChannel();
            adaptorChannel = databaseChannel.adaptorChannel();
            channelOpen = adaptorChannel.isOpen();
            if (!channelOpen) {
                adaptorChannel.openChannel();
            }
            try {
                jdbccontext = (JDBCContext)adaptorChannel.adaptorContext();
                try {
                    jdbccontext.beginTransaction();
                    conn = jdbccontext.connection();
                    stmt = conn.createStatement();
                    stmt.executeUpdate(sql);
                    conn.commit();
                }
                catch (SQLException sqlexception) {
                    sqlexception.printStackTrace(System.out);
                    jdbccontext.rollbackTransaction();
                    throw sqlexception;
                }
            }
            catch (Throwable var12_13) {
                if (!channelOpen) {
                    adaptorChannel.closeChannel();
                }
                throw var12_13;
            }
            if (!channelOpen) {
                adaptorChannel.closeChannel();
            }
        }
        finally {
            afterChannelsEnum = adaptorContext.channels().objectEnumerator();
            if (true) ** GOTO lbl48
        }
        {
        }
        do {
            if (!(channel = (EOAdaptorChannel)afterChannelsEnum.nextElement()).isOpen() || beforeOpenChannels.containsObject((Object)channel)) continue;
            channel.closeChannel();
lbl48:
            // 3 sources

        } while (afterChannelsEnum.hasMoreElements());
    }

    public Map externalTypes() {
        EODatabaseContext dbc = EODatabaseContext.Factory.newDatabaseContextForDatabase((EODatabase)EODatabase.Factory.newDatabaseForModel((EOModel)this._model));
        EOAdaptorContext ac = dbc.adaptorContext();
        NSDictionary jdbc2Info = ((JDBCAdaptor)ac.adaptor()).plugIn().jdbcInfo();
        return (Map)EOFSQLUtils56.toJavaCollections(jdbc2Info);
    }
}

