/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.utils;

import java.util.Map;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingConvention {
    public static final NamingConvention DEFAULT = new NamingConvention(Case.Camel, Separator.None, null, null);
    private Case _case;
    private Separator _separator;
    private String _prefix;
    private String _suffix;

    public NamingConvention() {
    }

    public NamingConvention(Case ccase, Separator separator, String prefix, String suffix) {
        this._case = ccase;
        this._separator = separator;
        this._prefix = prefix != null && prefix.length() == 0 ? null : prefix;
        this._suffix = suffix != null && suffix.length() == 0 ? null : suffix;
    }

    public int hashCode() {
        return this._case.hashCode() + this._separator.hashCode() + (this._prefix == null ? 0 : this._prefix.hashCode()) + (this._suffix == null ? 0 : this._suffix.hashCode());
    }

    public boolean equals(Object obj) {
        return obj instanceof NamingConvention && ComparisonUtils.equals((Object)this._case, (Object)((NamingConvention)obj)._case) && ComparisonUtils.equals((Object)this._separator, (Object)((NamingConvention)obj)._separator) && ComparisonUtils.equals(this._prefix, ((NamingConvention)obj)._prefix) && ComparisonUtils.equals(this._suffix, ((NamingConvention)obj)._suffix);
    }

    public Case getCase() {
        return this._case;
    }

    public void setCase(Case ccase) {
        this._case = ccase;
    }

    public Separator getSeparator() {
        return this._separator;
    }

    public void setSeparator(Separator separator) {
        this._separator = separator;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public void setSuffix(String suffix) {
        this._suffix = suffix;
    }

    public String format(String oldName, String newName, String oldFormattedName) {
        String expectedOldFormattedName = this.format(oldName);
        String newFormattedName = oldFormattedName == null || oldFormattedName.length() == 0 || ComparisonUtils.equals(expectedOldFormattedName, oldFormattedName) ? this.format(newName) : oldFormattedName;
        return newFormattedName;
    }

    public String format(String name) {
        String newName = name;
        if (name == null) {
            newName = null;
        } else {
            if (this._prefix != null) {
                newName = String.valueOf(this._prefix) + newName;
            }
            if (this._suffix != null) {
                newName = String.valueOf(newName) + this._suffix;
            }
            if (this._separator == Separator.None) {
                if (this._case != Case.Camel) {
                    if (this._case == Case.CappedCamel) {
                        newName = StringUtils.toUppercaseFirstLetter(newName);
                    } else if (this._case == Case.Lower) {
                        newName = newName.toLowerCase();
                    } else if (this._case == Case.Upper) {
                        newName = newName.toUpperCase();
                    }
                }
            } else if (this._separator == Separator.Underscore) {
                if (this._case == Case.Camel) {
                    newName = StringUtils.camelCaseToUnderscore(newName, false);
                } else if (this._case == Case.CappedCamel) {
                    newName = StringUtils.toUppercaseFirstLetter(StringUtils.camelCaseToUnderscore(newName, false));
                } else if (this._case == Case.Lower) {
                    newName = StringUtils.camelCaseToUnderscore(newName, true);
                } else if (this._case == Case.Upper) {
                    newName = StringUtils.camelCaseToUnderscore(newName, false).toUpperCase();
                }
            }
        }
        return newName;
    }

    public void loadFromMap(Map<String, String> map) {
        this._prefix = map.get("prefix");
        this._suffix = map.get("suffix");
        this._case = Case.valueOf(map.get("case"));
        this._separator = Separator.valueOf(map.get("separator"));
    }

    public Map<String, String> toMap() {
        PropertyListMap<String, String> namingConventionMap = new PropertyListMap<String, String>();
        namingConventionMap.put("prefix", this.getPrefix());
        namingConventionMap.put("suffix", this.getSuffix());
        namingConventionMap.put("case", this.getCase().name());
        namingConventionMap.put("separator", this.getSeparator().name());
        return namingConventionMap;
    }

    public static NamingConvention loadFromMap(String name, EOModelMap map) {
        NamingConvention namingConvention;
        Map namingConventionMap = map.getMap(name);
        if (namingConventionMap != null) {
            namingConvention = new NamingConvention();
            namingConvention.loadFromMap(namingConventionMap);
        } else {
            namingConvention = DEFAULT;
        }
        return namingConvention;
    }

    public static void toMap(NamingConvention namingConvention, String name, Map<String, Object> map) {
        if (namingConvention != null && !namingConvention.equals(DEFAULT)) {
            map.put(name, namingConvention.toMap());
        } else {
            map.remove(name);
        }
    }

    public static String newClassName(String oldName, String newName, String oldClassName) {
        String newClassName;
        if (ComparisonUtils.equals(oldName, oldClassName, true)) {
            newClassName = newName;
        } else if (oldClassName != null && oldClassName.endsWith("." + oldName)) {
            String oldPackage = oldClassName.substring(0, oldClassName.lastIndexOf(46) + 1);
            newClassName = String.valueOf(oldPackage) + newName;
        } else {
            newClassName = oldClassName;
        }
        return newClassName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Case {
        Upper,
        Lower,
        Camel,
        CappedCamel;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Separator {
        None,
        Underscore;

    }
}

