/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.doc;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.doc.Activator;
import org.objectstyle.wolips.thirdparty.velocity.WOLipsVelocityUtils;
import org.osgi.framework.Bundle;

public class EOModelGraffleGenerator {
    private int _id;
    private Map<Object, Integer> _ids;
    private VelocityEngine _velocityEngine;
    private VelocityContext _context;
    private EOModelGroup _modelGroup;
    private File _outputFile;
    private FileWriter _outputWriter;

    public EOModelGraffleGenerator(boolean insideEclipse, EOModelGroup modelGroup, File outputFile) throws Exception {
        Bundle templateBundle = insideEclipse ? Activator.getDefault().getBundle() : null;
        this._id = 2;
        this._velocityEngine = new VelocityEngine();
        this._velocityEngine.setProperty("runtime.log.logsystem.class", NullLogSystem.class.getName());
        StringBuffer templatePaths = new StringBuffer();
        templatePaths.append(".");
        this._velocityEngine.setProperty("resource.loader", "file,class");
        this._velocityEngine.setProperty("file.resource.loader.class", FileResourceLoader.class.getName());
        this._velocityEngine.setProperty("file.resource.loader.path", templatePaths.toString());
        this._velocityEngine.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        this._velocityEngine.init();
        this._context = new VelocityContext();
        this._ids = new HashMap<Object, Integer>();
        this._modelGroup = modelGroup;
        this._outputFile = outputFile;
    }

    public Integer nextID() {
        return ++this._id;
    }

    protected void generateConnections() throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        for (EOModel model : this._modelGroup.getModels()) {
            for (EOEntity entity : model.getEntities()) {
                if (entity.isPrototype()) continue;
                EOEntity parentEntity = entity.getParent();
                if (parentEntity != null) {
                    this._context.put("id", this._ids.get(String.valueOf(entity.getName()) + "Parent"));
                    this._context.put("fromID", this._ids.get(entity));
                    this._context.put("toID", this._ids.get(parentEntity));
                    this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/subEntity.vm"));
                }
                for (EORelationship relationship : entity.getRelationships()) {
                    this._context.put("relationship", relationship);
                    this._context.put("id", this._ids.get(String.valueOf(relationship.getFullyQualifiedName()) + "Line"));
                    this._context.put("fromID", this._ids.get(relationship));
                    this._context.put("toID", this._ids.get(relationship.getDestination()));
                    if (relationship.isToOne().booleanValue()) {
                        this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/toOne.vm"));
                        continue;
                    }
                    if (!relationship.isToMany().booleanValue()) continue;
                    this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/toMany.vm"));
                }
            }
        }
    }

    protected void generateNodes() throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        for (EOModel model : this._modelGroup.getModels()) {
            for (EOEntity entity : model.getEntities()) {
                if (entity.isPrototype()) continue;
                this._context.put("id", this._ids.get(String.valueOf(entity.getName()) + "Group"));
                this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/groupHeader.vm"));
                int entityX = (int)(Math.random() * 2000.0);
                int entityY = (int)(Math.random() * 2000.0);
                int marginTop = 26;
                int attributeHeight = 20;
                int relationshipHeight = 20;
                int verticalSpacer = 20;
                int marginBottom = 20;
                int width = 220;
                int attributeNum = 0;
                for (EOAttribute attribute : entity.getAttributes()) {
                    this._context.put("attribute", attribute);
                    this._context.put("id", this._ids.get(attribute));
                    this._context.put("x", entityX);
                    this._context.put("y", entityY + marginTop + attributeHeight * attributeNum);
                    this._context.put("width", width);
                    this._context.put("height", attributeHeight);
                    this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/attribute.vm"));
                    ++attributeNum;
                }
                int relationshipNum = 0;
                for (EORelationship relationship : entity.getRelationships()) {
                    this._context.put("relationship", relationship);
                    this._context.put("id", this._ids.get(relationship));
                    this._context.put("x", entityX);
                    this._context.put("y", entityY + marginTop + attributeHeight * attributeNum + verticalSpacer + relationshipHeight * relationshipNum);
                    this._context.put("width", width);
                    this._context.put("height", relationshipHeight);
                    this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/relationship.vm"));
                    ++relationshipNum;
                }
                int height = marginTop + entity.getAttributes().size() * attributeHeight + verticalSpacer + entity.getRelationships().size() * relationshipHeight + marginBottom;
                this._context.put("entity", entity);
                this._context.put("id", this._ids.get(entity));
                this._context.put("x", entityX);
                this._context.put("y", entityY);
                this._context.put("width", width);
                this._context.put("height", height);
                this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/entity.vm"));
                this._context.put("id", this._ids.get(String.valueOf(entity.getName()) + "Group"));
                this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/groupFooter.vm"));
            }
        }
    }

    public void generate() throws Exception {
        this._outputWriter = new FileWriter(this._outputFile);
        try {
            for (EOModel model : this._modelGroup.getModels()) {
                this._ids.put(model, this.nextID());
                for (EOEntity entity : model.getEntities()) {
                    if (entity.isPrototype()) continue;
                    this._ids.put(entity, this.nextID());
                    this._ids.put(String.valueOf(entity.getName()) + "Group", this.nextID());
                    EOEntity parentEntity = entity.getParent();
                    if (parentEntity != null) {
                        this._ids.put(String.valueOf(entity.getName()) + "Parent", this.nextID());
                    }
                    for (EOAttribute attribute : entity.getAttributes()) {
                        this._ids.put(attribute, this.nextID());
                    }
                    for (EORelationship relationship : entity.getRelationships()) {
                        this._ids.put(relationship, this.nextID());
                        this._ids.put(String.valueOf(relationship.getFullyQualifiedName()) + "Line", this.nextID());
                    }
                }
            }
            this._context.put("id", this.nextID());
            this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/header.vm"));
            this.generateNodes();
            this.generateConnections();
            this._outputWriter.append(WOLipsVelocityUtils.writeTemplateToString(this._velocityEngine, this._context, "graffle/footer.vm"));
        }
        finally {
            this._outputWriter.close();
        }
    }
}

