/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;
import org.objectstyle.wolips.eogenerator.core.model.EOGeneratorModel;
import org.objectstyle.wolips.eogenerator.core.model.EOModelReference;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.IEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.utils.EclipseFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseEOModelGroupFactory
implements IEOModelGroupFactory {
    @Override
    public boolean loadModelGroup(Object modelGroupResource, EOModelGroup modelGroup, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) throws EOModelException {
        int previousModelCount = modelGroup.getModels().size();
        try {
            URL jarResourcesURL;
            File modelURIFile;
            IResource modelGroupEclipseResource = this.getEclipseResourceForModelResource(modelGroupResource);
            if (modelGroupEclipseResource != null) {
                IProject project = modelGroupEclipseResource.getProject();
                if ("eomodelgroup".equals(modelGroupEclipseResource.getFileExtension())) {
                    this.addModelsFromEOModelGroupFile((IFile)modelGroupEclipseResource, modelGroup, failures, skipOnDuplicates, progressMonitor);
                } else {
                    this.addModelsFromProject(modelGroup, project, new HashSet<Object>(), new HashSet<IProject>(), failures, skipOnDuplicates, progressMonitor, 0);
                    File modelGroupEclipseResourceFile = modelGroupEclipseResource.getLocation().toFile();
                    if (modelGroupEclipseResourceFile != null && EOModelGroup.getModelNameForFile(modelGroupEclipseResourceFile) != null) {
                        modelGroup.loadModelFromURL(modelGroupEclipseResourceFile.toURL(), failures, skipOnDuplicates, progressMonitor);
                    }
                }
            } else if (modelGroupResource instanceof URL) {
                URL jarResourcesURL2;
                File modelURLFile = URLUtils.cheatAndTurnIntoFile((URL)modelGroupResource);
                if (modelURLFile != null && URLUtils.exists(jarResourcesURL2 = new URL("jar:" + modelURLFile.toURL() + "!/Resources"))) {
                    modelGroup.loadModelsFromURL(jarResourcesURL2, 1, failures, skipOnDuplicates, progressMonitor);
                }
            } else if (modelGroupResource instanceof URI && (modelURIFile = URLUtils.cheatAndTurnIntoFile((URI)modelGroupResource)) != null && URLUtils.exists(jarResourcesURL = new URL("jar:" + modelURIFile.toURL() + "!/Resources"))) {
                modelGroup.loadModelsFromURL(jarResourcesURL, 1, failures, skipOnDuplicates, progressMonitor);
            }
        }
        catch (EOModelException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EOModelException("Failed to load model group.", t);
        }
        boolean allModelsLoaded = modelGroup.getModels().size() - previousModelCount > 1;
        return allModelsLoaded;
    }

    protected IResource getEclipseResourceForModelResource(Object modelResource) {
        IResource resource = null;
        resource = modelResource instanceof IResource ? (IResource)modelResource : (modelResource instanceof URL ? EclipseFileUtils.getEclipseFile((URL)modelResource) : (modelResource instanceof URI ? EclipseFileUtils.getEclipseFile((URI)modelResource) : null));
        return resource;
    }

    protected void addModelsFromProject(EOModelGroup modelGroup, IProject project, Set<Object> searchedResources, Set<IProject> searchedProjects, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor, int depth) throws IOException, EOModelException, CoreException {
        if (!searchedProjects.contains(project)) {
            progressMonitor.setTaskName("Adding models from " + project.getName() + " ...");
            searchedProjects.add(project);
            if (!project.exists()) {
                failures.add(new EOModelVerificationFailure(null, "The dependent project '" + project.getName() + "' does not exist.", false));
            } else if (!project.isOpen()) {
                failures.add(new EOModelVerificationFailure(null, "The dependent project '" + project.getName() + "' exists but is not open.", false));
            } else {
                boolean showProgress;
                boolean visitedProject = false;
                boolean isJavaProject = project.getNature("org.eclipse.jdt.core.javanature") != null;
                IClasspathEntry[] classpathEntries = null;
                if (isJavaProject) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    classpathEntries = javaProject.getResolvedClasspath(true);
                } else {
                    classpathEntries = new IClasspathEntry[]{};
                }
                boolean bl = showProgress = depth == 0;
                if (showProgress) {
                    progressMonitor.beginTask("Scanning " + project.getName() + " classpath ...", classpathEntries.length + 1);
                }
                int classpathEntryNum = 0;
                while (classpathEntryNum < classpathEntries.length) {
                    IClasspathEntry entry = classpathEntries[classpathEntryNum];
                    int entryKind = entry.getEntryKind();
                    if (entryKind == 1) {
                        File resourcesFolder;
                        LinkedList<IPath> jarPaths = new LinkedList<IPath>();
                        IPath path = entry.getPath();
                        IPath frameworkPath = null;
                        while (frameworkPath == null && path.lastSegment() != null) {
                            String lastSegment = path.lastSegment();
                            if (lastSegment != null && lastSegment.endsWith(".framework")) {
                                frameworkPath = path;
                                continue;
                            }
                            if (lastSegment != null && lastSegment.endsWith(".jar")) {
                                IFile jarInProject = project.getWorkspace().getRoot().getFile(path);
                                if (jarInProject.exists()) {
                                    jarPaths.add(jarInProject.getLocation());
                                } else {
                                    jarPaths.add(path);
                                }
                            }
                            path = path.removeLastSegments(1);
                        }
                        if (frameworkPath != null && !searchedResources.contains(resourcesFolder = frameworkPath.append("Resources").toFile()) && resourcesFolder.exists()) {
                            searchedResources.add(resourcesFolder);
                            modelGroup.loadModelsFromURL(resourcesFolder.toURL(), 1, failures, skipOnDuplicates, progressMonitor);
                        }
                        for (IPath jarPath : jarPaths) {
                            URL jarResourcesURL = new URL("jar:" + jarPath.toFile().toURL() + "!/Resources");
                            if (searchedResources.contains(jarResourcesURL) || !URLUtils.exists(jarResourcesURL)) continue;
                            modelGroup.loadModelsFromURL(jarResourcesURL, 1, failures, skipOnDuplicates, progressMonitor);
                        }
                    } else if (entryKind == 2) {
                        IPath path = entry.getPath();
                        IProject dependsOnProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
                        this.addModelsFromProject(modelGroup, dependsOnProject, searchedResources, searchedProjects, failures, skipOnDuplicates, progressMonitor, depth + 1);
                    } else if (entryKind == 3) {
                        visitedProject = true;
                        project.accept((IResourceVisitor)new ModelVisitor(project, modelGroup, searchedResources, failures, skipOnDuplicates, progressMonitor), 2, 4);
                    }
                    if (showProgress) {
                        progressMonitor.worked(1);
                    }
                    ++classpathEntryNum;
                }
                if (!visitedProject) {
                    project.accept((IResourceVisitor)new ModelVisitor(project, modelGroup, searchedResources, failures, skipOnDuplicates, progressMonitor), 2, 4);
                    if (showProgress) {
                        progressMonitor.worked(1);
                    }
                }
            }
        }
    }

    protected void addModelsFromEOModelGroupFile(IFile eoModelGroupFile, EOModelGroup modelGroup, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) throws ParseException, CoreException, IOException, EOModelException {
        EOModel model = null;
        IProject project = eoModelGroupFile.getProject();
        EOGeneratorModel eogeneratorModel = EOGeneratorModel.createModelFromFile((IFile)eoModelGroupFile);
        LinkedList modelRefList = new LinkedList();
        modelRefList.addAll(eogeneratorModel.getModels());
        modelRefList.addAll(eogeneratorModel.getRefModels());
        for (EOModelReference modelRef : modelRefList) {
            String modelPath = modelRef.getPath((IResource)project);
            File modelFolder = new File(modelPath);
            if (!modelFolder.isAbsolute()) {
                modelFolder = new File(project.getLocation().toFile(), modelPath);
            }
            if (model == null) {
                modelGroup.setEditingModelURL(modelFolder.toURL());
            }
            EOModel modelGroupModel = modelGroup.loadModelFromURL(modelFolder.toURL(), failures, skipOnDuplicates, progressMonitor);
            if (model != null) continue;
            model = modelGroupModel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ModelVisitor
    implements IResourceVisitor {
        private IProject _project;
        private EOModelGroup _modelGroup;
        private Set<EOModelVerificationFailure> _failures;
        private Set<Object> _searchedResources;
        private boolean _skipOnDuplicates;
        private IProgressMonitor _progressMonitor;
        private IProjectPatternsets _patternsets;

        public ModelVisitor(IProject project, EOModelGroup modelGroup, Set<Object> searchedResources, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) {
            this._project = project;
            this._modelGroup = modelGroup;
            this._failures = failures;
            this._searchedResources = searchedResources;
            this._skipOnDuplicates = skipOnDuplicates;
            this._progressMonitor = progressMonitor;
            this._patternsets = (IProjectPatternsets)project.getAdapter(IProjectPatternsets.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean visit(IResource resource) throws CoreException {
            boolean continueScanning;
            block13: {
                block10: {
                    String name;
                    block12: {
                        block11: {
                            block9: {
                                block8: {
                                    try {
                                        if (resource.isAccessible()) break block8;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        throw new CoreException(new Status(4, "org.objectstyle.wolips.eomodeler.eclipse", 0, "Failed to load model in " + resource + ": " + e, e));
                                    }
                                }
                                if (!resource.isDerived()) break block9;
                                return false;
                            }
                            name = resource.getName();
                            if (name == null) break block10;
                            if ("build".equals(name)) return false;
                            if ("dist".equals(name)) return false;
                            if ("target".equals(name)) return false;
                            if (name.endsWith(".wo")) return false;
                            if ("woproject".equals(name)) return false;
                            if (!name.startsWith(".")) break block11;
                            return false;
                        }
                        if (!name.endsWith(".framework") && !name.endsWith(".woa")) break block12;
                        String projectName = resource.getProject().getName();
                        if (name.equals(String.valueOf(projectName) + ".framework")) return false;
                        if (!name.equals(String.valueOf(projectName) + ".woa")) break block12;
                        return false;
                    }
                    if ("WebServerResources".equals(name)) return false;
                    if (!"Components".equals(name)) break block10;
                    return false;
                }
                continueScanning = true;
                if (resource.getType() != 2) return continueScanning;
                if (this._patternsets != null && !this._patternsets.matchesResourcesPattern(resource)) break block13;
                this._progressMonitor.setTaskName("Scanning " + resource.getName() + " ...");
                File resourceFile = resource.getLocation().toFile();
                if (this._searchedResources.contains(resourceFile)) return continueScanning;
                if (!"eomodeld".equals(resource.getFileExtension())) return continueScanning;
                this._modelGroup.loadModelFromURL(resourceFile.toURL(), this._failures, this._skipOnDuplicates, this._progressMonitor);
                return false;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this._project);
            if (!javaProject.isOnClasspath(resource)) return continueScanning;
            return true;
        }
    }
}

