/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.eclipse;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.core.util.WeakHashSet;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.actions.OpenEntityModelerAction;
import org.objectstyle.wolips.ui.actions.OpenWOAction;

public class PackageExplorerDoubleClickHandler
implements IPageListener,
IPartListener2,
IDoubleClickListener,
IWindowListener {
    private WeakHashSet _listeningPackageExplorers = new WeakHashSet();

    public void registerListeners() {
        IWorkbenchWindow[] windows;
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.windowOpened(window, true);
            ++n2;
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.windowOpened(window, false);
    }

    public void windowOpened(final IWorkbenchWindow window, boolean startup) {
        IPerspectiveDescriptor descriptor;
        IWorkbenchPage activePage;
        window.addPageListener((IPageListener)this);
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            IWorkbenchPage page = pages[i];
            this.pageOpened(page);
            ++i;
        }
        if (startup && Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerChangePerspectives") && (activePage = window.getActivePage()) != null && (descriptor = activePage.getPerspective()) != null && "org.objectstyle.wolips.eomodeler.EOModelerPerspective".equals(descriptor.getId())) {
            IEditorReference[] editorReferences = activePage.getEditorReferences();
            boolean containsEntityModeler = false;
            IEditorReference[] iEditorReferenceArray = editorReferences;
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if ("org.objectstyle.wolips.eomodeler.editors.EOModelEditor".equals(editorReference.getId())) {
                    containsEntityModeler = true;
                }
                ++n2;
            }
            if (!containsEntityModeler) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            window.getWorkbench().showPerspective("org.objectstyle.wolips.ui.Perspective", window);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    public void pageActivated(IWorkbenchPage _page) {
        this.findAndAttachToPackageExplorerInPage(_page);
        _page.addPartListener((IPartListener2)this);
    }

    public void pageClosed(IWorkbenchPage _page) {
        _page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage _page) {
        _page.addPartListener((IPartListener2)this);
        this.findAndAttachToPackageExplorerInPage(_page);
    }

    public void partActivated(IWorkbenchPartReference _partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference _partRef) {
    }

    public void partClosed(IWorkbenchPartReference _partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference _partRef) {
    }

    public void partHidden(IWorkbenchPartReference _partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference _partRef) {
    }

    public void partOpened(IWorkbenchPartReference _partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.attachToPartIfNecessary(partRef);
    }

    protected void findAndAttachToPackageExplorerInPage(IWorkbenchPage page) {
        IViewReference packageExplorerPartRef = page.findViewReference("org.eclipse.jdt.ui.PackageExplorer");
        this.attachToPartIfNecessary((IWorkbenchPartReference)packageExplorerPartRef);
        IViewReference wopackageExplorerPartRef = page.findViewReference("org.objectstyle.wolips.jdt.ui.WOPackageExplorer");
        this.attachToPartIfNecessary((IWorkbenchPartReference)wopackageExplorerPartRef);
    }

    protected synchronized void attachToPartIfNecessary(IWorkbenchPartReference partReference) {
        TreeViewer packageExplorerTreeViewer;
        PackageExplorerPart packageExplorerPart;
        IWorkbenchPart part;
        if (partReference != null && ("org.eclipse.jdt.ui.PackageExplorer".equals(partReference.getId()) || "org.objectstyle.wolips.jdt.ui.WOPackageExplorer".equals(partReference.getId())) && (part = partReference.getPart(false)) instanceof PackageExplorerPart && !this._listeningPackageExplorers.contains((Object)(packageExplorerPart = (PackageExplorerPart)part)) && (packageExplorerTreeViewer = packageExplorerPart.getTreeViewer()) != null) {
            packageExplorerTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
            this._listeningPackageExplorers.add((Object)packageExplorerPart);
        }
    }

    public void doubleClick(DoubleClickEvent _event) {
        ISelection selection = _event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedObj : structuredSelection) {
                IFolder selectedFolder;
                if (!(selectedObj instanceof IFolder) || OpenEntityModelerAction.openResourceIfPossible(null, selectedFolder = (IFolder)selectedObj)) continue;
                OpenWOAction.openResourceIfPossible((IResource)selectedFolder);
            }
        }
    }
}

