/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.editors.EOModelEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOModelErrorDialog
extends Dialog {
    public static final int DELETE_ANYWAY_ID = 100;
    private EOModelEditor _editor;
    private boolean _showDeleteAnywayButton;
    private Set<? extends EOModelVerificationFailure> _failures;

    public EOModelErrorDialog(Shell parentShell, Set<? extends EOModelVerificationFailure> failures) {
        this(parentShell, failures, false, null);
    }

    public EOModelErrorDialog(Shell parentShell, Set<? extends EOModelVerificationFailure> failures, EOModelEditor editor) {
        this(parentShell, failures, false, editor);
    }

    public EOModelErrorDialog(Shell parentShell, Set<? extends EOModelVerificationFailure> failures, boolean showDeleteAnywayButton) {
        this(parentShell, failures, showDeleteAnywayButton, null);
    }

    public EOModelErrorDialog(Shell parentShell, Set<? extends EOModelVerificationFailure> failures, boolean showDeleteAnywayButton, EOModelEditor editor) {
        super(parentShell);
        this._failures = failures;
        this._showDeleteAnywayButton = showDeleteAnywayButton;
        this._editor = editor;
    }

    protected void configureShell(Shell _newShell) {
        super.configureShell(_newShell);
        _newShell.setText("EOModel Verification Failures");
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        IEditorPart editorPart;
        IWorkbenchWindow activeWindow;
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this._editor == null && (activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (editorPart = activeWindow.getActivePage().getActiveEditor()) instanceof EOModelEditor) {
            this._editor = (EOModelEditor)editorPart;
        }
        final ScrolledComposite scrollComposite = new ScrolledComposite(composite, 2560);
        scrollComposite.setBackground(composite.getDisplay().getSystemColor(1));
        GridData failuresGridData = new GridData(1808);
        failuresGridData.widthHint = 500;
        failuresGridData.heightHint = 400;
        scrollComposite.setLayoutData((Object)failuresGridData);
        final Composite failuresComposite = new Composite((Composite)scrollComposite, 0);
        failuresComposite.setBackground(scrollComposite.getBackground());
        int columns = this._editor == null ? 2 : 3;
        GridLayout layout = new GridLayout(columns, false);
        failuresComposite.setLayout((Layout)layout);
        Iterator<? extends EOModelVerificationFailure> failuresIter = this._failures.iterator();
        if (!failuresIter.hasNext()) {
            Label failedObjectLabel = new Label(failuresComposite, 0);
            failedObjectLabel.setBackground(failuresComposite.getBackground());
            failedObjectLabel.setText("There are no verification failures with this model group.");
            failedObjectLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            failedObjectLabel.setAlignment(0x1000000);
            failedObjectLabel.setLayoutData((Object)new GridData(768));
        }
        while (failuresIter.hasNext()) {
            EOModelVerificationFailure failure = failuresIter.next();
            Label iconLabel = new Label(failuresComposite, 0);
            iconLabel.setBackground(failuresComposite.getBackground());
            if (failure.isWarning()) {
                iconLabel.setImage(composite.getDisplay().getSystemImage(8));
            } else {
                iconLabel.setImage(composite.getDisplay().getSystemImage(1));
            }
            GridData iconLabelData = new GridData();
            iconLabelData.verticalIndent = 3;
            iconLabelData.verticalAlignment = 1;
            iconLabelData.horizontalIndent = 3;
            iconLabel.setLayoutData((Object)iconLabelData);
            Composite groupFailureComposite = new Composite(failuresComposite, 0);
            groupFailureComposite.setBackground(failuresComposite.getBackground());
            groupFailureComposite.setLayout((Layout)new GridLayout(1, true));
            GridData groupFailureLabelData = new GridData(768);
            groupFailureLabelData.horizontalIndent = 3;
            groupFailureComposite.setLayoutData((Object)groupFailureLabelData);
            Label failedObjectLabel = new Label(groupFailureComposite, 0);
            failedObjectLabel.setBackground(failuresComposite.getBackground());
            EOModelObject failedObject = failure.getFailedObject();
            if (failedObject != null) {
                failedObjectLabel.setText(failedObject.getFullyQualifiedName());
            } else {
                failedObjectLabel.setText("General Failure");
            }
            failedObjectLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            failedObjectLabel.setForeground(failuresComposite.getDisplay().getSystemColor(16));
            failedObjectLabel.setLayoutData((Object)new GridData(768));
            StyledText failureLabel = new StyledText(groupFailureComposite, 64);
            failureLabel.setEditable(false);
            failureLabel.setWordWrap(true);
            failureLabel.setEnabled(false);
            String failureMessage = failure.getMessage();
            failureLabel.setText(failureMessage);
            GridData failureLabelData = new GridData(768);
            failureLabel.setLayoutData((Object)failureLabelData);
            if (this._editor != null && failure.getFailedObject() != null) {
                Button showButton = new Button(failuresComposite, 8);
                showButton.setText("Show");
                GridData showButtonData = new GridData();
                showButtonData.verticalAlignment = 0x1000000;
                showButtonData.horizontalIndent = 3;
                showButton.setLayoutData((Object)showButtonData);
                showButton.setData((Object)failure);
                showButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        EOModelVerificationFailure selectedFailure = (EOModelVerificationFailure)((Widget)e.getSource()).getData();
                        if (selectedFailure != null && EOModelErrorDialog.this._editor != null && selectedFailure.getFailedObject() != null) {
                            EOModelErrorDialog.this._editor.setSelection((ISelection)new StructuredSelection((Object)selectedFailure.getFailedObject()));
                            EOModelErrorDialog.this.close();
                        }
                    }
                });
            }
            Matcher matcher = Pattern.compile("(\\S+: \\S+)").matcher(failureMessage);
            while (matcher.find()) {
                int start = matcher.start(1);
                int end = matcher.end(1);
                StyleRange styleRange = new StyleRange();
                styleRange.start = start;
                styleRange.length = end - start;
                styleRange.fontStyle = 1;
                failureLabel.setStyleRange(styleRange);
            }
            if (!failuresIter.hasNext()) continue;
            Composite separator = new Composite(failuresComposite, 0);
            separator.setBackground(failuresComposite.getDisplay().getSystemColor(15));
            GridData separatorData = new GridData(768);
            separatorData.heightHint = 1;
            separatorData.verticalIndent = 3;
            separatorData.horizontalSpan = columns;
            separator.setLayoutData((Object)separatorData);
        }
        scrollComposite.setContent((Control)failuresComposite);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollComposite.getClientArea();
                scrollComposite.setMinSize(failuresComposite.computeSize(r.width, -1));
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this._showDeleteAnywayButton) {
            this.createButton(parent, 100, "Delete Anyway", false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 100) {
            this.setReturnCode(100);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected static class FailureContentProvider
    implements IStructuredContentProvider {
        protected FailureContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Collection failures = (Collection)inputElement;
            return failures.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class FailureLabelProvider
    implements ILabelProvider {
        protected FailureLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            EOModelVerificationFailure failure = (EOModelVerificationFailure)element;
            return failure.getMessage();
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

