/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.attributes;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.objectstyle.wolips.baseforuiplugins.utils.KeyComboBoxCellEditor;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyCellModifier;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EOAttributesCellModifier
extends TablePropertyCellModifier {
    private static final String NO_PROTOYPE_VALUE = Messages.getString("EOAttributesCellModifier.noPrototype");
    private CellEditor[] myCellEditors;
    private List<String> myPrototypeNames;

    public EOAttributesCellModifier(TableViewer _attributesTableViewer, CellEditor[] _cellEditors) {
        super(_attributesTableViewer);
        this.myCellEditors = _cellEditors;
    }

    protected boolean _canModify(Object _element, String _property) {
        boolean canModify = true;
        if ("prototype".equals(_property)) {
            EOEntity entity = (EOEntity)this.getTableViewer().getInput();
            this.myPrototypeNames = new LinkedList<String>(entity.getModel().getPrototypeAttributeNames());
            this.myPrototypeNames.add(0, NO_PROTOYPE_VALUE);
            String[] prototypeNames = this.myPrototypeNames.toArray(new String[this.myPrototypeNames.size()]);
            int columnNumber = TableUtils.getColumnNumberForTablePropertyNamed(EOAttribute.class.getName(), _property);
            if (columnNumber != -1) {
                KeyComboBoxCellEditor cellEditor = (KeyComboBoxCellEditor)this.myCellEditors[columnNumber];
                cellEditor.setItems(prototypeNames);
            }
        }
        return canModify;
    }

    public Object getValue(Object _element, String _property) {
        EOAttribute attribute = (EOAttribute)_element;
        Object value = null;
        if ("prototype".equals(_property)) {
            EOAttribute prototype = attribute.getPrototype();
            String prototypeName = prototype == null ? NO_PROTOYPE_VALUE : prototype.getName();
            value = new Integer(this.myPrototypeNames.indexOf(prototypeName));
        } else if ("allowsNull".equals(_property) || "classProperty".equals(_property) || "clientClassProperty".equals(_property) || "indexed".equals(_property) || "primaryKey".equals(_property) || "readOnly".equals(_property) || "usedForLocking".equals(_property)) {
            value = super.getValue(_element, _property);
            if (value == null && !attribute.getEntity().isPrototype()) {
                value = Boolean.FALSE;
            }
        } else {
            value = super.getValue(_element, _property);
        }
        return value;
    }

    protected boolean _modify(Object _element, String _property, Object _value) throws Throwable {
        boolean modified = false;
        EOAttribute attribute = (EOAttribute)_element;
        if ("prototype".equals(_property)) {
            String prototypeName;
            Integer prototypeIndex = (Integer)_value;
            int prototypeIndexInt = prototypeIndex;
            String string = prototypeName = prototypeIndexInt == -1 ? null : this.myPrototypeNames.get(prototypeIndexInt);
            if (NO_PROTOYPE_VALUE.equals(prototypeName)) {
                attribute.setPrototype(null, true);
            } else {
                EOAttribute prototype = attribute.getEntity().getModel().getPrototypeAttributeNamed(prototypeName);
                attribute.setPrototype(prototype, true);
            }
            modified = true;
        }
        return modified;
    }
}

