/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.actions.NewManyToManyRelationshipOperation;
import org.objectstyle.wolips.eomodeler.actions.NewOneToManyRelationshipOperation;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;
import org.objectstyle.wolips.eomodeler.editors.entity.EntityPicker;
import org.objectstyle.wolips.eomodeler.editors.relationship.JoinsTableEditor;

public class CreateRelationshipDialog
extends Dialog
implements SelectionListener {
    private EOModelGroup _modelGroup;
    private EOEntity _sourceEntity;
    private EOEntity _destinationEntity;
    private EORelationship _relationship;
    private EORelationship _inverseRelationship;
    private Composite _joinsFields;
    private Label _sourceLabel;
    private Label _destinationLabel;
    private Label _joinsLabel;
    private JoinsTableEditor _joinsTableEditor;
    private String _originalName;
    private Text _nameText;
    private Button _toManyButton;
    private Button _toOneButton;
    private Button _createButton;
    private Button _createFKButton;
    private Text _fkNameText;
    private Text _fkColumnNameText;
    private String _originalInverseName;
    private Text _inverseNameText;
    private Button _inverseToManyButton;
    private Button _inverseToOneButton;
    private Button _createInverseButton;
    private Button _createInverseFKButton;
    private Text _inverseFKNameText;
    private Text _inverseFKColumnNameText;
    private Button _flattenButton;
    private Label _joinEntityNameLabel;
    private Text _joinEntityNameText;
    private Font _titleFont;
    private boolean _manyToMany;
    private boolean _createFK;
    private boolean _createInverseFK;
    private String _guessedJoinEntityName;
    private Label _fkColumnNameLabel;
    private Label _inverseFKColumnNameLabel;
    private Group _destinationFields;
    private Group _sourceFields;
    private String _oldFKName;
    private String _oldInverseFKName;

    public CreateRelationshipDialog(Shell shell, EOModelGroup modelGroup, EOEntity sourceEntity, EOEntity destinationEntity) {
        super(shell);
        this._modelGroup = modelGroup;
        this._sourceEntity = sourceEntity;
        this._destinationEntity = destinationEntity;
    }

    public void setSourceEntity(EOEntity sourceEntity) {
        this._sourceEntity = sourceEntity;
        this._inverseFKNameText.setText("");
        this._inverseFKColumnNameText.setText("");
        this.entitiesChanged();
    }

    public EOEntity getSourceEntity() {
        return this._sourceEntity;
    }

    public void setDestinationEntity(EOEntity destinationEntity) {
        this._destinationEntity = destinationEntity;
        this._fkNameText.setText("");
        this._fkColumnNameText.setText("");
        this.entitiesChanged();
    }

    public EOEntity getDestinationEntity() {
        return this._destinationEntity;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("CreateRelationshipDialog.title"));
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        Rectangle bounds = super.getConstrainedShellBounds(preferredSize);
        if (this._sourceEntity == null || this._destinationEntity == null) {
            bounds.y -= 75;
        }
        return bounds;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        boolean showEntityPickers;
        Composite relationshipDialogArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 15;
        gridLayout.marginLeft = 15;
        gridLayout.marginRight = 15;
        gridLayout.horizontalSpacing = 15;
        relationshipDialogArea.setLayout((Layout)gridLayout);
        boolean bl = showEntityPickers = this._sourceEntity == null || this._destinationEntity == null;
        if (showEntityPickers) {
            Label hintLabel = new Label(relationshipDialogArea, 0);
            hintLabel.setText("Select the entities that this relationship will join together.");
            GridData hintLabelData = new GridData(768);
            hintLabelData.horizontalSpan = 2;
            hintLabel.setLayoutData((Object)hintLabelData);
            hintLabel.setFont(parent.getFont());
            EntityPicker sourceEntityPicker = new EntityPicker(relationshipDialogArea, 0, false);
            sourceEntityPicker.setModelGroup(this._modelGroup);
            sourceEntityPicker.setEntity(this._sourceEntity);
            GridData sourceEntityPickerData = new GridData(768);
            sourceEntityPickerData.verticalIndent = 15;
            sourceEntityPicker.setLayoutData(sourceEntityPickerData);
            sourceEntityPicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EOEntity entity = (EOEntity)((IStructuredSelection)event.getSelection()).getFirstElement();
                    CreateRelationshipDialog.this.setSourceEntity(entity);
                }
            });
            EntityPicker destinationEntityPicker = new EntityPicker(relationshipDialogArea, 0, false);
            destinationEntityPicker.setModelGroup(this._modelGroup);
            destinationEntityPicker.setEntity(this._destinationEntity);
            if (this._destinationEntity == null && this._sourceEntity != null) {
                destinationEntityPicker.setModel(this._sourceEntity.getModel());
            }
            GridData destinationEntityPickerData = new GridData(768);
            destinationEntityPickerData.verticalIndent = 15;
            destinationEntityPicker.setLayoutData(destinationEntityPickerData);
            destinationEntityPicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EOEntity entity = (EOEntity)((IStructuredSelection)event.getSelection()).getFirstElement();
                    CreateRelationshipDialog.this.setDestinationEntity(entity);
                }
            });
        }
        this._sourceLabel = new Label(relationshipDialogArea, 0);
        Font originalFont = this._sourceLabel.getFont();
        FontData[] fontData = originalFont.getFontData();
        this._titleFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        this._sourceLabel.setFont(this._titleFont);
        GridData sourceLabelData = new GridData(768);
        if (showEntityPickers) {
            sourceLabelData.verticalIndent = 15;
        }
        this._sourceLabel.setLayoutData((Object)sourceLabelData);
        this._destinationLabel = new Label(relationshipDialogArea, 0);
        this._destinationLabel.setFont(this._titleFont);
        GridData destinationLabelData = new GridData(768);
        if (showEntityPickers) {
            destinationLabelData.verticalIndent = 15;
        }
        this._destinationLabel.setLayoutData((Object)destinationLabelData);
        this._sourceFields = new Group(relationshipDialogArea, 0);
        GridLayout sourceFieldsLayout = new GridLayout(2, false);
        sourceFieldsLayout.horizontalSpacing = 15;
        sourceFieldsLayout.verticalSpacing = 6;
        this._sourceFields.setLayout((Layout)sourceFieldsLayout);
        this._sourceFields.setLayoutData((Object)new GridData(1808));
        this._toOneButton = new Button((Composite)this._sourceFields, 16);
        this._toOneButton.setSelection(true);
        this._toOneButton.addSelectionListener((SelectionListener)this);
        GridData toOneData = new GridData(768);
        toOneData.horizontalSpan = 2;
        this._toOneButton.setLayoutData((Object)toOneData);
        this._toManyButton = new Button((Composite)this._sourceFields, 16);
        this._toManyButton.addSelectionListener((SelectionListener)this);
        GridData toManyData = new GridData(768);
        toManyData.horizontalSpan = 2;
        this._toManyButton.setLayoutData((Object)toManyData);
        this._createButton = new Button((Composite)this._sourceFields, 32);
        this._createButton.setSelection(true);
        this._createButton.setLayoutData((Object)new GridData());
        this._createButton.addSelectionListener((SelectionListener)this);
        this._nameText = new Text((Composite)this._sourceFields, 2048);
        GridData nameData = new GridData(768);
        nameData.widthHint = 200;
        this._nameText.setLayoutData((Object)nameData);
        this._createFKButton = new Button((Composite)this._sourceFields, 32);
        this._createFKButton.setSelection(true);
        this._createFKButton.setLayoutData((Object)new GridData());
        this._createFKButton.addSelectionListener((SelectionListener)this);
        this._fkNameText = new Text((Composite)this._sourceFields, 2048);
        this._fkNameText.setEnabled(false);
        GridData fkNameData = new GridData(768);
        fkNameData.widthHint = 200;
        this._fkNameText.setLayoutData((Object)fkNameData);
        this._fkColumnNameLabel = new Label((Composite)this._sourceFields, 0);
        this._fkColumnNameLabel.setText("and a new foreign key column named");
        GridData columnNameData = new GridData();
        columnNameData.horizontalIndent = 20;
        this._fkColumnNameLabel.setLayoutData((Object)columnNameData);
        this._fkColumnNameText = new Text((Composite)this._sourceFields, 2048);
        this._fkColumnNameText.setEnabled(false);
        GridData fkColumnNameData = new GridData(768);
        fkColumnNameData.widthHint = 200;
        this._fkColumnNameText.setLayoutData((Object)fkColumnNameData);
        this._destinationFields = new Group(relationshipDialogArea, 0);
        GridLayout destinationFieldsLayout = new GridLayout(2, false);
        destinationFieldsLayout.horizontalSpacing = 15;
        destinationFieldsLayout.verticalSpacing = 6;
        this._destinationFields.setLayout((Layout)destinationFieldsLayout);
        this._destinationFields.setLayoutData((Object)new GridData(1808));
        this._inverseToOneButton = new Button((Composite)this._destinationFields, 16);
        this._inverseToOneButton.addSelectionListener((SelectionListener)this);
        GridData inverseToOneData = new GridData(768);
        inverseToOneData.horizontalSpan = 2;
        this._inverseToOneButton.setLayoutData((Object)inverseToOneData);
        this._inverseToManyButton = new Button((Composite)this._destinationFields, 16);
        this._inverseToManyButton.addSelectionListener((SelectionListener)this);
        GridData inverseToManyData = new GridData(768);
        inverseToManyData.horizontalSpan = 2;
        this._inverseToManyButton.setLayoutData((Object)inverseToManyData);
        this._createInverseButton = new Button((Composite)this._destinationFields, 32);
        this._createInverseButton.setSelection(true);
        this._createInverseButton.setLayoutData((Object)new GridData());
        this._createInverseButton.addSelectionListener((SelectionListener)this);
        this._inverseNameText = new Text((Composite)this._destinationFields, 2048);
        GridData inverseNameData = new GridData(768);
        inverseNameData.widthHint = 200;
        this._inverseNameText.setLayoutData((Object)inverseNameData);
        this._createInverseFKButton = new Button((Composite)this._destinationFields, 32);
        this._createInverseFKButton.setSelection(true);
        this._createInverseFKButton.setLayoutData((Object)new GridData());
        this._createInverseFKButton.addSelectionListener((SelectionListener)this);
        this._inverseFKNameText = new Text((Composite)this._destinationFields, 2048);
        this._inverseFKNameText.setEnabled(false);
        GridData inverseFKNameData = new GridData(768);
        inverseFKNameData.widthHint = 200;
        this._inverseFKNameText.setLayoutData((Object)inverseFKNameData);
        this._inverseFKColumnNameLabel = new Label((Composite)this._destinationFields, 0);
        this._inverseFKColumnNameLabel.setText("and a new foreign key column named");
        GridData inverseColumnNameData = new GridData();
        inverseColumnNameData.horizontalIndent = 20;
        this._inverseFKColumnNameLabel.setLayoutData((Object)inverseColumnNameData);
        this._inverseFKColumnNameText = new Text((Composite)this._destinationFields, 2048);
        this._inverseFKColumnNameText.setEnabled(false);
        GridData inverseFKColumnNameData = new GridData(768);
        inverseFKColumnNameData.widthHint = 200;
        this._inverseFKColumnNameText.setLayoutData((Object)inverseFKColumnNameData);
        this._joinsLabel = new Label(relationshipDialogArea, 0);
        this._joinsLabel.setFont(this._titleFont);
        this._joinsLabel.setText("Joins");
        GridData joinsLabelData = new GridData(768);
        joinsLabelData.horizontalSpan = 2;
        joinsLabelData.verticalIndent = 15;
        this._joinsLabel.setLayoutData((Object)joinsLabelData);
        this._joinsFields = new Group(relationshipDialogArea, 0);
        GridLayout joinEntityFieldsLayout = new GridLayout(2, false);
        joinEntityFieldsLayout.horizontalSpacing = 15;
        this._joinsFields.setLayout((Layout)joinEntityFieldsLayout);
        GridData joinEntityFieldsLayoutData = new GridData(1808);
        joinEntityFieldsLayoutData.horizontalSpan = 2;
        this._joinsFields.setLayoutData((Object)joinEntityFieldsLayoutData);
        this._joinEntityNameLabel = new Label(this._joinsFields, 0);
        this._joinEntityNameLabel.setText(Messages.getString("CreateRelationshipDialog.joinEntityNameLabel"));
        GridData joinEntityNameLabelData = new GridData();
        this._joinEntityNameLabel.setLayoutData((Object)joinEntityNameLabelData);
        this._joinEntityNameText = new Text(this._joinsFields, 2048);
        GridData joinEntityNameData = new GridData(768);
        joinEntityNameData.widthHint = 200;
        this._joinEntityNameText.setLayoutData((Object)joinEntityNameData);
        this._flattenButton = new Button(this._joinsFields, 32);
        this._flattenButton.addSelectionListener((SelectionListener)this);
        this._flattenButton.setText(Messages.getString("CreateRelationshipDialog.flattenLabel"));
        this._flattenButton.setSelection(true);
        GridData flattenData = new GridData(768);
        flattenData.horizontalSpan = 2;
        this._flattenButton.setLayoutData((Object)flattenData);
        this._joinsTableEditor = new JoinsTableEditor(this._joinsFields, 0);
        GridData joinsGridData = new GridData(768);
        joinsGridData.horizontalSpan = 2;
        this._joinsTableEditor.setLayoutData(joinsGridData);
        this.entitiesChanged();
        this._inverseFKNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newInverseFKName = ((Text)e.widget).getText();
                if (CreateRelationshipDialog.this._destinationEntity != null) {
                    String newInverseFKColumnName = CreateRelationshipDialog.this._destinationEntity.getModel().getAttributeNamingConvention().format(newInverseFKName);
                    CreateRelationshipDialog.this._inverseFKColumnNameText.setText(newInverseFKColumnName);
                    CreateRelationshipDialog.this._oldInverseFKName = newInverseFKName;
                }
            }
        });
        this._fkNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newFKName = ((Text)e.widget).getText();
                String newFKColumnName = CreateRelationshipDialog.this._sourceEntity.getModel().getAttributeNamingConvention().format(newFKName);
                CreateRelationshipDialog.this._fkColumnNameText.setText(newFKColumnName);
                CreateRelationshipDialog.this._oldFKName = newFKName;
            }
        });
        return this._joinsFields;
    }

    protected void setVisible(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).heightHint = visible ? -1 : 0;
    }

    protected void entitiesChanged() {
        boolean relationshipFieldsVisible = this._sourceEntity != null && this._destinationEntity != null;
        this.setVisible((Control)this._sourceLabel, relationshipFieldsVisible);
        this.setVisible((Control)this._sourceFields, relationshipFieldsVisible);
        this.setVisible((Control)this._destinationLabel, relationshipFieldsVisible);
        this.setVisible((Control)this._destinationFields, relationshipFieldsVisible);
        this.setVisible((Control)this._joinsLabel, relationshipFieldsVisible);
        this.setVisible((Control)this._joinsFields, relationshipFieldsVisible);
        if (this._sourceEntity != null) {
            this._sourceLabel.setText("From " + this._sourceEntity.getName() + " ...");
            this._createInverseButton.setText(Messages.getString("CreateRelationshipDialog.inverseNameLabel", new Object[]{this._sourceEntity.getName()}));
            this._createInverseFKButton.setText(Messages.getString("CreateRelationshipDialog.inverseFKNameLabel", new Object[]{this._sourceEntity.getName()}));
            this._inverseToOneButton.setText(Messages.getString("CreateRelationshipDialog.inverseToOneLabel", new Object[]{this._sourceEntity.getName()}));
            this._inverseToManyButton.setText(Messages.getString("CreateRelationshipDialog.inverseToManyLabel", new Object[]{StringUtils.toPlural(this._sourceEntity.getName())}));
        }
        if (this._destinationEntity != null) {
            this._createButton.setText(Messages.getString("CreateRelationshipDialog.nameLabel", new Object[]{this._destinationEntity.getName()}));
            this._createFKButton.setText(Messages.getString("CreateRelationshipDialog.fkNameLabel", new Object[]{this._destinationEntity.getName()}));
            this._toOneButton.setText(Messages.getString("CreateRelationshipDialog.toOneLabel", new Object[]{this._destinationEntity.getName()}));
            this._toManyButton.setText(Messages.getString("CreateRelationshipDialog.toManyLabel", new Object[]{StringUtils.toPlural(this._destinationEntity.getName())}));
            this._destinationLabel.setText("From " + this._destinationEntity.getName() + " ...");
            this._guessedJoinEntityName = String.valueOf(this._sourceEntity.getName()) + this._destinationEntity.getName();
            this._joinEntityNameText.setText(this._guessedJoinEntityName);
            this._flattenedChanged();
        }
        if (this._sourceEntity != null && this._destinationEntity != null) {
            this._relationship = this._sourceEntity.createRelationshipTo(this._destinationEntity, false);
            this._joinsTableEditor.setRelationship(this._relationship);
        } else {
            this._relationship = null;
            this._joinsTableEditor.setRelationship(null);
        }
        this.toManyChanged(null);
    }

    protected void okPressed() {
        this.buttonBar.forceFocus();
        try {
            String name = this._nameText.getText();
            String inverseName = this._inverseNameText.getText();
            boolean createRelationship = this._createButton.getSelection();
            boolean createInverseRelationship = this._createInverseButton.getSelection();
            if (this._manyToMany) {
                String joinEntityName = this._joinEntityNameText.getText();
                boolean flatten = this._flattenButton.getSelection();
                NewManyToManyRelationshipOperation operation = new NewManyToManyRelationshipOperation(this._sourceEntity, this._destinationEntity, createRelationship, name, createInverseRelationship, inverseName, joinEntityName, flatten);
                operation.addContext(EOModelUtils.getUndoContext(this._sourceEntity));
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.execute((IUndoableOperation)operation, null, null);
            } else {
                String fkName = null;
                String fkColumnName = null;
                boolean toMany = this._toManyButton.getSelection();
                String inverseFKName = null;
                String inverseFKColumnName = null;
                boolean inverseToMany = this._inverseToManyButton.getSelection();
                if (this._createFK) {
                    fkName = this._fkNameText.getText();
                    fkColumnName = this._fkColumnNameText.getText();
                }
                if (this._createInverseFK) {
                    inverseFKName = this._inverseFKNameText.getText();
                    inverseFKColumnName = this._inverseFKColumnNameText.getText();
                }
                NewOneToManyRelationshipOperation operation = new NewOneToManyRelationshipOperation(this._relationship, this._sourceEntity, name, createRelationship, toMany, this._createFK, fkName, fkColumnName, this._destinationEntity, inverseName, createInverseRelationship, inverseToMany, this._createInverseFK, inverseFKName, inverseFKColumnName);
                operation.addContext(EOModelUtils.getUndoContext(this._sourceEntity));
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.execute((IUndoableOperation)operation, null, null);
            }
            super.okPressed();
        }
        catch (Throwable t) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)t);
        }
    }

    public void toManyChanged(Button selectedButton) {
        if (!this._toManyButton.getSelection() && !this._inverseToManyButton.getSelection()) {
            if (selectedButton == this._inverseToManyButton) {
                this._toOneButton.setSelection(false);
                this._toManyButton.setSelection(true);
            } else {
                this._inverseToOneButton.setSelection(false);
                this._inverseToManyButton.setSelection(true);
            }
        }
        this._checkManyToMany(selectedButton);
        String name = this._nameText.getText();
        if (this._sourceEntity != null && this._destinationEntity != null && (this._originalName == null || ComparisonUtils.equals(name, this._originalName))) {
            String newName = this._sourceEntity._findUnusedRelationshipName(this._destinationEntity.getName(), this._toManyButton.getSelection());
            this._nameText.setText(newName);
            this._originalName = newName;
        }
        String inverseName = this._inverseNameText.getText();
        if (this._sourceEntity != null && this._destinationEntity != null && (this._originalInverseName == null || ComparisonUtils.equals(inverseName, this._originalInverseName))) {
            String newName = this._destinationEntity._findUnusedRelationshipName(this._sourceEntity.getName(), this._inverseToManyButton.getSelection());
            this._inverseNameText.setText(newName);
            this._originalInverseName = newName;
        }
    }

    protected void _checkManyToMany(Button selectedButton) {
        if (!this._createButton.getSelection() && !this._createInverseButton.getSelection()) {
            if (selectedButton == this._createInverseButton) {
                this._createButton.setSelection(true);
            } else {
                this._createInverseButton.setSelection(true);
            }
        }
        if (selectedButton == this._createButton) {
            if (!this._createButton.getSelection()) {
                this._createFKButton.setSelection(false);
            } else {
                this._createFKButton.setSelection(true);
            }
        } else if (selectedButton == this._createInverseButton) {
            if (!this._createInverseButton.getSelection()) {
                this._createInverseFKButton.setSelection(false);
            } else {
                this._createInverseFKButton.setSelection(true);
            }
        }
        this._nameText.setEnabled(this._createButton.getSelection());
        this._inverseNameText.setEnabled(this._createInverseButton.getSelection());
        this._manyToMany = this._toManyButton.getSelection() && this._inverseToManyButton.getSelection();
        this._joinsTableEditor.setEnabled(!this._manyToMany);
        this._flattenButton.setEnabled(this._manyToMany);
        this._joinEntityNameText.setEnabled(this._manyToMany);
        boolean canCreateFK = !this._toManyButton.getSelection();
        this._createFK = canCreateFK && this._createFKButton.getSelection();
        this._createFKButton.setEnabled(canCreateFK);
        this._fkNameText.setEnabled(this._createFK);
        this._fkColumnNameText.setEnabled(this._createFK);
        if (this._createFK) {
            this._fkColumnNameLabel.setForeground(this._fkColumnNameLabel.getDisplay().getSystemColor(2));
        } else {
            this._fkColumnNameLabel.setForeground(this._fkColumnNameLabel.getDisplay().getSystemColor(16));
        }
        boolean canCreateInverseFK = !this._inverseToManyButton.getSelection();
        this._createInverseFK = canCreateInverseFK && this._createInverseFKButton.getSelection();
        this._createInverseFKButton.setEnabled(canCreateInverseFK);
        this._inverseFKNameText.setEnabled(this._createInverseFK);
        this._inverseFKColumnNameText.setEnabled(this._createInverseFK);
        if (this._createInverseFK) {
            this._inverseFKColumnNameLabel.setForeground(this._inverseFKColumnNameLabel.getDisplay().getSystemColor(2));
        } else {
            this._inverseFKColumnNameLabel.setForeground(this._inverseFKColumnNameLabel.getDisplay().getSystemColor(16));
        }
        if (this._sourceEntity != null && this._destinationEntity != null) {
            String inverseFKName;
            String fkName = this._fkNameText.getText();
            if (fkName == null || fkName.length() == 0) {
                String newName = this._sourceEntity.findUnusedAttributeName(String.valueOf(StringUtils.toLowercaseFirstLetter(this._destinationEntity.getName())) + "ID");
                this._fkNameText.setText(newName);
                this._oldFKName = newName;
                this._fkColumnNameText.setText(this._sourceEntity.getModel().getAttributeNamingConvention().format(newName));
            }
            if ((inverseFKName = this._inverseFKNameText.getText()) == null || inverseFKName.length() == 0) {
                String newName = this._destinationEntity.findUnusedAttributeName(String.valueOf(StringUtils.toLowercaseFirstLetter(this._sourceEntity.getName())) + "ID");
                this._inverseFKNameText.setText(newName);
                this._oldInverseFKName = newName;
                this._inverseFKColumnNameText.setText(this._destinationEntity.getModel().getAttributeNamingConvention().format(newName));
            }
        }
        boolean joinsTableVisible = !this._manyToMany && !this._createFK && !this._createInverseFK;
        boolean joinsVisible = this._manyToMany || joinsTableVisible;
        this.setVisible((Control)this._joinsLabel, joinsVisible);
        this.setVisible((Control)this._joinsFields, joinsVisible);
        this.setVisible((Control)this._joinsTableEditor, joinsTableVisible);
        this.setVisible((Control)this._joinEntityNameLabel, this._manyToMany);
        this.setVisible((Control)this._joinEntityNameText, this._manyToMany);
        this.setVisible((Control)this._flattenButton, this._manyToMany);
        if (this.getShell().isVisible()) {
            this.getShell().pack();
        }
    }

    protected void _flattenedChanged() {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        Object source = event.getSource();
        if (source == this._toManyButton) {
            this.toManyChanged(this._toManyButton);
        } else if (source == this._inverseToManyButton) {
            this.toManyChanged(this._inverseToManyButton);
        } else if (source == this._createFKButton) {
            this._checkManyToMany(this._createFKButton);
        } else if (source == this._createInverseFKButton) {
            this._checkManyToMany(this._createInverseFKButton);
        } else if (source == this._createButton) {
            this._checkManyToMany(this._createButton);
        } else if (source == this._createInverseButton) {
            this._checkManyToMany(this._createInverseButton);
        } else if (source == this._flattenButton) {
            this._flattenedChanged();
        }
    }

    public boolean close() {
        boolean results = super.close();
        if (this._titleFont != null) {
            this._titleFont.dispose();
        }
        return results;
    }
}

