/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateFetchSpecNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.editors.entity.EOFetchSpecsContentProvider;
import org.objectstyle.wolips.eomodeler.editors.entity.EOFetchSpecsLabelProvider;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyCellModifier;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyViewerSorter;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EOEntitySharedObjectsEditorSection
extends AbstractPropertySection {
    private EOEntity myEntity;
    private Button myShareNoObjectsButton;
    private Button myShareAllObjectsButton;
    private Button myShareFetchSpecsButton;
    private TableViewer myFetchSpecsViewer;
    private DataBindingContext myBindingContext;
    private PropertyChangeListener myFetchSpecListener = new FetchSpecChangeListener();

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite _parent, TabbedPropertySheetPage _tabbedPropertySheetPage) {
        super.createControls(_parent, _tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createFlatFormComposite(_parent);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form, 1);
        ((GridLayout)topForm.getLayout()).verticalSpacing = 1;
        this.myShareNoObjectsButton = new Button(topForm, 16);
        this.myShareNoObjectsButton.setText(Messages.getString("EOEntity.shareNoObjects"));
        this.myShareNoObjectsButton.addSelectionListener((SelectionListener)new ShareNoObjectsListener());
        this.myShareAllObjectsButton = new Button(topForm, 16);
        this.myShareAllObjectsButton.setText(Messages.getString("EOEntity.shareAllObjects"));
        this.myShareAllObjectsButton.addSelectionListener((SelectionListener)new ShareAllObjectsListener());
        this.myShareFetchSpecsButton = new Button(topForm, 16);
        this.myShareFetchSpecsButton.setText(Messages.getString("EOEntity.shareFetchSpecs"));
        this.myShareFetchSpecsButton.addSelectionListener((SelectionListener)new ShareFetchSpecsListener());
        this.myFetchSpecsViewer = TableUtils.createTableViewer(topForm, 8456194, "EOFetchSpecification", EOFetchSpecification.class.getName(), (IStructuredContentProvider)new EOFetchSpecsContentProvider(), (ITableLabelProvider)new EOFetchSpecsLabelProvider(EOFetchSpecification.class.getName()), (ViewerSorter)new TablePropertyViewerSorter(EOFetchSpecification.class.getName()));
        TableColumn nameColumn = TableUtils.getColumn(this.myFetchSpecsViewer, EOFetchSpecification.class.getName(), "sharesObjects");
        if (nameColumn != null) {
            nameColumn.setText("");
            nameColumn.setImage(Activator.getDefault().getImageRegistry().get("check"));
        }
        CellEditor[] cellEditors = new CellEditor[1];
        TableUtils.setCellEditor(EOFetchSpecification.class.getName(), "sharesObjects", (CellEditor)new CheckboxCellEditor((Composite)this.myFetchSpecsViewer.getTable()), cellEditors);
        this.myFetchSpecsViewer.setCellModifier((ICellModifier)new TablePropertyCellModifier(this.myFetchSpecsViewer));
        this.myFetchSpecsViewer.setCellEditors(cellEditors);
        GridData fetchSpecsLayoutData = new GridData(1808);
        fetchSpecsLayoutData.verticalIndent = 10;
        this.myFetchSpecsViewer.getTable().setLayoutData((Object)fetchSpecsLayoutData);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals(selection, this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        this.disposeBindings();
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        this.myEntity = (EOEntity)selectedObject;
        if (this.myEntity != null) {
            this.myBindingContext = new DataBindingContext();
            this.myEntity.addPropertyChangeListener("fetchSpecification", this.myFetchSpecListener);
            this.myEntity.addPropertyChangeListener("fetchSpecifications", this.myFetchSpecListener);
            this.myFetchSpecsViewer.setInput((Object)this.myEntity);
            this.fetchSpecsChanged();
        }
    }

    protected void disposeBindings() {
        if (this.myBindingContext != null) {
            this.myBindingContext.dispose();
        }
        if (this.myEntity != null) {
            this.myEntity.removePropertyChangeListener("fetchSpecification", this.myFetchSpecListener);
            this.myEntity.removePropertyChangeListener("fetchSpecifications", this.myFetchSpecListener);
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    public EOEntity getEntity() {
        return this.myEntity;
    }

    protected void fetchSpecsChanged() {
        this.myFetchSpecsViewer.refresh();
        this.shareTypeChanged(false);
    }

    protected void fetchSpecChanged(EOFetchSpecification _fetchSpec) {
        this.myFetchSpecsViewer.refresh((Object)_fetchSpec);
        this.shareTypeChanged(false);
    }

    protected void shareTypeChanged(boolean _selectedShareFetchSpecs) {
        if (!_selectedShareFetchSpecs && !this.myEntity.hasSharedObjects()) {
            if (!this.myShareNoObjectsButton.getSelection()) {
                this.myShareNoObjectsButton.setSelection(true);
            }
            this.myShareAllObjectsButton.setSelection(false);
            this.myShareFetchSpecsButton.setSelection(false);
            this.myFetchSpecsViewer.getTable().setEnabled(false);
        } else if (!_selectedShareFetchSpecs && this.myEntity.isSharesAllObjectsOnly()) {
            if (!this.myShareAllObjectsButton.getSelection()) {
                this.myShareAllObjectsButton.setSelection(true);
            }
            this.myShareNoObjectsButton.setSelection(false);
            this.myShareFetchSpecsButton.setSelection(false);
            this.myFetchSpecsViewer.getTable().setEnabled(false);
        } else {
            if (!this.myShareFetchSpecsButton.getSelection()) {
                this.myShareFetchSpecsButton.setSelection(true);
            }
            this.myShareNoObjectsButton.setSelection(false);
            this.myShareAllObjectsButton.setSelection(false);
            this.myFetchSpecsViewer.getTable().setEnabled(true);
        }
        TableUtils.packTableColumns(this.myFetchSpecsViewer);
    }

    protected class FetchSpecChangeListener
    implements PropertyChangeListener {
        protected FetchSpecChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent _event) {
            String propertyName = _event.getPropertyName();
            if ("fetchSpecification" == propertyName) {
                EOFetchSpecification fetchSpec = (EOFetchSpecification)_event.getNewValue();
                EOEntitySharedObjectsEditorSection.this.fetchSpecChanged(fetchSpec);
            } else if ("fetchSpecifications" == propertyName) {
                EOEntitySharedObjectsEditorSection.this.fetchSpecsChanged();
            }
        }
    }

    protected class ShareAllObjectsListener
    implements SelectionListener {
        protected ShareAllObjectsListener() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            try {
                EOEntitySharedObjectsEditorSection.this.getEntity().shareAllObjects();
            }
            catch (DuplicateFetchSpecNameException e) {
                ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
            }
        }
    }

    protected class ShareFetchSpecsListener
    implements SelectionListener {
        protected ShareFetchSpecsListener() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            if (((Button)_e.getSource()).getSelection()) {
                EOEntitySharedObjectsEditorSection.this.shareTypeChanged(true);
            }
        }
    }

    protected class ShareNoObjectsListener
    implements SelectionListener {
        protected ShareNoObjectsListener() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            EOEntitySharedObjectsEditorSection.this.getEntity().shareNoObjects();
        }
    }
}

