/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.fetchspec;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.EOPrefetchingKeyPathsConstants;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.PrefetchingKeyPathsContentProvider;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.PrefetchingKeyPathsLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.PrefetchingKeyPathsViewerSorter;
import org.objectstyle.wolips.eomodeler.outline.EOEntityTreeViewUpdater;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineContentProvider;
import org.objectstyle.wolips.eomodeler.utils.AddRemoveButtonGroup;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.TableRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EOFetchSpecPrefetchingEditorSection
extends AbstractPropertySection
implements ISelectionChangedListener {
    private EOFetchSpecification myFetchSpecification;
    private TreeViewer myModelTreeViewer;
    private TableViewer myPrefetchKeyPathsTableViewer;
    private AddRemoveButtonGroup myAddRemoveButtonGroup;
    private EOEntityTreeViewUpdater myEntityTreeViewUpdater;
    private TableRefreshPropertyListener myPrefetchKeyPathsChangedRefresher;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite _parent, TabbedPropertySheetPage _tabbedPropertySheetPage) {
        super.createControls(_parent, _tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createPlainComposite(_parent, 0);
        FormLayout formLayout = new FormLayout();
        form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form, 1);
        this.myModelTreeViewer = new TreeViewer(topForm);
        GridData modelTreeLayoutData = new GridData(1808);
        modelTreeLayoutData.heightHint = 100;
        this.myModelTreeViewer.getTree().setLayoutData((Object)modelTreeLayoutData);
        this.myEntityTreeViewUpdater = new EOEntityTreeViewUpdater(this.myModelTreeViewer, new EOModelOutlineContentProvider(true, false, true, false, false, false, false, true));
        this.myModelTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.myPrefetchKeyPathsTableViewer = TableUtils.createTableViewer(topForm, "EOFetchSpecification", EOPrefetchingKeyPathsConstants.COLUMNS, (IStructuredContentProvider)new PrefetchingKeyPathsContentProvider(), (ITableLabelProvider)new PrefetchingKeyPathsLabelProvider(EOPrefetchingKeyPathsConstants.COLUMNS), (ViewerSorter)new PrefetchingKeyPathsViewerSorter(EOPrefetchingKeyPathsConstants.COLUMNS));
        GridData prefetchKeyPathsTableLayoutData = new GridData(1808);
        prefetchKeyPathsTableLayoutData.heightHint = 100;
        this.myPrefetchKeyPathsTableViewer.getTable().setLayoutData((Object)prefetchKeyPathsTableLayoutData);
        this.myPrefetchKeyPathsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.myPrefetchKeyPathsChangedRefresher = new TableRefreshPropertyListener("PrefetchKeyPathsChanged", this.myPrefetchKeyPathsTableViewer);
        this.myAddRemoveButtonGroup = new AddRemoveButtonGroup(topForm, new AddPrefetchKeyPathHandler(), new RemovePrefetchKeyPathHandler());
        this.myAddRemoveButtonGroup.setLayoutData(new GridData(768));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals(selection, this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        this.disposeBindings();
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        this.myFetchSpecification = (EOFetchSpecification)selectedObject;
        if (this.myFetchSpecification != null) {
            this.myFetchSpecification.addPropertyChangeListener("prefetchingRelationshipKeyPaths", this.myPrefetchKeyPathsChangedRefresher);
            this.myEntityTreeViewUpdater.setEntity(this.myFetchSpecification.getEntity());
            this.myPrefetchKeyPathsTableViewer.setInput((Object)this.myFetchSpecification);
            TableUtils.packTableColumns(this.myPrefetchKeyPathsTableViewer);
            this.updateButtonsEnabled();
        }
    }

    protected void disposeBindings() {
        if (this.myFetchSpecification != null) {
            this.myFetchSpecification.removePropertyChangeListener("prefetchingRelationshipKeyPaths", this.myPrefetchKeyPathsChangedRefresher);
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    public void addPrefetchKeyPath() {
        IStructuredSelection selection = (IStructuredSelection)this.myModelTreeViewer.getSelection();
        Object selectedObject = selection.getFirstElement();
        String path = selectedObject instanceof EORelationshipPath ? ((EORelationshipPath)selectedObject).toKeyPath() : (selectedObject instanceof EORelationship ? ((EORelationship)selectedObject).getName() : null);
        if (path != null) {
            this.myFetchSpecification.addPrefetchingRelationshipKeyPath(path, true);
            TableUtils.packTableColumns(this.myPrefetchKeyPathsTableViewer);
        }
    }

    public void removePrefetchKeyPath() {
        IStructuredSelection selection = (IStructuredSelection)this.myPrefetchKeyPathsTableViewer.getSelection();
        for (String prefetchKeyPath : selection.toList()) {
            this.myFetchSpecification.removePrefetchingRelationshipKeyPath(prefetchKeyPath, true);
        }
    }

    public void updateButtonsEnabled() {
        this.myAddRemoveButtonGroup.setAddEnabled(!this.myModelTreeViewer.getSelection().isEmpty());
        this.myAddRemoveButtonGroup.setRemoveEnabled(!this.myPrefetchKeyPathsTableViewer.getSelection().isEmpty());
    }

    public void selectionChanged(SelectionChangedEvent _event) {
        this.updateButtonsEnabled();
    }

    protected class AddPrefetchKeyPathHandler
    implements SelectionListener {
        protected AddPrefetchKeyPathHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            EOFetchSpecPrefetchingEditorSection.this.addPrefetchKeyPath();
        }
    }

    protected class RemovePrefetchKeyPathHandler
    implements SelectionListener {
        protected RemovePrefetchKeyPathHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            EOFetchSpecPrefetchingEditorSection.this.removePrefetchKeyPath();
        }
    }
}

