/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.fetchspec;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.EORawRowKeyPathsConstants;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.RawRowKeyPathsContentProvider;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.RawRowKeyPathsLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.fetchspec.RawRowKeyPathsViewerSorter;
import org.objectstyle.wolips.eomodeler.outline.EOEntityTreeViewUpdater;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineContentProvider;
import org.objectstyle.wolips.eomodeler.utils.AddRemoveButtonGroup;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.TableRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EOFetchSpecRawFetchEditorSection
extends AbstractPropertySection
implements ISelectionChangedListener,
SelectionListener {
    private EOFetchSpecification myFetchSpecification;
    private TreeViewer myModelTreeViewer;
    private TableViewer myRawRowKeyPathsTableViewer;
    private AddRemoveButtonGroup myAddRemoveButtonGroup;
    private EOEntityTreeViewUpdater myEntityTreeViewUpdater;
    private TableRefreshPropertyListener myRawRowKeyPathsChangedRefresher;
    private Button myFetchEnterpriseObjectsButton;
    private Button myFetchAllAttributesAsRawRowsButton;
    private Button myFetchSpecificAttributesAsRawRowsButton;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite _parent, TabbedPropertySheetPage _tabbedPropertySheetPage) {
        super.createControls(_parent, _tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createPlainComposite(_parent, 0);
        FormLayout formLayout = new FormLayout();
        form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form, 1);
        Composite fetchStyleComposite = this.getWidgetFactory().createPlainComposite(topForm, 0);
        GridLayout fetchStyleLayout = new GridLayout();
        fetchStyleComposite.setLayout((Layout)fetchStyleLayout);
        this.myFetchEnterpriseObjectsButton = new Button(fetchStyleComposite, 16);
        this.myFetchEnterpriseObjectsButton.setText(Messages.getString("EOFetchSpecRawFetchEditorSection.fetchEnterpriseObjects"));
        this.myFetchAllAttributesAsRawRowsButton = new Button(fetchStyleComposite, 16);
        this.myFetchAllAttributesAsRawRowsButton.setText(Messages.getString("EOFetchSpecRawFetchEditorSection.fetchAllAttributes"));
        this.myFetchSpecificAttributesAsRawRowsButton = new Button(fetchStyleComposite, 16);
        this.myFetchSpecificAttributesAsRawRowsButton.setText(Messages.getString("EOFetchSpecRawFetchEditorSection.fetchSpecificAttributes"));
        this.myModelTreeViewer = new TreeViewer(topForm);
        GridData modelTreeLayoutData = new GridData(768);
        modelTreeLayoutData.heightHint = 100;
        this.myModelTreeViewer.getTree().setLayoutData((Object)modelTreeLayoutData);
        this.myEntityTreeViewUpdater = new EOEntityTreeViewUpdater(this.myModelTreeViewer, new EOModelOutlineContentProvider(true, true, true, false, false, false, false, true));
        this.myModelTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.myRawRowKeyPathsTableViewer = TableUtils.createTableViewer(topForm, "EOFetchSpecification", EORawRowKeyPathsConstants.COLUMNS, (IStructuredContentProvider)new RawRowKeyPathsContentProvider(), (ITableLabelProvider)new RawRowKeyPathsLabelProvider(EORawRowKeyPathsConstants.COLUMNS), (ViewerSorter)new RawRowKeyPathsViewerSorter(EORawRowKeyPathsConstants.COLUMNS));
        GridData rawRowKeyPathsTableLayoutData = new GridData(1808);
        rawRowKeyPathsTableLayoutData.heightHint = 100;
        this.myRawRowKeyPathsTableViewer.getTable().setLayoutData((Object)rawRowKeyPathsTableLayoutData);
        this.myRawRowKeyPathsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.myRawRowKeyPathsChangedRefresher = new TableRefreshPropertyListener("RawRowKeyPathsChanged", this.myRawRowKeyPathsTableViewer);
        this.myAddRemoveButtonGroup = new AddRemoveButtonGroup(topForm, new AddRawRowKeyPathHandler(), new RemoveRawRowKeyPathHandler());
        this.myAddRemoveButtonGroup.setLayoutData(new GridData(768));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals(selection, this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        this.disposeBindings();
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        this.myFetchSpecification = (EOFetchSpecification)selectedObject;
        if (this.myFetchSpecification != null) {
            this.myFetchSpecification.addPropertyChangeListener("rawRowKeyPaths", this.myRawRowKeyPathsChangedRefresher);
            this.myEntityTreeViewUpdater.setEntity(this.myFetchSpecification.getEntity());
            this.myRawRowKeyPathsTableViewer.setInput((Object)this.myFetchSpecification);
            TableUtils.packTableColumns(this.myRawRowKeyPathsTableViewer);
            this.updateButtonsEnabled();
        }
    }

    protected void disposeBindings() {
        if (this.myFetchSpecification != null) {
            this.myFetchSpecification.removePropertyChangeListener("rawRowKeyPaths", this.myRawRowKeyPathsChangedRefresher);
        }
    }

    protected void removeButtonListeners() {
        this.myFetchEnterpriseObjectsButton.removeSelectionListener((SelectionListener)this);
        this.myFetchAllAttributesAsRawRowsButton.removeSelectionListener((SelectionListener)this);
        this.myFetchSpecificAttributesAsRawRowsButton.removeSelectionListener((SelectionListener)this);
    }

    protected void addButtonListeners() {
        this.myFetchEnterpriseObjectsButton.addSelectionListener((SelectionListener)this);
        this.myFetchAllAttributesAsRawRowsButton.addSelectionListener((SelectionListener)this);
        this.myFetchSpecificAttributesAsRawRowsButton.addSelectionListener((SelectionListener)this);
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    public void widgetDefaultSelected(SelectionEvent _e) {
        this.widgetSelected(_e);
    }

    public void widgetSelected(SelectionEvent _e) {
        Object source = _e.getSource();
        if (source == this.myFetchEnterpriseObjectsButton) {
            this.myFetchSpecification.fetchEnterpriseObjects();
        } else if (source == this.myFetchAllAttributesAsRawRowsButton) {
            this.myFetchSpecification.fetchAllAttributesAsRawRows();
        } else if (source == this.myFetchSpecificAttributesAsRawRowsButton) {
            this.myFetchSpecification.fetchSpecificAttributesAsRawRows();
        }
        this.updateButtonsEnabled();
    }

    public void addRawRowKeyPath() {
        IStructuredSelection selection = (IStructuredSelection)this.myModelTreeViewer.getSelection();
        Object selectedObject = selection.getFirstElement();
        String path = selectedObject instanceof EOAttributePath ? ((EOAttributePath)selectedObject).toKeyPath() : (selectedObject instanceof EOAttribute ? ((EOAttribute)selectedObject).getName() : null);
        if (path != null) {
            this.myFetchSpecification.addRawRowKeyPath(path, true);
            TableUtils.packTableColumns(this.myRawRowKeyPathsTableViewer);
            this.updateButtonsEnabled();
        }
    }

    public void removePrefetchKeyPath() {
        IStructuredSelection selection = (IStructuredSelection)this.myRawRowKeyPathsTableViewer.getSelection();
        for (String rawRowKeyPath : selection.toList()) {
            this.myFetchSpecification.removeRawRowKeyPath(rawRowKeyPath, true);
        }
        this.updateButtonsEnabled();
    }

    public void updateButtonsEnabled() {
        this.removeButtonListeners();
        if (this.myFetchSpecification.isFetchEnterpriseObjects()) {
            this.myFetchEnterpriseObjectsButton.setSelection(true);
            this.myFetchAllAttributesAsRawRowsButton.setSelection(false);
            this.myFetchSpecificAttributesAsRawRowsButton.setSelection(false);
        } else if (this.myFetchSpecification.isFetchAllAttributesAsRawRows()) {
            this.myFetchEnterpriseObjectsButton.setSelection(false);
            this.myFetchAllAttributesAsRawRowsButton.setSelection(true);
            this.myFetchSpecificAttributesAsRawRowsButton.setSelection(false);
        } else {
            this.myFetchEnterpriseObjectsButton.setSelection(false);
            this.myFetchAllAttributesAsRawRowsButton.setSelection(false);
            this.myFetchSpecificAttributesAsRawRowsButton.setSelection(true);
        }
        this.addButtonListeners();
        boolean enabled = this.myFetchSpecification.isFetchSpecificAttributesAsRawRows();
        Object selectedObject = ((IStructuredSelection)this.myModelTreeViewer.getSelection()).getFirstElement();
        boolean addEnabled = selectedObject instanceof EOAttributePath || selectedObject instanceof EOAttribute;
        this.myModelTreeViewer.getTree().setEnabled(enabled);
        this.myAddRemoveButtonGroup.setAddEnabled(enabled && addEnabled);
        this.myAddRemoveButtonGroup.setRemoveEnabled(enabled && !this.myRawRowKeyPathsTableViewer.getSelection().isEmpty());
    }

    public void selectionChanged(SelectionChangedEvent _event) {
        this.updateButtonsEnabled();
    }

    protected class AddRawRowKeyPathHandler
    implements SelectionListener {
        protected AddRawRowKeyPathHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            EOFetchSpecRawFetchEditorSection.this.addRawRowKeyPath();
        }
    }

    protected class RemoveRawRowKeyPathHandler
    implements SelectionListener {
        protected RemoveRawRowKeyPathHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            EOFetchSpecRawFetchEditorSection.this.removePrefetchKeyPath();
        }
    }
}

