/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.factories;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOClassLoader;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.factories.IDEAProjectEOModelGroupFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEAProjectEOClassLoaderFactory
extends AbstractEOClassLoader {
    @Override
    protected void fillInDevelopmentClasspath(Set<URL> classpathUrls) throws Exception {
    }

    @Override
    protected void fillInModelClasspath(EOModel model, Set<URL> classpathUrls) throws Exception {
        LinkedHashSet<File> ideaProjectFiles = new LinkedHashSet<File>();
        try {
            File modelFolder = URLUtils.cheatAndTurnIntoFile(model.getModelURL()).getParentFile();
            IDEAProjectEOModelGroupFactory.findIdeaProjectFilesInFolder(modelFolder, ideaProjectFiles);
        }
        catch (PropertyListParserException e) {
            e.printStackTrace();
            throw new IOException("Failed to parse '.EntityModeler.plist'. " + StringUtils.getErrorMessage(e));
        }
        System.out.println("IDEAProjectEOClassLoaderFactory.fillInModelClasspath: " + ideaProjectFiles);
        if (!ideaProjectFiles.isEmpty()) {
            for (File ideaProjectFile : ideaProjectFiles) {
                System.out.println("IDEAProjectEOClassLoaderFactory.fillInModelClasspath: Project = " + ideaProjectFile);
                String ideaProjectPath = ideaProjectFile.getParentFile().getAbsolutePath();
                try {
                    XPathExpression ideaLibrariesExpression = XPathFactory.newInstance().newXPath().compile("project/component[@name='libraryTable']/library");
                    XPathExpression ideaClassesRootExpression = XPathFactory.newInstance().newXPath().compile("CLASSES/root");
                    Document ideaProjectDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ideaProjectFile);
                    NodeList ideaLibraryNodes = (NodeList)ideaLibrariesExpression.evaluate(ideaProjectDocument, XPathConstants.NODESET);
                    int ideaLibraryNum = 0;
                    while (ideaLibraryNum < ideaLibraryNodes.getLength()) {
                        Element ideaLibraryElement = (Element)ideaLibraryNodes.item(ideaLibraryNum);
                        NodeList rootNodes = (NodeList)ideaClassesRootExpression.evaluate(ideaLibraryElement, XPathConstants.NODESET);
                        int rootNodeNum = 0;
                        while (rootNodeNum < rootNodes.getLength()) {
                            URL rootUrl;
                            Element rootNodeElement = (Element)rootNodes.item(rootNodeNum);
                            String rootUrlStr = rootNodeElement.getAttribute("url");
                            System.out.println("IDEAProjectEOClassLoaderFactory.fillInModelClasspath: " + rootUrlStr);
                            rootUrlStr = rootUrlStr.replaceAll("\\$PROJECT_DIR\\$", ideaProjectPath);
                            if (rootUrlStr.startsWith("jar://")) {
                                rootUrlStr = rootUrlStr.replaceFirst("^jar://", "");
                                rootUrlStr = rootUrlStr.replaceFirst("!/$", "");
                                rootUrl = new File(rootUrlStr).getCanonicalFile().toURL();
                            } else {
                                rootUrl = new URL(rootUrlStr);
                            }
                            System.out.println("IDEAProjectEOClassLoaderFactory.fillInModelClasspath:   " + rootUrl);
                            classpathUrls.add(rootUrl);
                            ++rootNodeNum;
                        }
                        ++ideaLibraryNum;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

