/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.factories;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.model.AbstractManifestEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.core.model.ManifestSearchFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEAProjectEOModelGroupFactory
extends AbstractManifestEOModelGroupFactory {
    @Override
    public List<ManifestSearchFolder> getSearchFolders(File selectedModelFolder) throws IOException {
        LinkedHashSet<ManifestSearchFolder> searchFolders = null;
        LinkedHashSet<File> ideaProjectFiles = new LinkedHashSet<File>();
        try {
            IDEAProjectEOModelGroupFactory.findIdeaProjectFilesInFolder(selectedModelFolder, ideaProjectFiles);
        }
        catch (PropertyListParserException e) {
            e.printStackTrace();
            throw new IOException("Failed to parse '.EntityModeler.plist'. " + StringUtils.getErrorMessage(e));
        }
        if (!ideaProjectFiles.isEmpty()) {
            searchFolders = new LinkedHashSet<ManifestSearchFolder>();
            for (File ideaProjectFile : ideaProjectFiles) {
                HashMap<String, File> ideaLibraries = new HashMap<String, File>();
                String ideaProjectPath = ideaProjectFile.getParentFile().getAbsolutePath();
                HashSet<File> visitedModulePaths = new HashSet<File>();
                try {
                    XPathExpression ideaLibrariesExpression = XPathFactory.newInstance().newXPath().compile("project/component[@name='libraryTable']/library");
                    XPathExpression ideaModulesExpression = XPathFactory.newInstance().newXPath().compile("project/component[@name='ProjectModuleManager']/modules/module");
                    XPathExpression ideaClassesRootExpression = XPathFactory.newInstance().newXPath().compile("CLASSES/root");
                    Document ideaProjectDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ideaProjectFile);
                    NodeList ideaLibraryNodes = (NodeList)ideaLibrariesExpression.evaluate(ideaProjectDocument, XPathConstants.NODESET);
                    int ideaLibraryNum = 0;
                    while (ideaLibraryNum < ideaLibraryNodes.getLength()) {
                        Element ideaLibraryElement = (Element)ideaLibraryNodes.item(ideaLibraryNum);
                        String libraryName = ideaLibraryElement.getAttribute("name");
                        NodeList rootNodes = (NodeList)ideaClassesRootExpression.evaluate(ideaLibraryElement, XPathConstants.NODESET);
                        int rootNodeNum = 0;
                        while (rootNodeNum < rootNodes.getLength()) {
                            Element rootNodeElement = (Element)rootNodes.item(rootNodeNum);
                            String rootPath = rootNodeElement.getAttribute("url");
                            if (rootPath.contains(".framework/Resources")) {
                                rootPath = rootPath.replaceAll("^[^:]+://", "");
                                rootPath = rootPath.replaceAll("\\$PROJECT_DIR\\$", ideaProjectPath);
                                rootPath = rootPath.replaceAll("(.*\\.framework/Resources).*", "$1");
                                ideaLibraries.put(libraryName, new File(rootPath).getCanonicalFile());
                                break;
                            }
                            ++rootNodeNum;
                        }
                        ++ideaLibraryNum;
                    }
                    NodeList ideaModuleNodes = (NodeList)ideaModulesExpression.evaluate(ideaProjectDocument, XPathConstants.NODESET);
                    int ideaModuleNum = 0;
                    while (ideaModuleNum < ideaModuleNodes.getLength()) {
                        Element ideaModuleElement = (Element)ideaModuleNodes.item(ideaModuleNum);
                        String ideaModulePath = ideaModuleElement.getAttribute("filepath");
                        ideaModulePath = ideaModulePath.replaceAll("\\$PROJECT_DIR\\$", ideaProjectPath);
                        File ideaModuleFile = new File(ideaModulePath).getCanonicalFile();
                        this.processIdeaModuleFile(ideaModuleFile, searchFolders, ideaLibraries, visitedModulePaths);
                        ++ideaModuleNum;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return searchFolders == null ? null : new LinkedList(searchFolders);
    }

    protected void processIdeaModuleFile(File ideaModuleFile, Set<ManifestSearchFolder> searchFolders, Map<String, File> ideaLibraries, Set<File> visitedModulePaths) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        if (!ideaModuleFile.exists()) {
            return;
        }
        if (visitedModulePaths.contains(ideaModuleFile)) {
            return;
        }
        visitedModulePaths.add(ideaModuleFile);
        String ideaProjectPath = ideaModuleFile.getParentFile().getAbsolutePath();
        Document ideaModuleDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ideaModuleFile);
        XPathExpression sourceFoldersExpression = XPathFactory.newInstance().newXPath().compile("//module/component/content");
        NodeList contentNodes = (NodeList)sourceFoldersExpression.evaluate(ideaModuleDocument, XPathConstants.NODESET);
        int contentNum = 0;
        while (contentNum < contentNodes.getLength()) {
            Element contentElement = (Element)contentNodes.item(contentNum);
            String contentPath = contentElement.getAttribute("url");
            contentPath = contentPath.replaceAll("^file://", "");
            File contentFolder = new File(contentPath = contentPath.replaceAll("\\$MODULE_DIR\\$", ideaProjectPath)).getCanonicalFile();
            File resourcesFolder = new File(contentFolder, "Resources");
            if (resourcesFolder.exists()) {
                searchFolders.add(new ManifestSearchFolder(resourcesFolder));
            }
            ++contentNum;
        }
        XPathExpression ideaModulesExpression = XPathFactory.newInstance().newXPath().compile("//module/component/orderEntry");
        NodeList ideaModuleNodes = (NodeList)ideaModulesExpression.evaluate(ideaModuleDocument, XPathConstants.NODESET);
        int ideaModuleNum = 0;
        while (ideaModuleNum < ideaModuleNodes.getLength()) {
            String ideaLibraryName;
            File ideaLibraryFolder;
            Element ideaModuleElement = (Element)ideaModuleNodes.item(ideaModuleNum);
            String ideaModuleType = ideaModuleElement.getAttribute("type");
            if ("module".equals(ideaModuleType)) {
                String ideaModuleName = ideaModuleElement.getAttribute("module-name");
                File dependentModuleFile = new File(ideaModuleFile.getParentFile(), String.valueOf(ideaModuleName) + ".iml").getCanonicalFile();
                this.processIdeaModuleFile(dependentModuleFile, searchFolders, ideaLibraries, visitedModulePaths);
            } else if ("library".equals(ideaModuleType) && (ideaLibraryFolder = ideaLibraries.get(ideaLibraryName = ideaModuleElement.getAttribute("name"))) != null) {
                searchFolders.add(new ManifestSearchFolder(ideaLibraryFolder));
            }
            ++ideaModuleNum;
        }
    }

    public static void findIdeaProjectFilesInFolder(File folder, Set<File> ideaProjectFiles) throws IOException, PropertyListParserException {
        if (folder != null) {
            boolean foundProjectFiles = false;
            if (folder.isDirectory()) {
                File projectLocator = new File(folder, ".EntityModeler.plist");
                if (projectLocator.exists()) {
                    List projectFilePaths;
                    Map projectProperties = (Map)WOLPropertyListSerialization.propertyListWithContentsOfFile(projectLocator.getCanonicalPath(), new SimpleParserDataStructureFactory());
                    Map dependencies = (Map)projectProperties.get("Dependencies");
                    if (dependencies != null && (projectFilePaths = (List)dependencies.get("IDEA")) != null) {
                        for (String projectFilePath : projectFilePaths) {
                            File projectFile = new File(projectFilePath);
                            if (!projectFile.exists()) {
                                projectFile = new File(folder, projectFilePath);
                            }
                            if (!projectFile.exists() || !IDEAProjectEOModelGroupFactory.isIdeaProjectFile(projectFile = projectFile.getCanonicalFile())) continue;
                            ideaProjectFiles.add(projectFile.getCanonicalFile());
                            foundProjectFiles = true;
                        }
                    }
                } else {
                    File[] files = folder.listFiles();
                    if (files != null) {
                        File[] fileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            if (IDEAProjectEOModelGroupFactory.isIdeaProjectFile(file)) {
                                ideaProjectFiles.add(file.getCanonicalFile());
                                foundProjectFiles = true;
                            }
                            ++n2;
                        }
                    }
                }
            }
            if (!foundProjectFiles) {
                File parentFolder = folder.getParentFile();
                IDEAProjectEOModelGroupFactory.findIdeaProjectFilesInFolder(parentFolder, ideaProjectFiles);
            }
        }
    }

    public static boolean isIdeaProjectFile(File file) {
        return file.getName().endsWith(".ipr");
    }
}

