/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.factories;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.objectstyle.wolips.eomodeler.core.model.AbstractManifestEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.core.model.ManifestSearchFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleManifestEOModelGroupFactory
extends AbstractManifestEOModelGroupFactory {
    @Override
    public List<ManifestSearchFolder> getSearchFolders(File selectedModelFolder) throws IOException {
        LinkedList<ManifestSearchFolder> searchFolders = new LinkedList<ManifestSearchFolder>();
        this.fillInSearchFolders(new File(selectedModelFolder, "EntityModeler.modelpath"), searchFolders);
        this.fillInSearchFolders(new File(selectedModelFolder, ".EntityModeler.modelpath"), searchFolders);
        if (selectedModelFolder != null) {
            this.fillInSearchFolders(new File(selectedModelFolder.getParentFile(), "EntityModeler.modelpath"), searchFolders);
            this.fillInSearchFolders(new File(selectedModelFolder.getParentFile(), ".EntityModeler.modelpath"), searchFolders);
        }
        this.fillInSearchFolders(new File(System.getProperty("user.home"), "EntityModeler.modelpath"), searchFolders);
        this.fillInSearchFolders(new File(System.getProperty("user.home"), ".EntityModeler.modelpath"), searchFolders);
        this.fillInSearchFolders(new File(String.valueOf(System.getProperty("user.home")) + "/Library", "EntityModeler.modelpath"), searchFolders);
        this.fillInSearchFolders(new File(String.valueOf(System.getProperty("user.home")) + "/Library", ".EntityModeler.modelpath"), searchFolders);
        this.fillInSearchFolders(new File(String.valueOf(System.getProperty("user.home")) + "/Library/Preferences", "EntityModeler.modelpath"), searchFolders);
        this.fillInSearchFolders(new File(String.valueOf(System.getProperty("user.home")) + "/Library/Preferences", ".EntityModeler.modelpath"), searchFolders);
        return searchFolders;
    }

    protected void fillInSearchFolders(File manifestFile, List<ManifestSearchFolder> searchFolders) throws IOException {
        if (manifestFile.exists()) {
            BufferedReader manifestReader = new BufferedReader(new FileReader(manifestFile));
            try {
                String searchFolderPath;
                while ((searchFolderPath = manifestReader.readLine()) != null) {
                    File searchFolder = new File(searchFolderPath).getAbsoluteFile();
                    if (searchFolder == null || !searchFolder.exists()) continue;
                    searchFolders.add(new ManifestSearchFolder(searchFolder));
                }
            }
            finally {
                manifestReader.close();
            }
        }
    }
}

