/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.outline;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOArgument;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityIndex;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;
import org.objectstyle.wolips.eomodeler.core.utils.BooleanUtils;

public class EOModelOutlineColumnLabelProvider
extends ColumnLabelProvider {
    private TreeViewer _treeViewer;
    private Font _inheritedFont;
    private Font _flattenedFont;
    private Font _flattenedInheritedFont;
    private Font _activeFont;

    public EOModelOutlineColumnLabelProvider(TreeViewer treeViewer) {
        this._treeViewer = treeViewer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this._inheritedFont != null) {
            this._inheritedFont.dispose();
        }
        if (this._flattenedFont != null) {
            this._flattenedFont.dispose();
        }
        if (this._flattenedInheritedFont != null) {
            this._flattenedInheritedFont.dispose();
        }
        if (this._activeFont != null) {
            this._activeFont.dispose();
        }
    }

    public Image getImage(Object element) {
        Object image = element instanceof String ? Activator.getDefault().getImageRegistry().get("eoModel") : (element instanceof EOModel ? Activator.getDefault().getImageRegistry().get("eoModel") : (element instanceof EOEntity ? Activator.getDefault().getImageRegistry().get("eoEntity") : (element instanceof EOAttribute ? Activator.getDefault().getImageRegistry().get("eoAttribute") : (element instanceof EORelationship ? Activator.getDefault().getImageRegistry().get("eoRelationship") : (element instanceof EORelationshipPath ? Activator.getDefault().getImageRegistry().get("eoRelationship") : (element instanceof EOAttributePath ? Activator.getDefault().getImageRegistry().get("eoAttribute") : (element instanceof EOFetchSpecification ? Activator.getDefault().getImageRegistry().get("eoFetchSpec") : (element instanceof EOStoredProcedure ? Activator.getDefault().getImageRegistry().get("eoStoredProcedure") : (element instanceof EOArgument ? Activator.getDefault().getImageRegistry().get("eoAttribute") : (element instanceof EODatabaseConfig ? Activator.getDefault().getImageRegistry().get("eoDatabaseConfig") : (element instanceof EOEntityIndex ? Activator.getDefault().getImageRegistry().get("eoEntityIndex") : null)))))))))));
        return image;
    }

    public String getText(Object _element) {
        String text;
        if (_element instanceof String) {
            text = (String)_element;
        } else if (_element instanceof EOModel) {
            EOModel model = (EOModel)_element;
            text = model.getName();
            if (model.isDirty()) {
                text = String.valueOf(text) + "*";
            }
        } else if (_element instanceof EOEntity) {
            EOEntity entity = (EOEntity)_element;
            text = entity.getName();
        } else if (_element instanceof EOAttribute) {
            EOAttribute attribute = (EOAttribute)_element;
            text = attribute.getName();
        } else if (_element instanceof EORelationship) {
            EORelationship relationship = (EORelationship)_element;
            text = relationship.getName();
        } else if (_element instanceof EORelationshipPath) {
            EORelationshipPath relationshipPath = (EORelationshipPath)_element;
            text = relationshipPath.getChildRelationship().getName();
        } else if (_element instanceof EOAttributePath) {
            EOAttributePath attributePath = (EOAttributePath)_element;
            text = attributePath.getChildAttribute().getName();
        } else if (_element instanceof EOFetchSpecification) {
            EOFetchSpecification fetchSpec = (EOFetchSpecification)_element;
            text = fetchSpec.getName();
        } else if (_element instanceof EOArgument) {
            EOArgument argument = (EOArgument)_element;
            text = argument.getName();
        } else if (_element instanceof EOStoredProcedure) {
            EOStoredProcedure storedProcedure = (EOStoredProcedure)_element;
            text = storedProcedure.getName();
        } else if (_element instanceof EODatabaseConfig) {
            EODatabaseConfig databaseConfig = (EODatabaseConfig)_element;
            text = databaseConfig.getName();
        } else if (_element instanceof EOEntityIndex) {
            EOEntityIndex entityIndex = (EOEntityIndex)_element;
            text = entityIndex.getName();
        } else {
            text = null;
        }
        if (text == null) {
            text = "?";
        }
        return text;
    }

    protected Font getInheritedFont() {
        if (this._inheritedFont == null) {
            Font originalFont = this._treeViewer.getTree().getFont();
            FontData[] fontData = this._treeViewer.getTree().getFont().getFontData();
            this._inheritedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 2);
        }
        return this._inheritedFont;
    }

    protected Font getFlattenedFont() {
        if (this._flattenedFont == null) {
            Font originalFont = this._treeViewer.getTree().getFont();
            FontData[] fontData = this._treeViewer.getTree().getFont().getFontData();
            this._flattenedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        }
        return this._flattenedFont;
    }

    protected Font getFlattenedInheritedFont() {
        if (this._flattenedInheritedFont == null) {
            Font originalFont = this._treeViewer.getTree().getFont();
            FontData[] fontData = this._treeViewer.getTree().getFont().getFontData();
            this._flattenedInheritedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 3);
        }
        return this._flattenedInheritedFont;
    }

    protected Font getActiveFont() {
        if (this._activeFont == null) {
            Font originalFont = this._treeViewer.getTree().getFont();
            FontData[] fontData = this._treeViewer.getTree().getFont().getFontData();
            this._activeFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        }
        return this._activeFont;
    }

    public Font getFont(Object element) {
        Font font = null;
        if (element instanceof EOEntity) {
            EOEntity entity = (EOEntity)element;
            if (BooleanUtils.isTrue(entity.isAbstractEntity())) {
                font = this.getInheritedFont();
            }
        } else if (element instanceof EODatabaseConfig) {
            EODatabaseConfig databaseConfig = (EODatabaseConfig)element;
            if (databaseConfig.isActive()) {
                font = this.getActiveFont();
            }
        } else {
            IEOAttribute attribute = null;
            if (element instanceof IEOAttribute) {
                attribute = (IEOAttribute)element;
            } else if (element instanceof AbstractEOAttributePath) {
                AbstractEOAttributePath attributePath = (AbstractEOAttributePath)element;
                attribute = attributePath.getChildIEOAttribute();
            }
            if (attribute != null) {
                boolean flattened = attribute.isFlattened();
                boolean inherited = attribute.isInherited();
                if (flattened && inherited) {
                    font = this.getFlattenedInheritedFont();
                } else if (flattened) {
                    font = this.getFlattenedFont();
                } else if (inherited) {
                    font = this.getInheritedFont();
                }
            }
        }
        return font;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public boolean isLabelProperty(Object _element, String _property) {
        return false;
    }

    public void removeListener(ILabelProviderListener _listener) {
    }
}

