/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelContainer;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineContentProvider;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineLabelProvider;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineViewerSorter;

public class EOModelTreeViewUpdater {
    private TreeViewer _treeViewer;
    private EOModelOutlineContentProvider _contentProvider;
    private ModelPropertyChangeListener _modelListener;
    private EntityPropertyChangeListener _entityListener;
    private StoredProcedurePropertyChangeListener _storedProcedureListener;
    private EOModel _model;
    private List<EOEntity> _entities;
    private List<EOStoredProcedure> _storedProcedures;
    private boolean _shouldRefresh;

    public EOModelTreeViewUpdater(TreeViewer treeViewer, EOModelOutlineContentProvider contentProvider) {
        this._treeViewer = treeViewer;
        this._contentProvider = contentProvider;
        this._treeViewer.setContentProvider((IContentProvider)contentProvider);
        this._treeViewer.setLabelProvider((IBaseLabelProvider)new EOModelOutlineLabelProvider(this._treeViewer));
        this._treeViewer.setSorter((ViewerSorter)new EOModelOutlineViewerSorter());
        this._modelListener = new ModelPropertyChangeListener();
        this._entityListener = new EntityPropertyChangeListener();
        this._storedProcedureListener = new StoredProcedurePropertyChangeListener();
        this._shouldRefresh = true;
    }

    public void setModel(EOModel model) {
        this.removePropertyChangeListeners();
        this._model = model;
        this.addPropertyChangeListeners();
        if (this._treeViewer != null) {
            this.setInput();
        }
    }

    public void showModelGroup() {
        if (this._model != null) {
            this._treeViewer.setInput((Object)this._model.getModelGroup());
            this._treeViewer.expandToLevel((Object)this._model, 1);
            this._treeViewer.setSelection((ISelection)new StructuredSelection((Object)this._model));
        }
    }

    public void showModel() {
        if (this._model != null) {
            EOModelContainer container = new EOModelContainer(this._model);
            this._treeViewer.setInput((Object)container);
            this._treeViewer.expandToLevel((Object)this._model, 1);
            this._treeViewer.setSelection((ISelection)new StructuredSelection((Object)this._model));
        }
    }

    public void showNonClassProperties() {
        if (this._treeViewer != null && this._contentProvider != null && !this._contentProvider.isShowNonClassProperties()) {
            this._contentProvider.setShowNonClassProperties(true);
            this._treeViewer.refresh(true);
        }
    }

    public void hideNonClassProperties() {
        if (this._treeViewer != null && this._contentProvider != null && this._contentProvider.isShowNonClassProperties()) {
            this._contentProvider.setShowNonClassProperties(false);
            this._treeViewer.refresh(true);
        }
    }

    protected void setInput() {
        this.showModel();
    }

    protected void refreshPropertyChangeListeners() {
        this.removePropertyChangeListeners();
        this.addPropertyChangeListeners();
    }

    public EOModel getModel() {
        return this._model;
    }

    public void dispose() {
        this.removePropertyChangeListeners();
    }

    protected TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    protected void removePropertyChangeListeners() {
        if (this._model != null) {
            this._model.removePropertyChangeListener(this._modelListener);
            for (EOModel model : this._model.getModelGroup().getModels()) {
                model.removePropertyChangeListener(this._modelListener);
                if (this._entities != null) {
                    for (EOEntity entity : this._entities) {
                        entity.removePropertyChangeListener(this._entityListener);
                    }
                }
                if (this._storedProcedures == null) continue;
                for (EOStoredProcedure storedProcedure : this._storedProcedures) {
                    storedProcedure.removePropertyChangeListener(this._storedProcedureListener);
                }
            }
        }
    }

    protected void addPropertyChangeListeners() {
        if (this._model != null) {
            for (EOModel model : this._model.getModelGroup().getModels()) {
                this._entities = new LinkedList<EOEntity>(model.getEntities());
                this._storedProcedures = new LinkedList<EOStoredProcedure>(model.getStoredProcedures());
                if (this._storedProcedures != null) {
                    for (EOStoredProcedure storedProcedure : this._storedProcedures) {
                        storedProcedure.addPropertyChangeListener(this._storedProcedureListener);
                    }
                }
                for (EOEntity entity : this._entities) {
                    entity.addPropertyChangeListener(this._entityListener);
                }
                model.addPropertyChangeListener(this._modelListener);
            }
        }
    }

    protected void refreshRelationshipsForEntity(EOEntity entity) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            treeViewer.refresh((Object)entity, true);
            Object[] expandedElements = treeViewer.getExpandedElements();
            int expandedElementNum = 0;
            while (expandedElementNum < expandedElements.length) {
                EORelationshipPath relationshipPath;
                if (expandedElements[expandedElementNum] instanceof EORelationshipPath && (relationshipPath = (EORelationshipPath)expandedElements[expandedElementNum]).getChildRelationship().getEntity().equals(entity)) {
                    treeViewer.refresh((Object)relationshipPath, true);
                }
                ++expandedElementNum;
            }
        }
    }

    protected void refresh() {
        if (this._shouldRefresh) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh(true);
        }
    }

    protected class EntityPropertyChangeListener
    implements PropertyChangeListener {
        protected EntityPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            TreeViewer treeViewer = EOModelTreeViewUpdater.this.getTreeViewer();
            if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
                String changedPropertyName = event.getPropertyName();
                if ("name".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("fetchSpecifications".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("fetchSpecification".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("attributes".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("attribute".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("relationships".equals(changedPropertyName)) {
                    EOEntity entity = (EOEntity)event.getSource();
                    EOModelTreeViewUpdater.this.refreshRelationshipsForEntity(entity);
                } else if ("relationship".equals(changedPropertyName)) {
                    EOEntity entity = (EOEntity)event.getSource();
                    EOModelTreeViewUpdater.this.refreshRelationshipsForEntity(entity);
                } else if ("entityIndex".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("entityIndexes".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                }
            }
        }
    }

    protected class ModelPropertyChangeListener
    implements PropertyChangeListener {
        protected ModelPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            TreeViewer treeViewer = EOModelTreeViewUpdater.this.getTreeViewer();
            if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
                String changedPropertyName = event.getPropertyName();
                if ("modelSaving".equals(changedPropertyName)) {
                    Boolean saving = (Boolean)event.getNewValue();
                    EOModelTreeViewUpdater.this._shouldRefresh = saving == false;
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("entities".equals(changedPropertyName) || "storedProcedures".equals(changedPropertyName) || "databaseConfigs".equals(changedPropertyName) || "databaseConfig".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                    EOModelTreeViewUpdater.this.refreshPropertyChangeListeners();
                } else if ("activeDatabaseConfig".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("dirty".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                }
            }
        }
    }

    protected class StoredProcedurePropertyChangeListener
    implements PropertyChangeListener {
        protected StoredProcedurePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            TreeViewer treeViewer = EOModelTreeViewUpdater.this.getTreeViewer();
            if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
                String changedPropertyName = event.getPropertyName();
                if ("name".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("arguments".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                } else if ("argument".equals(changedPropertyName)) {
                    EOModelTreeViewUpdater.this.refresh();
                }
            }
        }
    }
}

