/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.utils;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTableViewer;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyViewerSorter;
import org.objectstyle.wolips.eomodeler.utils.TableSortHandler;

public class TableUtils {
    public static TableViewer createTableViewer(Composite parent, String messagePrefix, String tableName, IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, ViewerSorter sorter) {
        return TableUtils.createTableViewer(parent, 65536, messagePrefix, tableName, contentProvider, labelProvider, sorter);
    }

    public static WOTableViewer createTableViewer(Composite parent, int style, String messagePrefix, String tableName, IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, ViewerSorter sorter) {
        return TableUtils.createTableViewer(parent, style, messagePrefix, TableUtils.getColumnsForTableNamed(tableName), contentProvider, labelProvider, sorter);
    }

    public static TableViewer createTableViewer(Composite parent, String messagePrefix, String[] columns, IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, ViewerSorter sorter) {
        return TableUtils.createTableViewer(parent, 65536, messagePrefix, columns, contentProvider, labelProvider, sorter);
    }

    public static WOTableViewer createTableViewer(Composite parent, int style, String messagePrefix, String[] columns, IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, ViewerSorter sorter) {
        WOTableViewer tableViewer = new WOTableViewer(parent, style);
        tableViewer.setColumnProperties(columns);
        if (contentProvider != null) {
            tableViewer.setContentProvider((IContentProvider)contentProvider);
        }
        if (labelProvider != null) {
            tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
        if (sorter != null) {
            tableViewer.setSorter(sorter);
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableUtils.createTableColumns((TableViewer)tableViewer, messagePrefix, columns, sorter instanceof TablePropertyViewerSorter);
        return tableViewer;
    }

    public static void packTableColumns(TableViewer viewer) {
        Table table = viewer.getTable();
        int columnCount = table.getColumnCount();
        int columnNum = 0;
        while (columnNum < columnCount) {
            TableColumn column = table.getColumn(columnNum);
            int originalWidth = column.getWidth();
            column.pack();
            int newWidth = column.getWidth();
            if (newWidth < originalWidth) {
                column.setWidth(originalWidth);
            }
            ++columnNum;
        }
    }

    public static CellEditor getCellEditor(TableViewer tableViewer, String tableName, String propertyName) {
        CellEditor cellEditor = null;
        int columnNumber = TableUtils.getColumnNumberForTablePropertyNamed(tableName, propertyName);
        if (columnNumber != -1) {
            cellEditor = tableViewer.getCellEditors()[columnNumber];
        }
        return cellEditor;
    }

    public static void setCellEditor(String tableName, String propertyName, CellEditor cellEditor, CellEditor[] cellEditors) {
        int columnNumber = TableUtils.getColumnNumberForTablePropertyNamed(tableName, propertyName);
        if (columnNumber == -1) {
            cellEditor.dispose();
        } else {
            cellEditors[columnNumber] = cellEditor;
        }
    }

    public static void createTableColumns(TableViewer viewer, String messagePrefix, String[] properties, boolean addSortHandler) {
        int columnNum = 0;
        while (columnNum < properties.length) {
            TableUtils.createTableColumn(viewer, messagePrefix, properties[columnNum], addSortHandler);
            ++columnNum;
        }
    }

    public static TableColumn createTableColumn(TableViewer viewer, String messagePrefix, String propertyName, boolean addSortHandler) {
        TableColumn column = new TableColumn(viewer.getTable(), 16384);
        column.setMoveable(true);
        String text = messagePrefix == null ? propertyName : Messages.getString(String.valueOf(messagePrefix) + "." + propertyName);
        column.setText(text);
        if (addSortHandler) {
            column.addSelectionListener((SelectionListener)new TableSortHandler(viewer, propertyName));
        }
        return column;
    }

    public static String getPreferenceNameForTableNamed(String tableName) {
        return "EntityModeler." + tableName + ".columns";
    }

    public static void setColumnsForTableNamed(String tableName, String[] properties, boolean defaults) {
        StringBuffer columnsBuf = new StringBuffer();
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            columnsBuf.append(property);
            columnsBuf.append(",");
            ++n2;
        }
        if (columnsBuf.length() > 0) {
            columnsBuf.setLength(columnsBuf.length() - 1);
        }
        String columnsStr = columnsBuf.toString();
        if (defaults) {
            Activator.getDefault().getPreferenceStore().setDefault(TableUtils.getPreferenceNameForTableNamed(tableName), columnsStr);
        } else {
            Activator.getDefault().getPreferenceStore().setValue(TableUtils.getPreferenceNameForTableNamed(tableName), columnsStr);
        }
    }

    public static String[] getColumnsForTableNamed(String tableName) {
        String columnsStr = Activator.getDefault().getPreferenceStore().getString(TableUtils.getPreferenceNameForTableNamed(tableName));
        String[] columns = columnsStr.split(",");
        return columns;
    }

    public static int getColumnNumberForTablePropertyNamed(String tableName, String property) {
        return TableUtils._getColumnNumber(TableUtils.getColumnsForTableNamed(tableName), property);
    }

    public static int _getColumnNumber(String[] properties, String property) {
        int matchingColumnIndex = -1;
        int columnNum = 0;
        while (columnNum < properties.length) {
            if (properties[columnNum].equals(property)) {
                matchingColumnIndex = columnNum;
            }
            ++columnNum;
        }
        return matchingColumnIndex;
    }

    public static void sort(TableViewer tableViewer, String propertyName) {
        TablePropertyViewerSorter sorter = (TablePropertyViewerSorter)tableViewer.getSorter();
        if (sorter != null) {
            sorter.sort(tableViewer, propertyName);
        }
    }

    public static TableColumn getColumn(TableViewer tableViewer, String tableName, String propertyName) {
        Table table = tableViewer.getTable();
        int columnNumber = TableUtils.getColumnNumberForTablePropertyNamed(tableName, propertyName);
        TableColumn column = null;
        if (columnNumber != -1) {
            column = table.getColumn(columnNumber);
        }
        return column;
    }
}

