/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.PatternSet;
import org.objectstyle.woenvironment.env.WOVariables;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.OtherClasspathSet;
import org.objectstyle.woproject.ant.ProjectFormat;
import org.objectstyle.woproject.ant.WOApplication;
import org.objectstyle.woproject.ant.WOTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppFormat
extends ProjectFormat {
    protected HashMap<String, String> templateMap = new HashMap();
    protected HashMap<String, FilterSetCollection> filterMap = new HashMap();
    protected String appPaths;
    protected String frameworkPaths;
    protected String otherClasspaths;

    public AppFormat(WOTask task) {
        super(task);
        this.prepare();
    }

    private void prepare() {
        this.log("AppFormat prepare", 3);
        this.preparePaths();
        this.prepare52();
        this.prepareWindows();
        this.prepareUnix();
        this.prepareMac();
        String infoFile = new File(this.getApplicatonTask().contentsDir(), "Info.plist").getPath();
        this.createMappings(infoFile, String.valueOf(this.woappPlusVersion()) + "/Info.plist", this.infoFilter(null));
        if (((WOApplication)this.task).webXML) {
            String webXMLFile = new File(this.getApplicatonTask().contentsDir(), "web.xml").getPath();
            this.createMappings(webXMLFile, String.valueOf(this.woappPlusVersion()) + "/web.xml", this.webXMLFilter());
        }
    }

    private void preparePaths() {
        this.appPaths = this.buildAppPaths();
        this.frameworkPaths = this.buildFrameworkPaths();
        this.otherClasspaths = this.buildOtherClassPaths();
    }

    private void prepare52() {
        if (this.getApplicatonTask().getWOEnvironment().wo52()) {
            Copy cp = new Copy();
            cp.setProject(this.getApplicatonTask().getProject());
            cp.setTaskName("copy bootstrap");
            cp.setFile(this.getApplicatonTask().getWOEnvironment().bootstrap());
            cp.setTodir(this.getApplicatonTask().taskDir());
            cp.execute();
        }
    }

    protected String buildAppPaths() {
        FileSet fs = null;
        PatternSet.NameEntry includeJar = null;
        PatternSet.NameEntry includeZip = null;
        DirectoryScanner ds = null;
        String[] files = null;
        StringBuffer buf = null;
        try {
            fs = new FileSet();
            fs.setDir(this.getApplicatonTask().contentsDir());
            includeJar = fs.createInclude();
            includeJar.setName("Resources/Java/**/*.jar");
            includeZip = fs.createInclude();
            includeZip.setName("Resources/Java/**/*.zip");
            ds = fs.getDirectoryScanner(this.task.getProject());
            files = ds.getIncludedFiles();
            buf = new StringBuffer();
            buf.append("APPROOT").append(File.separatorChar).append("Resources").append(File.separatorChar).append("Java").append(File.separatorChar).append(System.getProperty("line.separator"));
            int k = 0;
            while (k < 2) {
                int i = 0;
                while (i < files.length) {
                    if (!(k == 0 && files[i].toString().indexOf("webobjects") >= 0 || k == 1 && files[i].toString().indexOf("webobjects") < 0)) {
                        buf.append("APPROOT").append(File.separatorChar).append(files[i]).append(System.getProperty("line.separator"));
                    }
                    ++i;
                }
                ++k;
            }
            String string = buf.toString();
            return string;
        }
        catch (Exception anException) {
            this.log(anException.getMessage(), 1);
        }
        finally {
            fs = null;
            includeJar = null;
            includeZip = null;
            ds = null;
            files = null;
            buf = null;
        }
        return "";
    }

    protected String buildFrameworkPaths() {
        WOVariables variables = this.getApplicatonTask().getWOEnvironment().getWOVariables();
        String relativeEmbeddedFrameworksDir = this.getApplicatonTask().relativeEmbeddedFrameworksDir();
        String result = FrameworkSet.jarsPathForFrameworkSets(this.task.getProject(), relativeEmbeddedFrameworksDir, this.getApplicatonTask().getFrameworkSets(), variables);
        return result;
    }

    protected String buildOtherClassPaths() {
        StringBuffer buf = new StringBuffer();
        List<OtherClasspathSet> classpathSets = this.getApplicatonTask().getOtherClasspath();
        Project project = this.task.getProject();
        HashSet<File> pathSet = new HashSet<File>();
        int size = classpathSets.size();
        try {
            int i = 0;
            while (i < size) {
                OtherClasspathSet cs = classpathSets.get(i);
                cs.collectClassPaths(project, pathSet);
                ++i;
            }
        }
        catch (BuildException be) {
            this.log(be.getMessage(), 1);
        }
        if (pathSet.size() > 0) {
            File[] someFiles = pathSet.toArray(new File[0]);
            size = someFiles.length;
            int i = 0;
            while (i < size) {
                boolean isJar;
                String fileName = this.getApplicatonTask().getWOEnvironment().getWOVariables().encodePathForFile(someFiles[i]);
                boolean bl = isJar = fileName.endsWith(".jar") || fileName.endsWith(".zip");
                if (!isJar && !fileName.endsWith("/")) {
                    fileName = String.valueOf(fileName) + "/";
                }
                buf.append(fileName).append("\r\n");
                ++i;
            }
        }
        return buf.toString();
    }

    private void prepareWindows() {
        File winDir = new File(this.getApplicatonTask().contentsDir(), "Windows");
        String cp = new File(winDir, "CLSSPATH.TXT").getPath();
        this.createMappings(cp, String.valueOf(this.woappPlusVersion()) + "/Contents/Windows/CLSSPATH.TXT", this.classpathFilter('\\'));
        String subp = new File(winDir, "SUBPATHS.TXT").getPath();
        this.createMappings(subp, String.valueOf(this.woappPlusVersion()) + "/Contents/Windows/SUBPATHS.TXT");
        String runScript = new File(winDir, String.valueOf(this.getName()) + ".cmd").getPath();
        this.createMappings(runScript, String.valueOf(this.woappPlusVersion()) + "/Contents/Windows/appstart.cmd", this.startupScriptFilter());
        File taskDir = this.getApplicatonTask().taskDir();
        String startupScriptName = this.getApplicatonTask().startupScriptName;
        if (startupScriptName == null || startupScriptName.length() == 0) {
            startupScriptName = this.getName();
        }
        String topRunScript = new File(taskDir, String.valueOf(startupScriptName) + ".cmd").getPath();
        this.createMappings(topRunScript, String.valueOf(this.woappPlusVersion()) + "/Contents/Windows/appstart.cmd", this.startupScriptFilter());
    }

    private void prepareUnix() {
        File dir = new File(this.getApplicatonTask().contentsDir(), "UNIX");
        String cp = new File(dir, "UNIXClassPath.txt").getPath();
        this.createMappings(cp, String.valueOf(this.woappPlusVersion()) + "/Contents/UNIX/UNIXClassPath.txt", this.classpathFilter('/'));
    }

    private void prepareMac() {
        File macDir = new File(this.getApplicatonTask().contentsDir(), "MacOS");
        String cp = new File(macDir, "MacOSClassPath.txt").getPath();
        this.createMappings(cp, String.valueOf(this.woappPlusVersion()) + "/Contents/MacOS/MacOSClassPath.txt", this.classpathFilter('/'));
        String servercp = new File(macDir, "MacOSXServerClassPath.txt").getPath();
        this.createMappings(servercp, String.valueOf(this.woappPlusVersion()) + "/Contents/MacOS/MacOSXServerClassPath.txt", this.classpathFilter('/'));
        String runScript = new File(macDir, this.getName()).getPath();
        this.createMappings(runScript, String.valueOf(this.woappPlusVersion()) + "/Contents/MacOS/appstart", this.startupScriptFilter());
        File taskDir = this.getApplicatonTask().taskDir();
        String startupScriptName = this.getApplicatonTask().startupScriptName;
        if (startupScriptName == null || startupScriptName.length() == 0) {
            startupScriptName = this.getName();
        }
        String topRunScript = new File(taskDir, startupScriptName).getPath();
        this.createMappings(topRunScript, String.valueOf(this.woappPlusVersion()) + "/Contents/MacOS/appstart", this.startupScriptFilter());
    }

    private FilterSet classpathFilter(char pathSeparator) {
        FilterSet filter = new FilterSet();
        if (pathSeparator == File.separatorChar) {
            filter.addFilter("APP_JAR", this.appPaths);
            filter.addFilter("FRAMEWORK_JAR", this.frameworkPaths);
            filter.addFilter("OTHER_PATHS", this.otherClasspaths);
        } else {
            filter.addFilter("APP_JAR", this.appPaths.replace(File.separatorChar, pathSeparator));
            filter.addFilter("FRAMEWORK_JAR", this.frameworkPaths.replace(File.separatorChar, pathSeparator));
            filter.addFilter("OTHER_PATHS", this.otherClasspaths.replace(File.separatorChar, pathSeparator));
        }
        return filter;
    }

    private String getAppClass() {
        return this.task.getPrincipalClass();
    }

    private String getServletAdaptor() {
        return this.task.getServletAdaptor();
    }

    private void createMappings(String fileName, String template, FilterSet filter) {
        FilterSetCollection fsCollection = new FilterSetCollection(filter);
        FilterSet additionalBuildSettingsFilter = this.additionalBuildSettingsFilter();
        filter.addFilter("APP_CLASS", this.getAppClass());
        filter.addFilter("JAR_NAME", this.getJarName());
        if (additionalBuildSettingsFilter != null) {
            fsCollection.addFilterSet(additionalBuildSettingsFilter);
        }
        this.createMappings(fileName, template, fsCollection);
    }

    private void createMappings(String fileName, String template) {
        this.createMappings(fileName, template, (FilterSetCollection)null);
    }

    private void createMappings(String fileName, String template, FilterSetCollection filter) {
        this.templateMap.put(fileName, template);
        this.filterMap.put(fileName, filter);
    }

    private WOApplication getApplicatonTask() {
        return (WOApplication)this.task;
    }

    @Override
    public Iterator<String> fileIterator() {
        return this.templateMap.keySet().iterator();
    }

    @Override
    public String templateForTarget(String targetName) throws BuildException {
        String template = this.templateMap.get(targetName);
        if (template == null) {
            throw new BuildException("Invalid target, no template found: " + targetName);
        }
        return template;
    }

    @Override
    public FilterSetCollection filtersForTarget(String targetName) throws BuildException {
        if (!this.filterMap.containsKey(targetName)) {
            throw new BuildException("Invalid target: " + targetName);
        }
        return this.filterMap.get(targetName);
    }

    public String woappPlusVersion() {
        if (this.getApplicatonTask().getWOEnvironment().wo5or51()) {
            return "woapp";
        }
        return "woapp_52";
    }

    private FilterSet additionalBuildSettingsFilter() {
        String jvmOptions = this.getApplicatonTask().getJvmOptions();
        String jvm = this.getApplicatonTask().getJVM();
        String jdb = this.getApplicatonTask().getJDB();
        String jdbOptions = this.getApplicatonTask().getJDBOptions();
        String javaVersion = this.getApplicatonTask().getJavaVersion();
        if (jvmOptions != null) {
            FilterSet filter = new FilterSet();
            filter.addFilter("JVM_OPTIONS", jvmOptions);
            filter.addFilter("JVM", jvm);
            filter.addFilter("JDB", jdb);
            filter.addFilter("JDB_OPTIONS", jdbOptions);
            filter.addFilter("JAVA_VERSION", javaVersion);
            return filter;
        }
        return null;
    }

    @Override
    public void release() {
        super.release();
    }

    public FilterSetCollection startupScriptFilter() {
        FilterSet filter = new FilterSet();
        String frameworksBaseURL = this.getApplicatonTask().getFrameworksBaseURL();
        frameworksBaseURL = frameworksBaseURL != null && frameworksBaseURL.length() > 0 ? "-WOFrameworksBaseURL " + frameworksBaseURL : "";
        filter.addFilter("-WOFrameworksBaseURL", frameworksBaseURL);
        return new FilterSetCollection(filter);
    }

    protected String stripPath(String path) {
        path = path.replace("WOROOT", "");
        path = path.replace("APPROOT", "");
        path = path.replace("LOCALROOT", "");
        return path;
    }

    public FilterSetCollection webXMLFilter() {
        int n;
        int n2;
        String[] stringArray;
        FilterSet filter = new FilterSet();
        String WEBINFROOT = "WEBINFROOT";
        LinkedList<String> paths = new LinkedList<String>();
        if (this.appPaths != null && this.appPaths.length() > 0) {
            this.appPaths = this.appPaths.trim();
            stringArray = this.appPaths.split("\n");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String appPath = stringArray[n];
                paths.add(String.valueOf(WEBINFROOT) + this.stripPath(appPath));
                ++n;
            }
        }
        if (this.frameworkPaths != null && this.frameworkPaths.length() > 0) {
            this.frameworkPaths = this.frameworkPaths.trim();
            stringArray = this.frameworkPaths.split("\n");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String frameworkPath = stringArray[n];
                paths.add(String.valueOf(WEBINFROOT) + "/" + this.getApplicatonTask().getName() + ".woa/Contents" + this.stripPath(frameworkPath));
                ++n;
            }
        }
        if (this.otherClasspaths != null && this.otherClasspaths.length() > 0) {
            this.otherClasspaths = this.otherClasspaths.trim();
            stringArray = this.otherClasspaths.split("\n");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String otherPath = stringArray[n];
                paths.add(String.valueOf(WEBINFROOT) + this.stripPath(otherPath));
                ++n;
            }
        }
        StringBuffer pathsBuffer = new StringBuffer();
        for (String path : paths) {
            pathsBuffer.append(path);
            pathsBuffer.append("\n");
        }
        WOApplication woappTask = (WOApplication)this.task;
        this.log(" AppFormat.webXMLFilter().woappTask: " + (Object)((Object)woappTask), 3);
        filter.addFilter("WOROOT", woappTask.getWebXML_WOROOT());
        filter.addFilter("LOCALROOT", woappTask.getWebXML_LOCALROOT());
        filter.addFilter("WOAINSTALLROOT", woappTask.getWebXML_WOAINSTALLROOT());
        filter.addFilter("WOAppMode", woappTask.getWebXML_WOAppMode());
        filter.addFilter("WOClasspath", pathsBuffer.toString());
        filter.addFilter("WOApplicationClass", this.getAppClass());
        filter.addFilter("WOServletAdaptor", this.getServletAdaptor());
        filter.addFilter("WOTagLib", woappTask.getWebXML_WOtaglib());
        String customContent = woappTask.getWebXML_CustomContent();
        if (customContent == null) {
            customContent = "";
        }
        filter.addFilter("CustomContent", customContent);
        return new FilterSetCollection(filter);
    }
}

