/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.JApplicationJavaWorker;
import org.objectstyle.woproject.ant.JApplicationMacWorker;
import org.objectstyle.woproject.ant.JApplicationWindowsWorker;
import org.objectstyle.woproject.ant.JApplicationWorker;

public class JApplication
extends Task {
    public static final String WINDOWS_OS = "windows";
    public static final String MAC_OS = "mac";
    public static final String JAVA_OS = "java";
    protected String name;
    protected String mainClass;
    protected String os;
    protected File destDir;
    protected String longName;
    protected File icon;
    protected String jvm;
    protected String jvmOptions;
    protected String version;
    protected Collection libs = new ArrayList();

    public String getDefaultOs() {
        String vmOS = System.getProperty("os.name").toUpperCase();
        if (vmOS.startsWith("WINDOWS")) {
            return WINDOWS_OS;
        }
        if (vmOS.startsWith("MAC")) {
            return MAC_OS;
        }
        return JAVA_OS;
    }

    public void execute() throws BuildException {
        this.validate();
        this.initDefaults();
        this.log("Building Java Application '" + this.name + "', os: " + this.os + ", dir: " + this.destDir);
        JApplicationWorker worker = WINDOWS_OS.equals(this.os) ? new JApplicationWindowsWorker() : (MAC_OS.equals(this.os) ? new JApplicationMacWorker() : new JApplicationJavaWorker());
        worker.execute(this);
    }

    protected void validate() throws BuildException {
        if (this.isBlankString(this.name)) {
            throw new BuildException("'name' attribute is required");
        }
        this.validateMainClass();
    }

    protected void validateMainClass() throws BuildException {
        if (this.isBlankString(this.mainClass)) {
            throw new BuildException("'mainClass' attribute is required");
        }
        StringTokenizer classToks = new StringTokenizer(this.mainClass, ".");
        while (classToks.hasMoreTokens()) {
            String tok = classToks.nextToken();
            int i = 0;
            while (i < tok.length()) {
                if (i == 0 ? !Character.isJavaIdentifierStart(tok.charAt(0)) : !Character.isJavaIdentifierPart(tok.charAt(i))) {
                    throw new BuildException("Invalid java class name: " + this.mainClass);
                }
                ++i;
            }
        }
    }

    protected void validateOs() throws BuildException {
        if (!(this.os == null || this.os.equals(WINDOWS_OS) || this.os.equals(MAC_OS) || this.os.equals(JAVA_OS))) {
            throw new BuildException("Unsupported OS: " + this.os + ", only the following are supported: " + WINDOWS_OS + "," + MAC_OS + "," + JAVA_OS);
        }
    }

    protected Task createSubtask(Class subtaskClass) throws BuildException {
        Task subtask;
        if (subtaskClass == null) {
            throw new IllegalArgumentException("Null subtask class");
        }
        if (!Task.class.isAssignableFrom(subtaskClass)) {
            throw new IllegalArgumentException("Invalid subtask class, must be a subclass of Task: " + subtaskClass.getName());
        }
        try {
            subtask = (Task)subtaskClass.newInstance();
        }
        catch (Exception e) {
            throw new BuildException("Can't create subtask: " + subtaskClass.getName());
        }
        subtask.setOwningTarget(this.getOwningTarget());
        subtask.setProject(this.getProject());
        subtask.setTaskName(this.getTaskName());
        subtask.setLocation(this.getLocation());
        return subtask;
    }

    protected void initDefaults() {
        if (this.longName == null) {
            this.longName = this.name;
        }
        if (this.destDir == null) {
            this.destDir = this.getProject().getBaseDir();
        }
        if (this.os == null) {
            this.os = this.getDefaultOs();
        }
        if (this.version == null) {
            this.version = "0.0";
        }
        if (this.jvm == null) {
            this.jvm = "1.4+";
        }
    }

    private boolean isBlankString(String string) {
        return string == null || string.trim().length() == 0;
    }

    public Collection getLibs() {
        return this.libs;
    }

    public void addLib(FileSet lib) {
        this.libs.add(lib);
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public File getIcon() {
        return this.icon;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getName() {
        return this.name;
    }

    public String getOs() {
        return this.os;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

