/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.JApplication;
import org.objectstyle.woproject.ant.JApplicationWorker;
import org.objectstyle.woproject.ant.TokenFilter;

class JApplicationMacWorker
implements JApplicationWorker {
    private static final String STUB = "/System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub";
    protected JApplication task;
    protected File contentsDir;
    protected File resourcesDir;
    protected File javaDir;
    protected File macOSDir;
    protected File stub;

    JApplicationMacWorker() {
    }

    public void execute(JApplication task) throws BuildException {
        this.task = task;
        File baseDir = new File(task.getDestDir(), String.valueOf(task.getName()) + ".app");
        this.contentsDir = new File(baseDir, "Contents");
        this.macOSDir = new File(this.contentsDir, "MacOS");
        this.resourcesDir = new File(this.contentsDir, "Resources");
        this.javaDir = new File(this.resourcesDir, "Java");
        this.stub = new File(STUB);
        if (!this.stub.isFile()) {
            throw new BuildException("Java stub file not found. Is this a Mac? /System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub");
        }
        this.createDirectories();
        this.copyStub();
        this.copyIcon();
        this.copyJars();
        this.createInfoPlist();
    }

    void createDirectories() throws BuildException {
        this.createDirectory(this.task.getDestDir());
        this.createDirectory(this.resourcesDir);
        this.createDirectory(this.javaDir);
        this.createDirectory(this.macOSDir);
    }

    void createDirectory(File file) throws BuildException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new BuildException("Can't create directory " + file.getAbsolutePath());
        }
    }

    void createInfoPlist() throws BuildException {
        File targetInfoPlist = new File(this.contentsDir, "Info.plist");
        String targetIcon = this.task.getIcon() != null && this.task.getIcon().isFile() ? this.task.getIcon().getName() : "";
        String jvmOptions = this.task.getJvmOptions() != null ? this.task.getJvmOptions() : "";
        StringBuffer jars = new StringBuffer();
        String[] jarFiles = this.javaDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        int i = 0;
        while (i < jarFiles.length) {
            jars.append("          <string>$JAVAROOT/").append(jarFiles[i]).append("</string>\n");
            ++i;
        }
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("@NAME@", this.task.getName());
        tokens.put("@VERSION@", this.task.getVersion());
        tokens.put("@LONG_NAME@", this.task.getLongName());
        tokens.put("@MAIN_CLASS@", this.task.getMainClass());
        tokens.put("@VERSION@", this.task.getVersion());
        tokens.put("@ICON@", targetIcon);
        tokens.put("@JVM@", this.task.getJvm());
        tokens.put("@JVM_OPTIONS@", jvmOptions);
        tokens.put("@JARS@", jars.toString());
        new TokenFilter(tokens).copy("japplication/mac/Info.plist", targetInfoPlist);
    }

    void copyStub() throws BuildException {
        Copy cp = (Copy)this.task.createSubtask(Copy.class);
        cp.setTodir(this.macOSDir);
        cp.setFile(this.stub);
        cp.execute();
        Chmod chmod = (Chmod)this.task.createSubtask(Chmod.class);
        chmod.setPerm("755");
        chmod.setFile(new File(this.macOSDir, "JavaApplicationStub"));
        chmod.execute();
    }

    void copyIcon() throws BuildException {
        if (this.task.getIcon() != null && this.task.getIcon().isFile()) {
            Copy cp = (Copy)this.task.createSubtask(Copy.class);
            cp.setTodir(this.resourcesDir);
            cp.setFile(this.task.getIcon());
            cp.execute();
        }
    }

    void copyJars() {
        if (!this.task.getLibs().isEmpty()) {
            Copy cp = (Copy)this.task.createSubtask(Copy.class);
            cp.setTodir(this.javaDir);
            cp.setFlatten(true);
            for (FileSet fs : this.task.getLibs()) {
                cp.addFileset(fs);
            }
            cp.execute();
        }
    }
}

