/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.HashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OtherClasspathSet
extends FileSet {
    protected File aDirectory;
    protected boolean packagesOnly = false;
    protected boolean embed = false;
    protected boolean eclipse = false;

    public void setEclipse(boolean eclipse) {
        this.eclipse = eclipse;
    }

    public boolean isEclipse() {
        return this.eclipse;
    }

    private File[] findPackages(Project aProject, String packageDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(new String[]{"**/*.jar", "**/*.zip"});
        ds.setBasedir(this.getDir(aProject) + File.separator + packageDir);
        ds.setCaseSensitive(true);
        ds.scan();
        String[] foundPackages = ds.getIncludedFiles();
        int size = foundPackages.length;
        File[] finalFiles = new File[size];
        int i = 0;
        while (i < size) {
            finalFiles[i] = new File(this.getDir(aProject), foundPackages[i]);
            ++i;
        }
        return finalFiles;
    }

    public void collectClassPaths(Project aProject, HashSet<File> pathSet) throws BuildException {
        DirectoryScanner ds = this.getDirectoryScanner(aProject);
        String[] directories = ds.getIncludedDirectories();
        String[] files = ds.getIncludedFiles();
        int i = 0;
        while (i < directories.length) {
            if (this.isPackagesOnly()) {
                File[] paths = this.findPackages(aProject, directories[i]);
                if (paths == null || paths.length == 0) {
                    this.log("No Jars in project:" + aProject + ", ignoring.", 3);
                } else if (this.getEmbed()) {
                    this.log("embed and isPackagesOnly are mutually exclusive");
                } else {
                    int jsize = paths.length;
                    int k = 0;
                    while (k < jsize) {
                        pathSet.add(paths[k]);
                        ++k;
                    }
                }
            } else {
                File directory = new File(this.getDir(aProject), directories[i]);
                if (directory.exists()) {
                    if (this.getEmbed()) {
                        pathSet.add(new File("APPROOT", directories[i]));
                    } else {
                        pathSet.add(directory);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < files.length) {
            if (!files[i].endsWith(".zip") && !files[i].endsWith(".jar")) {
                this.log("No Jars in " + files[i] + ", ignoring.", 3);
            } else {
                File packageFile = new File(this.getDir(aProject), files[i]);
                if (packageFile.exists()) {
                    pathSet.add(packageFile);
                }
            }
            ++i;
        }
    }

    public boolean isPackagesOnly() {
        return this.packagesOnly;
    }

    public void setDir(File dir) throws BuildException {
        this.aDirectory = dir;
        super.setDir(this.aDirectory);
    }

    public void setRoot(File aRoot) throws BuildException {
        this.aDirectory = aRoot;
        super.setDir(this.aDirectory);
    }

    public void setPackagesOnly(boolean packagesOnly) {
        this.packagesOnly = packagesOnly;
    }

    public void setEmbed(boolean embed) {
        this.embed = embed;
    }

    public boolean getEmbed() {
        return this.embed;
    }
}

