/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woenvironment.pb.PBProject;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.SubtaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBIndex
extends Task {
    protected String name;
    protected File projectFile;
    protected boolean framework;
    protected Vector<FileSet> src = new Vector();
    protected Vector<FileSet> wocomponents = new Vector();
    protected Vector<FileSet> resources = new Vector();
    protected Vector<FileSet> wsresources = new Vector();
    protected Vector<FrameworkSet> frameworkSets = new Vector();
    protected SubtaskFactory subtaskFactory = new SubtaskFactory(this);

    public void addWocomponents(FileSet set) {
        this.wocomponents.addElement(set);
    }

    public void addSrc(FileSet set) {
        this.src.addElement(set);
    }

    public void addResources(FileSet set) {
        this.resources.addElement(set);
    }

    public void addWsresources(FileSet set) {
        this.wsresources.addElement(set);
    }

    public void addFrameworks(FrameworkSet set) {
        this.frameworkSets.addElement(set);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public boolean isFramework() {
        return this.framework;
    }

    public void setFramework(boolean framework) {
        this.framework = framework;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        PBProject proj = null;
        try {
            try {
                proj = this.projectFile != null ? new PBProject(this.projectFile.getPath(), this.framework) : new PBProject(this.framework);
                proj.setProjectName(this.name);
                proj.setClasses(this.extractJavaFiles(this.src));
                proj.setWoComponents(this.extractWOComponents(this.wocomponents));
                proj.setWoAppResources(this.extractResources(this.resources, "**/*.eomodeld/index.eomodeld"));
                proj.setWebServerResources(this.extractResources(this.wsresources, null));
                this.extractFrameworks(proj);
                proj.saveChanges();
            }
            catch (Exception ioex) {
                this.log("Error saving project file", 0);
                throw new BuildException("Error saving project file", (Throwable)ioex);
            }
        }
        finally {
            proj = null;
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.name == null) {
            throw new BuildException("Required 'name' attribute is missing.");
        }
    }

    protected List<String> extractWOComponents(Vector<FileSet> filesets) {
        ArrayList<String> files = new ArrayList<String>();
        for (FileSet fs : filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] dirs = ds.getIncludedDirectories();
            int i = 0;
            while (i < dirs.length) {
                if (dirs[i].endsWith(".wo")) {
                    files.add(this.fixPath(dirs[i]));
                }
                ++i;
            }
        }
        return files;
    }

    protected List<String> extractJavaFiles(Vector<FileSet> filesets) {
        ArrayList<String> files = new ArrayList<String>();
        for (FileSet fs : filesets) {
            fs.createExclude().setName("*.subproj/**");
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] allFiles = ds.getIncludedFiles();
            int i = 0;
            while (i < allFiles.length) {
                if (allFiles[i].endsWith(".java")) {
                    files.add(this.fixPath(allFiles[i]));
                }
                ++i;
            }
        }
        return files;
    }

    protected List<String> extractResources(Vector<FileSet> filesets, String extraExcludes) {
        ArrayList<String> files = new ArrayList<String>();
        if (filesets.size() > 0) {
            for (FileSet fs : filesets) {
                if (extraExcludes != null) {
                    fs.createExclude().setName(extraExcludes);
                }
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                ds.scan();
                String[] allFiles = ds.getIncludedFiles();
                int i = 0;
                while (i < allFiles.length) {
                    files.add(this.fixPath(allFiles[i]));
                    ++i;
                }
                String[] allDirs = ds.getIncludedDirectories();
                int i2 = 0;
                while (i2 < allDirs.length) {
                    files.add(this.fixPath(allDirs[i2]));
                    ++i2;
                }
            }
        }
        return files;
    }

    protected void extractFrameworks(PBProject proj) {
        List projectFrameworkPaths = proj.getFrameworks();
        for (FrameworkSet fs : this.frameworkSets) {
            File baseDir = fs.getDir(fs.getProject());
            String[] frameworkSubPaths = fs.getDirectoryScanner(fs.getProject()).getIncludedDirectories();
            int i = 0;
            while (i < frameworkSubPaths.length) {
                File aFramework = new File(baseDir, frameworkSubPaths[i]);
                if (!projectFrameworkPaths.contains(aFramework.getName())) {
                    projectFrameworkPaths.add(aFramework.getName());
                }
                ++i;
            }
        }
    }

    protected String fixPath(String path) {
        return File.separatorChar == '\\' ? path.replace('\\', '/') : path;
    }
}

