/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.objectstyle.woenvironment.pb.PBXProject;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.SubtaskFactory;
import org.objectstyle.woproject.ant.WOFileSet;

public class PBXIndex
extends Task {
    protected File projectFile;
    protected Vector resources = new Vector();
    protected Vector wsresources = new Vector();
    protected Vector frameworkSets = new Vector();
    protected Vector sources = new Vector();
    protected SubtaskFactory subtaskFactory = new SubtaskFactory(this);

    public void addSources(WOFileSet wofs) {
        this.sources.addElement(wofs);
    }

    public void addResources(WOFileSet wofs) {
        this.resources.addElement(wofs);
    }

    public void addWsResources(WOFileSet wofs) {
        this.wsresources.addElement(wofs);
    }

    public void addFrameworks(FrameworkSet set) {
        this.frameworkSets.addElement(set);
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void execute() throws BuildException {
        File pbxprojFile;
        this.validateAttributes();
        PBXProject proj = new PBXProject();
        this.addToProject(proj);
        if (this.getProjectFile().exists()) {
            if (!this.getProjectFile().isDirectory()) {
                throw new BuildException("Specified PBX project package is not a directory.");
            }
        } else {
            this.getProjectFile().mkdir();
        }
        if (!(pbxprojFile = new File(this.getProjectFile(), "project.pbxproj")).exists()) {
            try {
                pbxprojFile.createNewFile();
            }
            catch (IOException x) {
                throw new BuildException("Failed to create project.pbxproj PBX project package file: " + x);
            }
        }
        try {
            proj.save(pbxprojFile);
        }
        catch (Exception x) {
            throw new BuildException("Failed to save project.pbxproj Xcode project package file: " + x);
        }
    }

    protected void addToProject(PBXProject proj) {
        int i;
        String[] allDirs;
        String[] allFiles;
        DirectoryScanner ds;
        File dir;
        for (WOFileSet wofs : this.sources) {
            if (!wofs.testIfCondition()) continue;
            dir = wofs.getDir(this.getProject());
            ds = wofs.getDirectoryScanner(this.getProject());
            ds.scan();
            allFiles = ds.getIncludedFiles();
            int i2 = 0;
            while (i2 < allFiles.length) {
                proj.addSourceReference(new File(dir, this.fixPath(allFiles[i2])).getAbsolutePath());
                ++i2;
            }
            allDirs = ds.getIncludedDirectories();
            i = 0;
            while (i < allDirs.length) {
                proj.addSourceReference(new File(dir, this.fixPath(allDirs[i])).getAbsolutePath());
                ++i;
            }
        }
        for (WOFileSet wofs : this.resources) {
            if (!wofs.testIfCondition()) continue;
            dir = wofs.getDir(this.getProject());
            ds = wofs.getDirectoryScanner(this.getProject());
            ds.scan();
            allFiles = ds.getIncludedFiles();
            int i3 = 0;
            while (i3 < allFiles.length) {
                proj.addResourceFileReference(new File(dir, this.fixPath(allFiles[i3])).getAbsolutePath());
                ++i3;
            }
            allDirs = ds.getIncludedDirectories();
            i = 0;
            while (i < allDirs.length) {
                proj.addResourceFolderReference(new File(dir, this.fixPath(allDirs[i])).getAbsolutePath());
                ++i;
            }
        }
        for (WOFileSet wofs : this.wsresources) {
            if (!wofs.testIfCondition()) continue;
            dir = wofs.getDir(this.getProject());
            ds = wofs.getDirectoryScanner(this.getProject());
            ds.scan();
            allFiles = ds.getIncludedFiles();
            int i4 = 0;
            while (i4 < allFiles.length) {
                proj.addWSResourceFileReference(new File(dir, this.fixPath(allFiles[i4])).getAbsolutePath());
                ++i4;
            }
            allDirs = ds.getIncludedDirectories();
            i = 0;
            while (i < allDirs.length) {
                proj.addWSResourceFolderReference(new File(dir, this.fixPath(allDirs[i])).getAbsolutePath());
                ++i;
            }
        }
        for (FrameworkSet fs : this.frameworkSets) {
            dir = fs.getDir(this.getProject());
            ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] allDirs2 = ds.getIncludedDirectories();
            int i5 = 0;
            while (i5 < allDirs2.length) {
                proj.addFrameworkReference(new File(dir, this.fixPath(allDirs2[i5])).getAbsolutePath());
                ++i5;
            }
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.projectFile == null) {
            throw new BuildException("Required 'projectFile' attribute is missing.");
        }
    }

    protected String fixPath(String path) {
        return File.separatorChar == '\\' ? path.replace('\\', '/') : path;
    }
}

