/*
 * Decompiled with CFR 0.152.
 */
package org.xiss;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XML {
    public static Doc doc() {
        return new Doc();
    }

    public static Doc doc(String documentString) {
        try {
            Doc doc;
            if (documentString == null || documentString.trim().length() == 0) {
                doc = XML.doc();
            } else {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(documentString)));
                doc = XML.doc(document);
            }
            return doc;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to parse a document from the provided string.", t);
        }
    }

    public static Doc doc(Reader reader) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(reader));
            return XML.doc(document);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to parse a document from the provided reader.", t);
        }
    }

    public static Doc doc(File file) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            return XML.doc(document);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to parse a document from the provided file.", t);
        }
    }

    public static E e(Element w3cElement) {
        E e = XML.e(w3cElement.getNodeName());
        NamedNodeMap attributes = w3cElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            org.w3c.dom.Node w3cAttribute = attributes.item(i);
            String attributeName = w3cAttribute.getNodeName();
            String attributeValue = w3cAttribute.getNodeValue();
            e.set(attributeName, attributeValue);
            ++i;
        }
        NodeList w3cChildren = w3cElement.getChildNodes();
        int i2 = 0;
        while (i2 < w3cChildren.getLength()) {
            org.w3c.dom.Node w3cChild = w3cChildren.item(i2);
            if (w3cChild instanceof org.w3c.dom.Text) {
                e.text(((org.w3c.dom.Text)w3cChild).getNodeValue());
            } else if (w3cChild instanceof CDATASection) {
                e.cdata(((CDATASection)w3cChild).getNodeValue());
            } else if (w3cChild instanceof org.w3c.dom.Comment) {
                e.comment(((org.w3c.dom.Comment)w3cChild).getNodeValue());
            } else if (w3cChild instanceof Element) {
                e.add(XML.e((Element)w3cChild));
            } else {
                throw new IllegalArgumentException("Unable to handle nodes of type '" + w3cChild + "'.");
            }
            ++i2;
        }
        return e;
    }

    public static Doc doc(Document w3cDocument) {
        Element w3cElement = w3cDocument.getDocumentElement();
        Doc doc = XML.doc();
        doc.setRoot(XML.e(w3cElement));
        return doc;
    }

    public static Doc doc(Item ... children) {
        Doc doc = XML.doc();
        Item[] itemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Item child = itemArray[n2];
            doc.add(child);
            ++n2;
        }
        return doc;
    }

    public static Declaration declaration(String version, String encoding) {
        return new Declaration(version, encoding);
    }

    public static E e(String name) {
        return new E(name);
    }

    public static E e(String name, Object ... children) {
        E e = XML.e(name);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof String) {
                e.text((String)child);
            } else if (child instanceof Node) {
                e.add((Node)child);
            } else if (child instanceof Attr) {
                e.add((Attr)child);
            } else {
                throw new IllegalArgumentException("Unable to add the object '" + child + "' to an XML element.");
            }
            ++n2;
        }
        return e;
    }

    public static E e(String name, String text) {
        return new E(name, text);
    }

    public static Attr a(String name, String value) {
        return new Attr(name, value);
    }

    public static Text text(String text) {
        return new Text(text);
    }

    public static CDATA cdata(String cdata) {
        return new CDATA(cdata);
    }

    public static Comment comment(String comment) {
        return new Comment(comment);
    }

    public static class Attr {
        private String _name;
        private String _value;

        public Attr(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String name() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String value() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }
    }

    public static class CDATA
    extends Content {
        public CDATA(String text) {
            super(text);
        }

        protected void writeText(PrintWriter writer) {
            writer.print("<![CDATA[");
            writer.print(this.text());
            writer.println("]]>");
        }

        public org.w3c.dom.Node w3c(Document doc) {
            CDATASection cdata = doc.createCDATASection(this.text());
            return cdata;
        }
    }

    public static class Comment
    extends Content {
        public Comment(String text) {
            super(text);
        }

        protected void writeText(PrintWriter writer) {
            writer.print("<!-- ");
            writer.print(this.text());
            writer.println(" -->");
        }

        public org.w3c.dom.Node w3c(Document doc) {
            org.w3c.dom.Comment comment = doc.createComment(this.text());
            return comment;
        }
    }

    public static abstract class Content
    extends Node {
        private String _text;

        public Content(String text) {
            this._text = text;
        }

        public String text() {
            return this._text;
        }

        public void setText(String text) {
            this._text = text;
        }

        public void visit(Visitor visitor) {
            visitor.visit(this);
        }

        protected abstract void writeText(PrintWriter var1);

        public void write(PrintWriter writer, int indent) {
            if (this._text != null) {
                this.writeIndent(indent, writer);
                this.writeText(writer);
            }
        }
    }

    public static class Declaration
    extends Item {
        private String _version;
        private String _encoding;

        public Declaration(String version, String encoding) {
            this._version = version;
            this._encoding = encoding;
        }

        public String version() {
            return this._version;
        }

        public void setVersion(String version) {
            this._version = version;
        }

        public String encoding() {
            return this._encoding;
        }

        public void setEncoding(String encoding) {
            this._encoding = encoding;
        }

        public void visit(Visitor visitor) {
            visitor.visit(this);
        }

        public void write(PrintWriter writer, int indent) {
            writer.print("<?xml");
            if (this._version != null) {
                writer.print(" version=\"");
                writer.print(this._version);
                writer.print("\"");
            }
            if (this._encoding != null) {
                writer.print(" encoding=\"");
                writer.print(this._encoding);
                writer.print("\"");
            }
            writer.print("?>");
            writer.println();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Doc
    extends Item {
        private E _root;
        private Declaration _declaration;
        private List<Item> _children = new LinkedList<Item>();

        public Doc() {
            this.setDeclaration(new Declaration("1.0", "UTF-8"));
        }

        protected void checkNullRoot() {
            if (this._root != null) {
                throw new IllegalStateException("There is already a root node for this document.");
            }
        }

        public Declaration declaration() {
            return this._declaration;
        }

        public void setDeclaration(Declaration declaration) {
            if (this._declaration != null) {
                this.remove(this._declaration);
            }
            this._declaration = declaration;
            if (this._declaration != null) {
                this._declaration.setParent(this);
                this._children.add(0, this._declaration);
            }
        }

        public E root(String name) {
            this.checkNullRoot();
            E root = XML.e(name);
            this.setRoot(root);
            return root;
        }

        public E root(String name, String value) {
            this.checkNullRoot();
            E root = XML.e(name, value);
            this.setRoot(root);
            return root;
        }

        public E root() {
            return this._root;
        }

        public void setRoot(E root) {
            if (this._root != null) {
                if (root != null) {
                    int rootIndex = this._children.indexOf(this._root);
                    this._children.set(rootIndex, root);
                } else {
                    this._children.remove(this._root);
                }
                this._root = root;
            } else if (root != null) {
                this._root = root;
                this._add(root);
            }
        }

        public Doc comment(String comment) {
            this._add(XML.comment(comment));
            return this;
        }

        public void remove(Item child) {
            this._children.remove(child);
        }

        protected void _add(Item child) {
            child.setParent(this);
            this._children.add(child);
        }

        public <T extends Item> T add(T child) {
            if (this._root == null && child instanceof E) {
                this.setRoot((E)child);
            } else if (child instanceof Declaration) {
                this.setDeclaration((Declaration)child);
            } else {
                this._add(child);
            }
            return child;
        }

        public List<Item> children() {
            return this._children;
        }

        @Override
        public void write(PrintWriter writer, int indent) {
            for (Item item : this._children) {
                item.write(writer, indent);
            }
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visit(this)) {
                for (Item item : this._children) {
                    item.visit(visitor);
                }
            }
        }

        public Document w3c() {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                if (this._children != null) {
                    for (Item child : this._children) {
                        if (!(child instanceof Node)) continue;
                        org.w3c.dom.Node childNode = ((Node)child).w3c(doc);
                        doc.appendChild(childNode);
                    }
                }
                return doc;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Failed to create a W3C Document from the this Doc.", t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class E
    extends Node {
        private String _name;
        private List<Node> _children;
        private List<Attr> _attributes;

        public E(String name) {
            this._name = name;
        }

        public E(String name, String text) {
            this(name);
            this.text(text);
        }

        public void setName(String name) {
            this._name = name;
        }

        public String name() {
            return this._name;
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visit(this) && this._children != null) {
                for (Node node : this._children) {
                    node.visit(visitor);
                }
            }
        }

        public E set(String name, String value) {
            this.remove(name);
            this.add(new Attr(name, value));
            return this;
        }

        public E set(String ... nvPairs) {
            int i = 0;
            while (i < nvPairs.length) {
                String name = nvPairs[i];
                String value = nvPairs[i + 1];
                this.set(name, value);
                i += 2;
            }
            return this;
        }

        public E add(Attr attribute) {
            if (this._attributes == null) {
                this._attributes = new LinkedList<Attr>();
            }
            this._attributes.add(attribute);
            return this;
        }

        public Attr getAttr(String attributeName) {
            if (this._attributes != null) {
                for (Attr attribute : this._attributes) {
                    if (!attribute._name.equals(attributeName)) continue;
                    return attribute;
                }
            }
            return null;
        }

        public Attr remove(String attributeName) {
            Attr attribute = this.getAttr(attributeName);
            if (attribute != null) {
                this.remove(attribute);
            }
            return attribute;
        }

        public void remove(Attr attribute) {
            this._attributes.remove(attribute);
            if (this._attributes.size() == 0) {
                this._attributes = null;
            }
        }

        public String get(String attributeName) {
            Attr attribute = this.getAttr(attributeName);
            String value = null;
            if (attribute != null) {
                value = attribute.value();
            }
            return value;
        }

        public int getInt(String attributeName, int defaultValue) {
            int value = defaultValue;
            String text = this.get(attributeName);
            if (text != null) {
                value = Integer.parseInt(text);
            }
            return value;
        }

        public float getFloat(String attributeName, float defaultValue) {
            float value = defaultValue;
            String text = this.get(attributeName);
            if (text != null) {
                value = Float.parseFloat(text);
            }
            return value;
        }

        public boolean getBoolean(String attributeName, boolean defaultValue) {
            boolean value = defaultValue;
            String text = this.get(attributeName);
            if (text != null) {
                value = Boolean.parseBoolean(text);
            }
            return value;
        }

        public <T extends Enum<T>> T getEnum(String attributeName, Class<T> enumClass, T defaultValue) {
            T value = defaultValue;
            String text = this.get(attributeName);
            if (text != null) {
                value = Enum.valueOf(enumClass, text);
            }
            return value;
        }

        public List<Attr> attributes() {
            return this._attributes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public E setText(String text) {
            if (this._children != null) {
                if (this._children.size() != 1) throw new IllegalStateException("There was more than one child of this element: " + this);
                Node node = this._children.get(0);
                if (!(node instanceof Text)) throw new IllegalStateException("There was already a non-text child of this element: " + node);
                ((Text)node).setText(text);
                return this;
            } else {
                this.text(text);
            }
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Text textNode() {
            Text textNode = null;
            if (this._children == null) return textNode;
            if (this._children.size() != 1) throw new IllegalStateException("There was more than one child of this element: " + this);
            Node node = this._children.get(0);
            if (!(node instanceof Text)) throw new IllegalStateException("There was only a non-text child of this element: " + node);
            return (Text)node;
        }

        public String text() {
            Text textNode = this.textNode();
            String text = textNode != null ? textNode.text() : null;
            return text;
        }

        public List<Node> children() {
            return this._children;
        }

        public String childText(String name) {
            E child = this.child(name);
            return child != null ? child.text() : null;
        }

        public int childInt(String name, int defaultValue) {
            String text;
            int value = defaultValue;
            E child = this.child(name);
            if (child != null && (text = child.text()) != null) {
                value = Integer.parseInt(text);
            }
            return value;
        }

        public float childFloat(String name, float defaultValue) {
            String text;
            float value = defaultValue;
            E child = this.child(name);
            if (child != null && (text = child.text()) != null) {
                value = Float.parseFloat(text);
            }
            return value;
        }

        public boolean childBoolean(String name, boolean defaultValue) {
            String text;
            boolean value = defaultValue;
            E child = this.child(name);
            if (child != null && (text = child.text()) != null) {
                value = Boolean.parseBoolean(text);
            }
            return value;
        }

        public <T extends Enum<T>> T childEnum(String name, Class<T> enumClass, T defaultValue) {
            String text;
            T value = defaultValue;
            E child = this.child(name);
            if (child != null && (text = child.text()) != null) {
                value = Enum.valueOf(enumClass, text);
            }
            return value;
        }

        public E child(String name) {
            E matchingElement = null;
            if (this._children != null) {
                for (Node node : this._children) {
                    if (!(node instanceof E) || !((E)node)._name.equals(name)) continue;
                    if (matchingElement == null) {
                        matchingElement = (E)node;
                        continue;
                    }
                    throw new IllegalStateException("There was more than one child named '" + name + "'.");
                }
            }
            return matchingElement;
        }

        public List<E> children(String name) {
            LinkedList<E> children = new LinkedList<E>();
            if (this._children != null) {
                for (Node node : this._children) {
                    if (!(node instanceof E) || !((E)node)._name.equals(name)) continue;
                    children.add((E)node);
                }
            }
            return children;
        }

        public Set<String> descendentsText(String name) {
            Set<E> descendents = this.descendents(name);
            LinkedHashSet<String> descendentsText = new LinkedHashSet<String>();
            for (E descendent : descendents) {
                descendentsText.add(descendent.text());
            }
            return descendentsText;
        }

        public Set<E> descendents(final String name) {
            final LinkedHashSet<E> descendents = new LinkedHashSet<E>();
            if (this._children != null) {
                Visitor visitor = new Visitor(){

                    public boolean visit(Item item) {
                        if (item instanceof E && ((E)item)._name.equals(name)) {
                            descendents.add((E)item);
                        }
                        return true;
                    }
                };
                for (Node node : this._children) {
                    node.visit(visitor);
                }
            }
            return descendents;
        }

        public E e(String name) {
            return this.add(XML.e(name));
        }

        public E e(String name, String value) {
            return this.add(XML.e(name, value));
        }

        public Text text(String text) {
            return this.add(XML.text(text));
        }

        public CDATA cdata(String cdata) {
            return this.add(XML.cdata(cdata));
        }

        public Comment comment(String comment) {
            return this.add(XML.comment(comment));
        }

        public void remove(Node child) {
            if (this._children != null) {
                this._children.remove(child);
                if (this._children.size() == 0) {
                    this._children = null;
                }
            }
        }

        public <T extends Node> T add(T child) {
            child.setParent(this);
            if (this._children == null) {
                this._children = new LinkedList<Node>();
            }
            this._children.add(child);
            return child;
        }

        protected void writeAttributes(PrintWriter writer) {
            if (this._attributes != null) {
                for (Attr attribute : this._attributes) {
                    writer.print(" ");
                    writer.print(attribute.name());
                    writer.print("=\"");
                    this.writeEscapedString(attribute.value(), writer);
                    writer.print("\"");
                }
            }
        }

        @Override
        public void write(PrintWriter writer, int indent) {
            this.writeIndent(indent, writer);
            if (this._children != null && this._children.size() > 0) {
                writer.print("<");
                writer.print(this._name);
                this.writeAttributes(writer);
                writer.print(">");
                if (this._children.size() == 1 && this._children.get(0) instanceof Text) {
                    this._children.get(0).write(writer, 0);
                } else {
                    writer.println();
                    for (Node node : this._children) {
                        node.write(writer, indent + 1);
                    }
                    this.writeIndent(indent, writer);
                }
                writer.print("</");
                writer.print(this._name);
                writer.println(">");
            } else {
                writer.print("<");
                writer.print(this._name);
                this.writeAttributes(writer);
                writer.println(" />");
            }
        }

        @Override
        public org.w3c.dom.Node w3c(Document doc) {
            Element e = doc.createElement(this._name);
            if (this._attributes != null) {
                for (Attr attribute : this._attributes) {
                    e.setAttribute(attribute.name(), attribute.value());
                }
            }
            if (this._children != null) {
                for (Node child : this._children) {
                    org.w3c.dom.Node childNode = child.w3c(doc);
                    e.appendChild(childNode);
                }
            }
            return e;
        }
    }

    public static abstract class Item {
        private Item _parent;

        protected void setParent(Item parent) {
            this._parent = parent;
        }

        public Item parent() {
            return this._parent;
        }

        public Doc doc() {
            Item item = this;
            Item parent = null;
            while ((parent = item.parent()) != null) {
                item = parent;
            }
            Doc doc = null;
            if (item instanceof Doc) {
                doc = (Doc)item;
            }
            return doc;
        }

        public abstract void write(PrintWriter var1, int var2);

        public abstract void visit(Visitor var1);

        protected void writeEscapedString(String value, PrintWriter writer) {
            if (value != null) {
                int length = value.length();
                int i = 0;
                while (i < length) {
                    char c = value.charAt(i);
                    switch (c) {
                        case '<': {
                            writer.print("&lt;");
                            break;
                        }
                        case '>': {
                            writer.print("&gt;");
                            break;
                        }
                        case '&': {
                            writer.print("&amp;");
                            break;
                        }
                        case '\"': {
                            writer.print("&quot;");
                            break;
                        }
                        default: {
                            writer.print(c);
                        }
                    }
                    ++i;
                }
            }
        }

        protected void writeIndent(int indent, PrintWriter writer) {
            int i = 0;
            while (i < indent) {
                writer.print("  ");
                ++i;
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            this.write(pw, 0);
            return sw.toString();
        }
    }

    public static abstract class Node
    extends Item {
        public abstract org.w3c.dom.Node w3c(Document var1);
    }

    public static class Text
    extends Content {
        public Text(String text) {
            super(text);
        }

        protected void writeText(PrintWriter writer) {
            this.writeEscapedString(this.text(), writer);
        }

        public org.w3c.dom.Node w3c(Document doc) {
            org.w3c.dom.Text text = doc.createTextNode(this.text());
            return text;
        }
    }

    public static interface Visitor {
        public boolean visit(Item var1);
    }
}

