/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLCDATA;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLProcessingInstruction;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCDATAImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCommentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLElementImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLProcessingInstructionImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLTextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyXMLDocumentImpl
implements FuzzyXMLDocument {
    private boolean _isHTML = false;
    private FuzzyXMLElement _root;
    private FuzzyXMLDocType _docType;
    private List<FuzzyXMLModifyListener> _listeners = new ArrayList<FuzzyXMLModifyListener>();

    public FuzzyXMLDocumentImpl(FuzzyXMLElement root, FuzzyXMLDocType docType) {
        this._root = root;
        this._docType = docType;
        if (this._root != null) {
            ((FuzzyXMLElementImpl)this._root).setDocument(this);
            this.setDocument(this._root);
        }
        if (this._docType != null) {
            ((AbstractFuzzyXMLNode)((Object)this._docType)).setDocument(this);
        }
    }

    public void setHTML(boolean isHTML) {
        this._isHTML = isHTML;
    }

    @Override
    public boolean isHTML() {
        return this._isHTML;
    }

    private void setDocument(FuzzyXMLElement element) {
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            ((AbstractFuzzyXMLNode)children[i]).setDocument(this);
            if (!(children[i] instanceof FuzzyXMLElement)) continue;
            this.setDocument((FuzzyXMLElement)children[i]);
        }
        FuzzyXMLAttribute[] attr = element.getAttributes();
        for (int i = 0; i < attr.length; ++i) {
            ((AbstractFuzzyXMLNode)((Object)attr[i])).setDocument(this);
        }
    }

    @Override
    public FuzzyXMLComment createComment(String value) {
        return new FuzzyXMLCommentImpl(value);
    }

    @Override
    public FuzzyXMLElement createElement(String name) {
        return new FuzzyXMLElementImpl(name);
    }

    @Override
    public FuzzyXMLAttribute createAttribute(String namespace, String name) {
        return new FuzzyXMLAttributeImpl(namespace, name, null, null);
    }

    @Override
    public FuzzyXMLText createText(String value) {
        return new FuzzyXMLTextImpl(value);
    }

    @Override
    public FuzzyXMLCDATA createCDATASection(String value) {
        return new FuzzyXMLCDATAImpl(value);
    }

    @Override
    public FuzzyXMLProcessingInstruction createProcessingInstruction(String name, String data) {
        return new FuzzyXMLProcessingInstructionImpl(name, data);
    }

    @Override
    public FuzzyXMLElement getDocumentElement() {
        return this._root;
    }

    @Override
    public FuzzyXMLDocType getDocumentType() {
        return this._docType;
    }

    @Override
    public FuzzyXMLElement getElementByOffset(int offset) {
        if (this._root == null) {
            return null;
        }
        ArrayList<FuzzyXMLElement> matches = new ArrayList<FuzzyXMLElement>();
        matches.add(this._root);
        this.matchOffsetElement(this._root, matches, offset);
        FuzzyXMLNode find = null;
        for (int i = 0; i < matches.size(); ++i) {
            FuzzyXMLElement element = (FuzzyXMLElement)matches.get(i);
            if (find != null && find.getLength() < element.getLength()) continue;
            find = element;
        }
        return find;
    }

    private void matchOffsetElement(FuzzyXMLElement element, List<FuzzyXMLElement> matches, int offset) {
        FuzzyXMLNode[] nodes = element.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            FuzzyXMLElement e;
            if (!(nodes[i] instanceof FuzzyXMLElement) || (e = (FuzzyXMLElement)nodes[i]).getOffset() > offset || offset > e.getOffset() + e.getLength()) continue;
            matches.add(e);
            this.matchOffsetElement(e, matches, offset);
        }
    }

    @Override
    public void addModifyListener(FuzzyXMLModifyListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeModifyListener(FuzzyXMLModifyListener listener) {
        this._listeners.remove(listener);
    }

    public void fireModifyEvent(String newText, int offset, int length) {
        FuzzyXMLModifyEvent evt = new FuzzyXMLModifyEvent(newText, offset, length);
        for (int i = 0; i < this._listeners.size(); ++i) {
            FuzzyXMLModifyListener listener = this._listeners.get(i);
            listener.modified(evt);
        }
    }

    public void appendOffset(FuzzyXMLElement parent, int offset, int append) {
        this.appendOffsetForElement((FuzzyXMLElementImpl)this._root, offset, append);
        this.appendLengthForParent((FuzzyXMLElementImpl)parent, append);
    }

    private void appendOffsetForElement(FuzzyXMLElementImpl element, int offset, int append) {
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getOffset() >= offset) {
                ((AbstractFuzzyXMLNode)children[i]).setOffset(children[i].getOffset() + append);
            }
            if (!(children[i] instanceof FuzzyXMLElementImpl)) continue;
            this.appendOffsetForElement((FuzzyXMLElementImpl)children[i], offset, append);
        }
        FuzzyXMLAttribute[] attr = element.getAttributes();
        for (int i = 0; i < attr.length; ++i) {
            if (attr[i].getOffset() < offset) continue;
            ((AbstractFuzzyXMLNode)((Object)attr[i])).setOffset(attr[i].getOffset() + append);
        }
    }

    private void appendLengthForParent(FuzzyXMLElementImpl parent, int appendLength) {
        parent.setLength(parent.getLength() + appendLength);
        if (parent.getParentNode() != null) {
            this.appendLengthForParent((FuzzyXMLElementImpl)parent.getParentNode(), appendLength);
        }
    }
}

