/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLException;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocumentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.RenderDelegate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;

public class FuzzyXMLElementImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLElement {
    private static final Set<String> FORBIDDEN_SELF_CLOSING = new HashSet<String>(Arrays.asList("a", "div", "span", "script", "pre", "td"));
    private static final Set<String> FORBIDDEN_CLOSE_TAG = new HashSet<String>(Arrays.asList("meta", "link", "base", "basefont", "br", "frame", "hr", "area", "img", "param", "input", "isindex", "col"));
    private List<FuzzyXMLNode> _children = new ArrayList<FuzzyXMLNode>();
    private List<FuzzyXMLAttribute> _attributes = new ArrayList<FuzzyXMLAttribute>();
    private String _name;
    private int _nameOffset;
    private int _openTagLength;
    private int _closeTagOffset;
    private int _closeTagLength;
    private int _closeNameOffset;
    private Boolean _isNonBreaking;
    private boolean _synthetic;

    public FuzzyXMLElementImpl(String name) {
        this(null, name, -1, -1, -1);
    }

    public FuzzyXMLElementImpl(FuzzyXMLNode parent, String name, int offset, int length, int nameOffset) {
        super(parent, offset, length);
        this._name = name;
        this._nameOffset = nameOffset;
        this._closeTagOffset = -1;
        this._closeNameOffset = -1;
        this._openTagLength = length - 2;
    }

    public int getOpenTagLength() {
        return this._openTagLength;
    }

    public int getNameOffset() {
        return this._nameOffset;
    }

    public int getNameLength() {
        return this._name != null ? this._name.length() : 0;
    }

    public boolean hasCloseTag() {
        return this._closeTagOffset != -1 && this._closeTagLength > 0;
    }

    public void setCloseTagOffset(int closeTagOffset) {
        this._closeTagOffset = closeTagOffset;
    }

    public int getCloseTagOffset() {
        return this._closeTagOffset;
    }

    public void setCloseTagLength(int closeTagLength) {
        this._closeTagLength = closeTagLength;
    }

    public int getCloseTagLength() {
        return this._closeTagLength;
    }

    public void setCloseNameOffset(int closeNameOffset) {
        this._closeNameOffset = closeNameOffset;
    }

    public int getCloseNameOffset() {
        return this._closeNameOffset;
    }

    public int getCloseNameLength() {
        return this.getNameLength();
    }

    public String getName() {
        return this._name;
    }

    public void appendChildrenFromText(String text, boolean wo54) {
        if (text.length() == 0) {
            return;
        }
        FuzzyXMLElementImpl test = new FuzzyXMLElementImpl("test");
        this.appendChild(test);
        int offset = test.getOffset();
        this.removeChild(test);
        String parseText = "<root>" + text + "</root>";
        FuzzyXMLElement root = new FuzzyXMLParser(wo54).parse(parseText).getDocumentElement();
        ((AbstractFuzzyXMLNode)((Object)root)).appendOffset(root, 0, -6);
        ((AbstractFuzzyXMLNode)((Object)root)).appendOffset(root, 0, offset);
        FuzzyXMLNode[] nodes = ((FuzzyXMLElement)root.getChildren()[0]).getChildren();
        this.appendOffset(this, offset, text.length());
        for (int i = 0; i < nodes.length; ++i) {
            this.appendChild(nodes[i], false, false);
        }
        this.fireModifyEvent(text, offset, 0);
    }

    public void appendChild(FuzzyXMLNode node) {
        this.appendChild(node, true, true);
    }

    public void appendChildWithNoCheck(FuzzyXMLNode node) {
        this.appendChild(node, true, false);
    }

    private void appendChild(FuzzyXMLNode node, boolean fireEvent, boolean check) {
        if (check) {
            if (((AbstractFuzzyXMLNode)node).getDocument() != null) {
                throw new FuzzyXMLException("Appended node already has a parent.");
            }
            if (node instanceof FuzzyXMLElement && ((FuzzyXMLElement)node).getChildren().length != 0) {
                throw new FuzzyXMLException("Appended node has children.");
            }
        }
        AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)node;
        nodeImpl.setParentNode(this);
        nodeImpl.setDocument(this.getDocument());
        if (node instanceof FuzzyXMLAttribute) {
            this.setAttribute((FuzzyXMLAttribute)node);
        } else {
            if (this._children.contains(node)) {
                return;
            }
            if (this.getDocument() == null) {
                this._children.add(node);
                return;
            }
            FuzzyXMLNode[] nodes = this.getChildren();
            int offset = 0;
            if (nodes.length == 0) {
                int length = this.getLength();
                FuzzyXMLAttribute[] attrs = this.getAttributes();
                offset = this.getOffset() + this.getName().length();
                for (int i = 0; i < attrs.length; ++i) {
                    offset += attrs[i].toXMLString(new RenderContext(this.getDocument().isHTML())).length();
                }
                nodeImpl.setOffset(offset += 2);
                if (fireEvent) {
                    nodeImpl.setLength(node.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
                }
                this._children.add(node);
                String xml = this.toXMLString(new RenderContext(this.getDocument().isHTML()));
                this._children.remove(node);
                if (fireEvent) {
                    this.fireModifyEvent(xml, this.getOffset(), this.getLength());
                    this.appendOffset(this, offset, xml.length() - length);
                }
                this._children.add(node);
            } else {
                for (int i = 0; i < nodes.length; ++i) {
                    offset = nodes[i].getOffset() + nodes[i].getLength();
                }
                if (fireEvent) {
                    this.fireModifyEvent(nodeImpl.toXMLString(new RenderContext(this.getDocument().isHTML())), offset, 0);
                    this.appendOffset(this, offset, node.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
                }
                nodeImpl.setOffset(offset);
                if (fireEvent) {
                    nodeImpl.setLength(node.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
                }
                this._children.add(node);
            }
        }
    }

    public FuzzyXMLAttribute[] getAttributes() {
        return this._attributes.toArray(new FuzzyXMLAttribute[this._attributes.size()]);
    }

    public FuzzyXMLNode getChild(int index) {
        return this._children.get(index);
    }

    public FuzzyXMLElement getChildElement(int index) {
        return (FuzzyXMLElement)this._children.get(index);
    }

    public FuzzyXMLNode[] getChildren() {
        return this._children.toArray(new FuzzyXMLNode[this._children.size()]);
    }

    public boolean hasChildren() {
        return this._children.size() > 0;
    }

    public boolean isEmpty() {
        boolean empty;
        boolean bl = empty = !this.hasChildren();
        if (!empty) {
            empty = true;
            for (FuzzyXMLNode child : this._children) {
                if (child instanceof FuzzyXMLText) {
                    FuzzyXMLText text = (FuzzyXMLText)child;
                    String textValue = text.getValue();
                    if (textValue == null || textValue.trim().length() <= 0) continue;
                    empty = false;
                    break;
                }
                empty = false;
                break;
            }
        }
        return empty;
    }

    public void insertAfter(FuzzyXMLNode newChild, FuzzyXMLNode refChild) {
        if (newChild instanceof FuzzyXMLAttribute || refChild instanceof FuzzyXMLAttribute) {
            return;
        }
        FuzzyXMLNode[] children = this.getChildren();
        FuzzyXMLNode targetNode = null;
        boolean flag = false;
        for (int i = 0; i < children.length; ++i) {
            if (flag) {
                targetNode = children[i];
            }
            if (children[i] != refChild) continue;
            flag = true;
        }
        if (targetNode == null && flag) {
            this.appendChild(newChild);
        } else {
            this.insertBefore(newChild, targetNode);
        }
    }

    public void insertBefore(FuzzyXMLNode newChild, FuzzyXMLNode refChild) {
        if (newChild instanceof FuzzyXMLAttribute || refChild instanceof FuzzyXMLAttribute) {
            return;
        }
        FuzzyXMLNode target = null;
        int index = -1;
        FuzzyXMLNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != refChild) continue;
            target = children[i];
            index = i;
            break;
        }
        if (target == null) {
            return;
        }
        int offset = target.getOffset();
        this.fireModifyEvent(newChild.toXMLString(new RenderContext(this.getDocument().isHTML())), offset, 0);
        AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)newChild;
        nodeImpl.setParentNode(this);
        nodeImpl.setDocument(this.getDocument());
        nodeImpl.setOffset(offset);
        nodeImpl.setLength(newChild.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
        this.appendOffset(this, offset, nodeImpl.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
        this._children.add(index, nodeImpl);
    }

    public void replaceChild(FuzzyXMLNode newChild, FuzzyXMLNode refChild) {
        if (newChild instanceof FuzzyXMLAttribute || refChild instanceof FuzzyXMLAttribute) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this._children.size(); ++i) {
            if (refChild != this._children.get(i)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        this._children.remove(index);
        AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)newChild;
        nodeImpl.setParentNode(this);
        nodeImpl.setDocument(this.getDocument());
        nodeImpl.setOffset(refChild.getOffset());
        nodeImpl.setLength(newChild.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
        this.fireModifyEvent(newChild.toXMLString(new RenderContext(this.getDocument().isHTML())), refChild.getOffset(), refChild.getLength());
        this.appendOffset(this, refChild.getOffset(), newChild.getLength() - refChild.getLength());
        this._children.add(index, newChild);
    }

    public void removeChild(FuzzyXMLNode oldChild) {
        if (oldChild instanceof FuzzyXMLAttribute) {
            this.removeAttributeNode((FuzzyXMLAttribute)oldChild);
            return;
        }
        if (this._children.contains(oldChild)) {
            ((AbstractFuzzyXMLNode)oldChild).setParentNode(null);
            ((AbstractFuzzyXMLNode)oldChild).setDocument(null);
            this._children.remove(oldChild);
            this.fireModifyEvent("", oldChild.getOffset(), oldChild.getLength());
            this.appendOffset(this, oldChild.getOffset(), oldChild.getLength() * -1);
        }
    }

    public void setAttribute(FuzzyXMLAttribute attr) {
        FuzzyXMLAttribute attrNode = this.getAttributeNode(attr.getNamespaceName());
        if (attrNode == null) {
            if (this._attributes.contains(attr)) {
                return;
            }
            if (this.getDocument() == null) {
                this._attributes.add(attr);
                return;
            }
            FuzzyXMLAttributeImpl attrImpl = (FuzzyXMLAttributeImpl)attr;
            attrImpl.setDocument(this.getDocument());
            attrImpl.setParentNode(this);
            FuzzyXMLAttribute[] attrs = this.getAttributes();
            int offset = this.getOffset() + this.getName().length() + 1;
            for (int i = 0; i < attrs.length; ++i) {
                offset += attrs[i].toXMLString(new RenderContext(this.getDocument().isHTML())).length();
            }
            this.fireModifyEvent(attr.toXMLString(new RenderContext(this.getDocument().isHTML())), offset, 0);
            this.appendOffset(this, offset, attr.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
            attrImpl.setOffset(offset);
            attrImpl.setLength(attrImpl.toXMLString(new RenderContext(this.getDocument().isHTML())).length());
            this._attributes.add(attrImpl);
        } else {
            FuzzyXMLAttributeImpl attrImpl = (FuzzyXMLAttributeImpl)attrNode;
            attrImpl.setValue(attr.getValue());
        }
    }

    public FuzzyXMLAttribute getAttributeNode(String name) {
        String namespace;
        int colonIndex = name.indexOf(58);
        if (colonIndex == -1) {
            namespace = null;
        } else {
            namespace = name.substring(0, colonIndex);
            name = name.substring(colonIndex + 1);
        }
        FuzzyXMLAttribute[] attrs = this.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!ComparisonUtils.equals((Object)namespace, (Object)attrs[i].getNamespace()) || !attrs[i].getName().equalsIgnoreCase(name)) continue;
            return attrs[i];
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public void removeAttributeNode(FuzzyXMLAttribute attr) {
        if (this._attributes.contains(attr)) {
            ((AbstractFuzzyXMLNode)((Object)attr)).setParentNode(null);
            ((AbstractFuzzyXMLNode)((Object)attr)).setDocument(null);
            this._attributes.remove(attr);
            this.fireModifyEvent("", attr.getOffset(), attr.getLength());
            this.appendOffset(this, attr.getOffset(), attr.getLength() * -1);
        }
    }

    public String getValue() {
        RenderContext rc = new RenderContext(false);
        rc.setIndent(0);
        rc.setIndentSize(2);
        rc.setSpaceInEmptyTags(true);
        return this.getValue(rc, new StringBuffer());
    }

    public String getValue(RenderContext renderContext, StringBuffer xmlBuffer) {
        StringBuffer sb = new StringBuffer(xmlBuffer);
        int length = xmlBuffer.length();
        FuzzyXMLNode[] children = this.getChildren();
        RenderDelegate delegate = renderContext.getDelegate();
        for (int i = 0; i < children.length; ++i) {
            if (delegate != null && !delegate.renderNode(children[i], renderContext, sb)) continue;
            children[i].toXMLString(renderContext, sb);
        }
        sb.delete(0, length);
        return sb.toString();
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        this.toDebugString(sb, 0);
        return sb.toString();
    }

    public void toDebugString(StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append("  ");
        }
        String name = this.getName();
        if (name != null && name.trim().length() > 0) {
            buffer.append(name);
        } else {
            buffer.append("[unknown: '" + name + "']");
        }
        if (this._attributes != null && this._attributes.size() > 0) {
            buffer.append(", attributes={");
            FuzzyXMLAttribute[] attributes = this.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i].toDebugString(buffer, 0);
                if (i >= attributes.length - 1) continue;
                buffer.append("; ");
            }
            buffer.append("}");
        }
        buffer.append("\n");
        for (FuzzyXMLNode child : this.getChildren()) {
            child.toDebugString(buffer, indent + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXMLString(RenderContext renderContext, StringBuffer xmlBuffer) {
        if (this.isSynthetic()) {
            return;
        }
        boolean isHTML = renderContext.isHtml();
        boolean renderSurroundingTags = true;
        RenderDelegate delegate = renderContext.getDelegate();
        if (delegate != null) {
            renderSurroundingTags = delegate.beforeOpenTag(this, renderContext, xmlBuffer);
        }
        try {
            String tagName = FuzzyXMLUtil.escape(this.getName(), isHTML);
            if (renderContext.isLowercaseTags() && FuzzyXMLUtil.isAllUppercase(tagName)) {
                tagName = tagName.toLowerCase();
            }
            if (renderSurroundingTags) {
                xmlBuffer.append("<").append(tagName);
                FuzzyXMLAttribute[] attrs = this.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    attrs[i].toXMLString(renderContext, xmlBuffer);
                }
            }
            if (this.isSelfClosing()) {
                if (renderSurroundingTags) {
                    if (renderContext.isSpaceInEmptyTags()) {
                        xmlBuffer.append(" ");
                    }
                    xmlBuffer.append("/>");
                }
                xmlBuffer.append(this.getValue(renderContext, xmlBuffer));
            } else {
                if (renderSurroundingTags) {
                    xmlBuffer.append(">");
                }
                if (delegate != null) {
                    delegate.afterOpenTag(this, renderContext, xmlBuffer);
                }
                xmlBuffer.append(this.getValue(renderContext, xmlBuffer));
                if (delegate != null) {
                    delegate.beforeCloseTag(this, renderContext, xmlBuffer);
                }
                if (renderSurroundingTags) {
                    xmlBuffer.append("</").append(tagName).append(">");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (delegate != null) {
                delegate.afterCloseTag(this, renderContext, xmlBuffer);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FuzzyXMLElement) {
            FuzzyXMLElement element = (FuzzyXMLElement)obj;
            if (!element.getName().equals(this.getName())) {
                return false;
            }
            FuzzyXMLNode parent = element.getParentNode();
            if (parent == null) {
                return this.getParentNode() == null;
            }
            if (element.getOffset() == this.getOffset()) {
                return true;
            }
        }
        return false;
    }

    public String getAttributeValue(String name) {
        FuzzyXMLAttribute attr = this.getAttributeNode(name);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public void setAttribute(String namespace, String name, String value) {
        FuzzyXMLAttributeImpl attr = new FuzzyXMLAttributeImpl(namespace, name, value, value);
        this.setAttribute(attr);
    }

    public void removeAttribute(String name) {
        FuzzyXMLAttribute attr = this.getAttributeNode(name);
        if (attr != null) {
            this.removeAttributeNode(attr);
        }
    }

    public void setDocument(FuzzyXMLDocumentImpl doc) {
        super.setDocument(doc);
        FuzzyXMLNode[] nodes = this.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            ((AbstractFuzzyXMLNode)nodes[i]).setDocument(doc);
        }
        FuzzyXMLAttribute[] attrs = this.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ((AbstractFuzzyXMLNode)((Object)attrs[i])).setDocument(doc);
        }
    }

    public String toString() {
        return "element: " + this.getName() + "; attributes = " + this._attributes;
    }

    public void removeAllChildren() {
        FuzzyXMLNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.removeChild(children[i]);
        }
    }

    public Region getRegionAtOffset(int offset, IDocument doc, boolean regionForInsert) throws BadLocationException {
        Region region;
        int openTagOffset = this.getOffset();
        int openTagLength = this.getOpenTagLength() + 2;
        int openTagEndOffset = openTagOffset + openTagLength;
        if (this.hasCloseTag()) {
            int closeTagOffset = this.getCloseTagOffset();
            int closeTagEndOffset = closeTagOffset + this.getCloseTagLength();
            if (!regionForInsert) {
                region = new Region(openTagOffset, closeTagOffset - openTagOffset + this.getCloseTagLength() + 2);
            } else if (offset >= openTagOffset && offset < openTagEndOffset || offset >= closeTagOffset && offset < closeTagEndOffset) {
                IRegion lineRegion;
                int lineEndOffset;
                if (doc != null && openTagEndOffset == (lineEndOffset = (lineRegion = doc.getLineInformationOfOffset(openTagEndOffset)).getOffset() + lineRegion.getLength())) {
                    ++openTagEndOffset;
                    ++openTagLength;
                }
                region = new Region(openTagOffset, openTagLength);
            } else {
                region = new Region(offset, 0);
            }
        } else {
            region = new Region(this.getOffset(), this.getLength());
        }
        return region;
    }

    public boolean isNonBreaking() {
        if (this._isNonBreaking != null) {
            return this._isNonBreaking;
        }
        FuzzyXMLNode[] children = this.getChildren();
        boolean result = false;
        int textblocks = 0;
        int elementcount = 0;
        for (int i = 0; i < children.length; ++i) {
            FuzzyXMLNode child = children[i];
            if (child instanceof FuzzyXMLText) {
                FuzzyXMLText text = (FuzzyXMLText)child;
                if (text.isHidden()) continue;
                ++textblocks;
                if (!text.hasLineBreaks()) continue;
                ++textblocks;
                continue;
            }
            if (!(child instanceof FuzzyXMLElement)) continue;
            FuzzyXMLElement element = (FuzzyXMLElement)child;
            ++elementcount;
            if (FuzzyXMLElementImpl.isSelfClosing(element)) continue;
            ++elementcount;
        }
        result = elementcount <= 1 && textblocks <= 1;
        if (this.getParentNode() == null) {
            result = false;
        }
        this._isNonBreaking = result;
        return this._isNonBreaking;
    }

    public boolean isSelfClosing() {
        return FuzzyXMLElementImpl.isSelfClosing(this);
    }

    public boolean isForbiddenFromHavingChildren() {
        String tagName = this.getName().toLowerCase();
        return FORBIDDEN_CLOSE_TAG.contains(tagName);
    }

    public static boolean isSelfClosing(FuzzyXMLElement node) {
        FuzzyXMLNode[] children = node.getChildren();
        String tagName = node.getName().toLowerCase();
        boolean forbiddenSelfClosing = FORBIDDEN_SELF_CLOSING.contains(tagName);
        boolean alwaysEmptyTag = FORBIDDEN_CLOSE_TAG.contains(tagName);
        return (alwaysEmptyTag || children.length == 0) && !forbiddenSelfClosing;
    }

    public boolean isHidden() {
        return this.getName() == null || this.getName().equals("");
    }

    public void setSynthetic(boolean synthetic) {
        this._synthetic = synthetic;
    }

    public boolean isSynthetic() {
        return this._synthetic;
    }
}

