/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.util;

import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.util.NodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSelectUtil {
    public static FuzzyXMLNode[] getChildren(FuzzyXMLElement element, NodeFilter filter) {
        ArrayList<FuzzyXMLNode> result = new ArrayList<FuzzyXMLNode>();
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!filter.filter(children[i])) continue;
            result.add(children[i]);
        }
        return result.toArray(new FuzzyXMLNode[result.size()]);
    }

    public static FuzzyXMLNode[] getNodeByFilter(FuzzyXMLElement element, NodeFilter filter) {
        ArrayList<FuzzyXMLNode> result = new ArrayList<FuzzyXMLNode>();
        if (filter.filter(element)) {
            result.add(element);
        }
        NodeSelectUtil.searchNodeByFilter(element, filter, result);
        return result.toArray(new FuzzyXMLElement[result.size()]);
    }

    private static void searchNodeByFilter(FuzzyXMLElement element, NodeFilter filter, List<FuzzyXMLNode> result) {
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (filter.filter(children[i])) {
                result.add(children[i]);
            }
            if (!(children[i] instanceof FuzzyXMLElement)) continue;
            NodeSelectUtil.searchNodeByFilter((FuzzyXMLElement)children[i], filter, result);
        }
    }

    public static FuzzyXMLElement getElementById(FuzzyXMLElement element, String id) {
        FuzzyXMLElement[] elements = NodeSelectUtil.getElementByAttribute(element, "id", id);
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    public static FuzzyXMLElement[] getElementByAttribute(FuzzyXMLElement element, String name, String value) {
        ArrayList<FuzzyXMLElement> result = new ArrayList<FuzzyXMLElement>();
        NodeSelectUtil.searchElementByAttribute(element, name, value, result);
        return result.toArray(new FuzzyXMLElement[result.size()]);
    }

    private static void searchElementByAttribute(FuzzyXMLElement element, String name, String value, List<FuzzyXMLElement> result) {
        if (value.equals(element.getAttributeValue(name))) {
            result.add(element);
        }
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof FuzzyXMLElement)) continue;
            NodeSelectUtil.searchElementByAttribute(element, name, value, result);
        }
    }

    public static FuzzyXMLElement[] getElementByTagName(FuzzyXMLElement element, String name) {
        ArrayList<FuzzyXMLElement> result = new ArrayList<FuzzyXMLElement>();
        NodeSelectUtil.searchElementByTagName(element, name, result);
        return result.toArray(new FuzzyXMLElement[result.size()]);
    }

    private static void searchElementByTagName(FuzzyXMLElement element, String name, List<FuzzyXMLElement> result) {
        if (element.getName().equals(name)) {
            result.add(element);
        }
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof FuzzyXMLElement)) continue;
            NodeSelectUtil.searchElementByTagName(element, name, result);
        }
    }
}

