/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.xpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLNodePointer;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class FuzzyXMLNodeIterator
implements NodeIterator {
    private NodePointer _parent;
    private NodeTest _nodeTest;
    private boolean _reverse;
    private int _position = 0;
    private int _index = 0;
    private List<FuzzyXMLNode> _children;
    private Object _child;

    public FuzzyXMLNodeIterator(NodePointer parent, NodeTest nodeTest, boolean reverse, NodePointer startWith) {
        Object node;
        this._parent = parent;
        if (startWith != null) {
            this._child = startWith.getNode();
        }
        this._children = (node = parent.getNode()) instanceof FuzzyXMLDocument ? Arrays.asList(((FuzzyXMLDocument)node).getDocumentElement()) : (node instanceof FuzzyXMLElement ? Arrays.asList(((FuzzyXMLElement)node).getChildren()) : new ArrayList<FuzzyXMLNode>());
        this._nodeTest = nodeTest;
        this._reverse = reverse;
    }

    public int getPosition() {
        return this._position;
    }

    public boolean setPosition(int position) {
        while (this._position < position) {
            if (this.next()) continue;
            return false;
        }
        while (this._position > position) {
            if (this.previous()) continue;
            return false;
        }
        return true;
    }

    public NodePointer getNodePointer() {
        if (this._child == null) {
            if (!this.setPosition(1)) {
                return null;
            }
            this._position = 0;
        }
        return new FuzzyXMLNodePointer(this._parent, this._child);
    }

    private boolean previous() {
        --this._position;
        if (!this._reverse) {
            while (--this._index >= 0) {
                this._child = this._children.get(this._index);
                if (!this.testChild()) continue;
                return true;
            }
        } else {
            while (this._index < this._children.size()) {
                this._child = this._children.get(this._index);
                if (this.testChild()) {
                    return true;
                }
                ++this._index;
            }
        }
        return false;
    }

    private boolean next() {
        ++this._position;
        if (!this._reverse) {
            if (this._position == 1) {
                this._index = 0;
                if (this._child != null) {
                    this._index = this._children.indexOf(this._child) + 1;
                }
            } else {
                ++this._index;
            }
            while (this._index < this._children.size()) {
                this._child = this._children.get(this._index);
                if (this.testChild()) {
                    return true;
                }
                ++this._index;
            }
            return false;
        }
        if (this._position == 1) {
            this._index = this._children.size() - 1;
            if (this._child != null) {
                this._index = this._children.indexOf(this._child) - 1;
            }
        } else {
            --this._index;
        }
        while (this._index >= 0) {
            this._child = this._children.get(this._index);
            if (this.testChild()) {
                return true;
            }
            --this._index;
        }
        return false;
    }

    private boolean testChild() {
        return FuzzyXMLNodePointer.testNode(this._parent, this._child, this._nodeTest);
    }
}

